<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Builder;

trait WilayahScope
{
    /**
     * Scope untuk filter berdasarkan wilayah kerja user
     */
    public function scopeByWilayahKerja(Builder $query, $user)
    {
        // Super admin dan admin desa bisa lihat semua data
        if ($user->role === 'superadmin' || $user->role === 'super_admin' || 
            $user->role === 'admin_desa' || $user->is_admin) {
            return $query;
        }

        // RT hanya bisa lihat data RT-nya sendiri
        if (in_array($user->role, ['ketua_rt', 'rt'])) {
            return $query->where('dusun', $user->dusun)
                        ->where('rw', $user->rw)
                        ->where('rt', $user->rt);
        }

        // RW bisa lihat semua RT dalam RW-nya
        if (in_array($user->role, ['ketua_rw', 'rw'])) {
            return $query->where('dusun', $user->dusun)
                        ->where('rw', $user->rw);
        }

        // Dusun bisa lihat semua RT/RW dalam dusun-nya
        if (in_array($user->role, ['ketua_dusun', 'dusun'])) {
            return $query->where('dusun', $user->dusun);
        }

        // Default: user biasa bisa lihat semua data (atau tidak ada filter)
        return $query;
    }

    /**
     * Scope untuk filter berdasarkan RT
     */
    public function scopeByRt(Builder $query, $rt)
    {
        return $query->where('rt', $rt);
    }

    /**
     * Scope untuk filter berdasarkan RW
     */
    public function scopeByRw(Builder $query, $rw)
    {
        return $query->where('rw', $rw);
    }

    /**
     * Scope untuk filter berdasarkan Dusun
     */
    public function scopeByDusun(Builder $query, $dusun)
    {
        return $query->where('dusun', $dusun);
    }

    /**
     * Scope untuk filter berdasarkan kombinasi RT/RW/Dusun
     */
    public function scopeByRtRwDusun(Builder $query, $rt = null, $rw = null, $dusun = null)
    {
        if ($dusun) $query->where('dusun', $dusun);
        if ($rw) $query->where('rw', $rw);
        if ($rt) $query->where('rt', $rt);
        
        return $query;
    }
}
