<?php

require_once 'vendor/autoload.php';

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Checking UMKM data for produk-umkm create page...\n\n";

// Check UMKM data
$umkmCount = App\Models\Umkm::count();
echo "Total UMKM: " . $umkmCount . "\n";

$aktifUmkm = App\Models\Umkm::aktif()->count();
echo "Aktif UMKM: " . $aktifUmkm . "\n";

if ($aktifUmkm > 0) {
    $umkm = App\Models\Umkm::aktif()->first();
    echo "Sample UMKM: " . $umkm->nama_umkm . "\n";
    echo "Pemilik: " . ($umkm->pemilik ? $umkm->pemilik->nama : 'N/A') . "\n";
} else {
    echo "No active UMKM found!\n";
}

echo "\nChecking authentication...\n";
$user = auth()->user();
if ($user) {
    echo "User authenticated: " . $user->name . "\n";
} else {
    echo "No user authenticated\n";
}

echo "\nDone!\n";
