<?php

return [
    /*
    |--------------------------------------------------------------------------
    | OttoPay Configuration
    |--------------------------------------------------------------------------
    |
    | Konfigurasi untuk payment gateway OttoPay
    |
    */

    'api_key' => env('OTTOPAY_API_KEY', ''),
    'secret_key' => env('OTTOPAY_SECRET_KEY', ''),
    'merchant_code' => env('OTTOPAY_MERCHANT_CODE', ''),
    'mode' => env('OTTOPAY_MODE', 'sandbox'), // sandbox atau production

    /*
    |--------------------------------------------------------------------------
    | API URLs
    |--------------------------------------------------------------------------
    */
    'sandbox_url' => 'https://sandbox-api.ottopay.id',
    'production_url' => 'https://api.ottopay.id',

    /*
    |--------------------------------------------------------------------------
    | Payment Methods
    |--------------------------------------------------------------------------
    */
    'payment_methods' => [
        'VA' => [
            'name' => 'Virtual Account',
            'fee' => 4000,
            'banks' => ['BCA', 'BRI', 'BNI', 'Mandiri', 'Permata', 'CIMB']
        ],
        'QRIS' => [
            'name' => 'QRIS',
            'fee_percentage' => 0.7,
            'description' => 'Pembayaran dengan QR Code'
        ],
        'EWALLET' => [
            'name' => 'E-Wallet',
            'fee_percentage' => 2,
            'providers' => ['OVO', 'DANA', 'GoPay', 'ShopeePay', 'LinkAja']
        ],
        'CREDIT_CARD' => [
            'name' => 'Kartu Kredit',
            'fee_percentage' => 2.9,
            'providers' => ['Visa', 'Mastercard', 'JCB']
        ]
    ],

    /*
    |--------------------------------------------------------------------------
    | Default Settings
    |--------------------------------------------------------------------------
    */
    'default_expired_time' => 24, // hours
    'default_currency' => 'IDR',
    'callback_timeout' => 30, // seconds
]; 