<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('anggota_keluarga', function (Blueprint $table) {
            $table->id();
            $table->string('no_kk', 16);
            $table->string('nik', 16);
            $table->enum('status_keluarga', [
                'Kepala Keluarga', 
                'Istri', 
                'Anak', 
                'Menantu', 
                'Cucu', 
                'Orang Tua', 
                'Mertua', 
                'Famili Lain', 
                'Pembantu', 
                'Lainnya'
            ]);
            $table->timestamps();
            
            $table->foreign('no_kk')->references('no_kk')->on('keluarga');
            $table->foreign('nik')->references('nik')->on('penduduk');
            $table->unique(['no_kk', 'nik']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('anggota_keluarga');
    }
}; 
