<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pelayanan_surat', function (Blueprint $table) {
            $table->id();
            $table->string('nik', 16);
            $table->enum('jenis_surat', [
                'Surat Domisili',
                'SKCK',
                'Surat Kematian',
                'Surat Usaha',
                'Surat Keterangan Tidak Mampu',
                'Surat Keterangan Belum Menikah',
                'Surat Pengantar Nikah',
                'Surat Keterangan Penghasilan',
                'Lainnya'
            ]);
            $table->text('keperluan')->nullable();
            $table->date('tanggal_pengajuan');
            $table->enum('status', ['Menunggu', 'Diproses', 'Selesai', 'Ditolak'])->default('Menunggu');
            $table->text('catatan')->nullable();
            $table->string('file_pdf')->nullable();
            $table->timestamp('tanggal_selesai')->nullable();
            $table->timestamps();
            
            $table->foreign('nik')->references('nik')->on('penduduk');
            $table->index(['status', 'tanggal_pengajuan']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pelayanan_surat');
    }
}; 
