<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('berita', function (Blueprint $table) {
            $table->id();
            $table->string('judul');
            $table->string('slug')->unique();
            $table->text('konten');
            $table->text('ringkasan')->nullable();
            $table->string('gambar')->nullable();
            $table->enum('kategori', [
                'Pengumuman',
                'Kegiatan',
                'Pembangunan',
                'Kesehatan',
                'Pendidikan',
                'UMKM',
                'Sosial',
                'Keamanan',
                'Lainnya'
            ]);
            $table->enum('status', ['Draft', 'Terbit'])->default('Draft');
            $table->unsignedBigInteger('user_id'); // admin yang posting
            $table->timestamp('tanggal_terbit')->nullable();
            $table->integer('views')->default(0);
            $table->timestamps();
            
            $table->index(['status', 'kategori', 'tanggal_terbit']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('berita');
    }
};
