<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('apbdes_rencana', function (Blueprint $table) {
            $table->id();
            $table->year('tahun_anggaran');
            $table->enum('kategori', ['pendapatan', 'belanja', 'pembiayaan']);
            $table->enum('bidang', [
                'pemerintahan', 
                'pembangunan', 
                'pembinaan', 
                'pemberdayaan',
                'dana_desa',
                'add', 
                'pad',
                'surplus_defisit'
            ])->nullable();
            $table->string('kode_rekening', 50);
            $table->string('uraian');
            $table->text('keterangan')->nullable();
            $table->decimal('anggaran', 15, 2)->default(0);
            $table->decimal('realisasi', 15, 2)->default(0);
            $table->decimal('sisa_anggaran', 15, 2)->default(0);
            $table->enum('status', ['aktif', 'nonaktif'])->default('aktif');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            
            $table->index(['tahun_anggaran', 'kategori', 'bidang']);
            $table->index('kode_rekening');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('apbdes_rencana');
    }
}; 