<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('apbdes_realisasi', function (Blueprint $table) {
            $table->id();
            $table->foreignId('apbdes_rencana_id')->constrained('apbdes_rencana')->onDelete('cascade');
            $table->date('tanggal_transaksi');
            $table->string('nomor_bukti', 100);
            $table->text('uraian_transaksi');
            $table->decimal('jumlah', 15, 2);
            $table->enum('jenis', ['pemasukan', 'pengeluaran']);
            $table->string('sumber_dana')->nullable();
            $table->string('penerima_pembayaran')->nullable();
            $table->text('keterangan')->nullable();
            $table->string('bukti_transaksi')->nullable(); // file upload
            $table->enum('status_verifikasi', ['pending', 'verified', 'rejected'])->default('pending');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->timestamp('verified_at')->nullable();
            $table->foreignId('verified_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
            
            $table->index(['tanggal_transaksi', 'jenis']);
            $table->index('nomor_bukti');
            $table->index('status_verifikasi');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('apbdes_realisasi');
    }
}; 