<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('kegiatan_pembangunan', function (Blueprint $table) {
            $table->id();
            $table->string('nama_kegiatan');
            $table->text('deskripsi');
            $table->string('lokasi');
            $table->text('alamat_lengkap');
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->enum('jenis_kegiatan', [
                'fisik', 
                'non_fisik', 
                'infrastruktur', 
                'pemberdayaan',
                'kesehatan',
                'pendidikan',
                'ekonomi'
            ]);
            $table->enum('sumber_dana', [
                'dana_desa',
                'add', 
                'pad',
                'apbd_kabupaten',
                'apbd_provinsi',
                'apbn',
                'swadaya',
                'hibah',
                'csr'
            ]);
            $table->decimal('total_anggaran', 15, 2);
            $table->decimal('realisasi_anggaran', 15, 2)->default(0);
            $table->decimal('sisa_anggaran', 15, 2)->default(0);
            $table->date('tanggal_mulai');
            $table->date('tanggal_selesai_rencana');
            $table->date('tanggal_selesai_aktual')->nullable();
            $table->enum('status', ['perencanaan', 'berjalan', 'selesai', 'tertunda', 'dibatalkan'])->default('perencanaan');
            $table->integer('progres_fisik')->default(0); // 0-100%
            $table->integer('progres_keuangan')->default(0); // 0-100%
            $table->string('pelaksana_kegiatan')->nullable();
            $table->string('penanggung_jawab');
            $table->text('manfaat_kegiatan')->nullable();
            $table->text('kendala')->nullable();
            $table->json('dokumentasi')->nullable(); // array foto
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            
            $table->index(['status', 'jenis_kegiatan']);
            $table->index(['tanggal_mulai', 'tanggal_selesai_rencana']);
            $table->index('sumber_dana');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('kegiatan_pembangunan');
    }
}; 