<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('struktur_organisasi', function (Blueprint $table) {
            $table->id();
            $table->enum('kategori_lembaga', [
                'perangkat_desa',
                'bpd', 
                'lpm',
                'karang_taruna',
                'pkk',
                'rt_rw',
                'tokoh_agama',
                'tokoh_masyarakat'
            ]);
            $table->string('nama_lembaga');
            $table->string('nama_pengurus');
            $table->string('jabatan');
            $table->string('nik', 16)->nullable();
            $table->string('tempat_lahir')->nullable();
            $table->date('tanggal_lahir')->nullable();
            $table->enum('jenis_kelamin', ['L', 'P'])->nullable();
            $table->string('alamat')->nullable();
            $table->string('nomor_hp', 15)->nullable();
            $table->string('email')->nullable();
            $table->enum('pendidikan', [
                'SD', 'SMP', 'SMA', 'D1', 'D2', 'D3', 'S1', 'S2', 'S3'
            ])->nullable();
            $table->string('pekerjaan')->nullable();
            $table->date('tanggal_mulai_jabatan');
            $table->date('tanggal_selesai_jabatan')->nullable();
            $table->enum('status_aktif', ['aktif', 'tidak_aktif'])->default('aktif');
            $table->string('foto')->nullable();
            $table->text('keterangan')->nullable();
            $table->integer('urutan_tampil')->default(0);
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            
            $table->index(['kategori_lembaga', 'status_aktif']);
            $table->index('jabatan');
            $table->index('urutan_tampil');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('struktur_organisasi');
    }
}; 