<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('wilayah_administratif', function (Blueprint $table) {
            $table->id();
            $table->enum('jenis_wilayah', ['dusun', 'rw', 'rt']);
            $table->string('kode_wilayah', 20)->unique();
            $table->string('nama_wilayah');
            $table->foreignId('parent_id')->nullable()->constrained('wilayah_administratif')->onDelete('cascade');
            $table->string('kepala_wilayah')->nullable();
            $table->string('nik_kepala', 16)->nullable();
            $table->string('nomor_hp_kepala', 15)->nullable();
            $table->text('alamat_kantor')->nullable();
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->text('batas_wilayah')->nullable();
            $table->decimal('luas_wilayah', 10, 2)->nullable(); // dalam hektar
            $table->integer('jumlah_kk')->default(0);
            $table->integer('jumlah_penduduk')->default(0);
            $table->enum('status', ['aktif', 'nonaktif'])->default('aktif');
            $table->text('keterangan')->nullable();
            $table->integer('urutan_tampil')->default(0);
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            
            $table->index(['jenis_wilayah', 'status']);
            $table->index('parent_id');
            $table->index('kode_wilayah');
            $table->index('urutan_tampil');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wilayah_administratif');
    }
}; 