<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('notifikasi_wa', function (Blueprint $table) {
            // Add new columns needed for the notification system
            $table->string('nik', 16)->nullable()->after('id');
            $table->string('phone_number', 15)->nullable()->after('nik');
            $table->text('message')->nullable()->after('phone_number');
            $table->string('message_type')->default('general')->after('message');
            $table->boolean('is_read')->default(false)->after('message_type');
            $table->timestamp('sent_at')->nullable()->after('is_read');
            $table->json('response_data')->nullable()->after('sent_at');
            
            // Update existing columns to match new structure
            $table->string('status')->default('pending')->change(); // Change enum to string
            $table->renameColumn('no_wa', 'no_wa_legacy'); // Keep old column for reference
            $table->renameColumn('pesan', 'pesan_legacy'); // Keep old column for reference
            $table->renameColumn('jenis', 'jenis_legacy'); // Keep old column for reference
            
            // Add indexes for better performance
            $table->index(['is_read', 'created_at']);
            $table->index(['status', 'message_type']);
            $table->index(['nik']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('notifikasi_wa', function (Blueprint $table) {
            // Remove new columns
            $table->dropColumn([
                'nik',
                'phone_number', 
                'message',
                'message_type',
                'is_read',
                'sent_at',
                'response_data'
            ]);
            
            // Restore original column names
            $table->renameColumn('no_wa_legacy', 'no_wa');
            $table->renameColumn('pesan_legacy', 'pesan');
            $table->renameColumn('jenis_legacy', 'jenis');
            
            // Drop indexes
            $table->dropIndex(['is_read', 'created_at']);
            $table->dropIndex(['status', 'message_type']);
            $table->dropIndex(['nik']);
        });
    }
}; 