<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pbb', function (Blueprint $table) {
            $table->id();
            $table->string('nop', 18)->unique(); // Nomor Objek Pajak
            $table->string('nik', 16); // NIK pemilik
            $table->string('nama_pemilik');
            $table->text('alamat_objek');
            $table->string('dusun')->nullable();
            $table->string('rt', 5)->nullable();
            $table->string('rw', 5)->nullable();
            
            // Data objek pajak
            $table->decimal('luas_tanah', 10, 2)->default(0); // m2
            $table->decimal('luas_bangunan', 10, 2)->default(0); // m2
            $table->enum('jenis_tanah', ['Sawah', 'Tegalan', 'Pekarangan', 'Perkebunan', 'Hutan', 'Rawa', 'Lainnya'])->default('Pekarangan');
            $table->enum('jenis_bangunan', ['Rumah Tinggal', 'Ruko', 'Pabrik', 'Gudang', 'Pertanian', 'Lainnya', 'Tidak Ada'])->default('Rumah Tinggal');
            
            // Nilai pajak
            $table->decimal('njop_tanah', 15, 2)->default(0); // Nilai Jual Objek Pajak per m2
            $table->decimal('njop_bangunan', 15, 2)->default(0); // Nilai Jual Objek Pajak per m2
            $table->decimal('njop_total', 15, 2)->default(0); // Total NJOP
            $table->decimal('njkp', 15, 2)->default(0); // Nilai Jual Kena Pajak
            $table->decimal('pbb_terhutang', 15, 2)->default(0); // PBB yang harus dibayar
            
            // Status
            $table->enum('status_objek', ['Aktif', 'Tidak Aktif', 'Sengketa'])->default('Aktif');
            $table->text('keterangan')->nullable();
            
            // Koordinat
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            
            $table->timestamps();
            
            $table->foreign('nik')->references('nik')->on('penduduk')->onDelete('cascade');
            $table->index(['dusun', 'rt', 'rw']);
            $table->index('status_objek');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pbb');
    }
}; 