<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('pelayanan_surat', function (Blueprint $table) {
            // Add missing columns that are expected by the controller
            if (!Schema::hasColumn('pelayanan_surat', 'template_id')) {
                $table->unsignedBigInteger('template_id')->nullable()->after('catatan');
                $table->foreign('template_id')->references('id')->on('template_surat')->onDelete('set null');
            }
            
            // Enhanced fields that were already in the model but not in migration
            if (!Schema::hasColumn('pelayanan_surat', 'nomor_surat')) {
                $table->string('nomor_surat', 100)->nullable()->after('template_id');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'template_surat')) {
                $table->unsignedBigInteger('template_surat')->nullable()->after('nomor_surat');
                $table->foreign('template_surat')->references('id')->on('template_surat')->onDelete('set null');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'qr_code')) {
                $table->text('qr_code')->nullable()->after('template_surat');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'tanda_tangan_digital')) {
                $table->string('tanda_tangan_digital')->nullable()->after('qr_code');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'penandatangan_nama')) {
                $table->string('penandatangan_nama')->nullable()->after('tanda_tangan_digital');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'penandatangan_jabatan')) {
                $table->string('penandatangan_jabatan')->nullable()->after('penandatangan_nama');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'penandatangan_nip')) {
                $table->string('penandatangan_nip')->nullable()->after('penandatangan_jabatan');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'file_surat')) {
                $table->string('file_surat')->nullable()->after('penandatangan_nip');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'catatan_internal')) {
                $table->text('catatan_internal')->nullable()->after('file_surat');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'biaya_admin')) {
                $table->decimal('biaya_admin', 10, 2)->nullable()->after('catatan_internal');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'validasi_qr')) {
                $table->boolean('validasi_qr')->default(false)->after('biaya_admin');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable()->after('validasi_qr');
                $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'nama_pemohon')) {
                $table->string('nama_pemohon')->nullable()->after('created_by');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'alamat')) {
                $table->text('alamat')->nullable()->after('nama_pemohon');
            }
            if (!Schema::hasColumn('pelayanan_surat', 'no_telepon')) {
                $table->string('no_telepon', 20)->nullable()->after('alamat');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pelayanan_surat', function (Blueprint $table) {
            $table->dropForeign(['template_id']);
            $table->dropForeign(['template_surat']);
            $table->dropForeign(['created_by']);
            
            $table->dropColumn([
                'template_id',
                'nomor_surat',
                'template_surat',
                'qr_code',
                'tanda_tangan_digital',
                'penandatangan_nama',
                'penandatangan_jabatan',
                'penandatangan_nip',
                'file_surat',
                'catatan_internal',
                'biaya_admin',
                'validasi_qr',
                'created_by',
                'nama_pemohon',
                'alamat',
                'no_telepon'
            ]);
        });
    }
}; 