<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Wilayah kerja untuk RT/RW
            $table->string('dusun')->nullable()->after('alamat');
            $table->string('rt', 5)->nullable()->after('dusun');
            $table->string('rw', 5)->nullable()->after('rt');
            
            // Index untuk performa query
            $table->index(['dusun', 'rt', 'rw']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropIndex(['dusun', 'rt', 'rw']);
            $table->dropColumn(['dusun', 'rt', 'rw']);
        });
    }
};
