<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('template_surat', function (Blueprint $table) {
            $table->id();
            $table->string('nama_template');
            $table->string('jenis_surat');
            $table->string('kode_surat')->unique();
            $table->string('format_nomor')->default('{counter}/{kode}-DESA/{bulan}/{tahun}');
            $table->text('template_content')->nullable();
            $table->json('variabel_tersedia')->nullable();
            $table->string('penandatangan_default')->nullable();
            $table->boolean('aktif')->default(true);
            $table->integer('urutan')->default(0);
            $table->text('keterangan')->nullable();
            $table->string('file_template')->nullable(); // Path ke file PDF template
            $table->string('kategori')->default('Umum');
            $table->timestamps();
            
            $table->index(['jenis_surat', 'aktif']);
            $table->index(['kategori', 'aktif']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('template_surat');
    }
};
