<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if column already exists
        if (!Schema::hasColumn('pelayanan_surat', 'nomor_antrian')) {
            Schema::table('pelayanan_surat', function (Blueprint $table) {
                $table->string('nomor_antrian', 50)->nullable()->after('id');
            });
        }
        
        // Update existing records with generated nomor_antrian
        \DB::statement("UPDATE pelayanan_surat SET nomor_antrian = CONCAT('ANT-', DATE_FORMAT(created_at, '%Y%m%d'), '-', LPAD(id, 3, '0')) WHERE nomor_antrian IS NULL OR nomor_antrian = ''");
        
        // For now, skip unique constraint to avoid issues
        // We'll add it later if needed
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pelayanan_surat', function (Blueprint $table) {
            $table->dropColumn('nomor_antrian');
        });
    }
};
