<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('penduduk', function (Blueprint $table) {
            // Add pendidikan_terakhir column if it doesn't exist
            if (!Schema::hasColumn('penduduk', 'pendidikan_terakhir')) {
                $table->enum('pendidikan_terakhir', [
                    'Tidak Sekolah', 'SD', 'SMP', 'SMA', 'D1', 'D2', 'D3', 'S1', 'S2', 'S3'
                ])->nullable()->after('pendidikan');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('penduduk', function (Blueprint $table) {
            // Drop pendidikan_terakhir column if it exists
            if (Schema::hasColumn('penduduk', 'pendidikan_terakhir')) {
                $table->dropColumn('pendidikan_terakhir');
            }
        });
    }
};
