<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('berita', function (Blueprint $table) {
            $table->string('alt_text')->nullable()->after('gambar');
            $table->enum('prioritas', ['normal', 'penting', 'urgent'])->default('normal')->after('status');
            $table->datetime('tanggal_publish')->nullable()->after('tanggal_terbit');
            $table->string('meta_description', 160)->nullable()->after('konten');
            $table->string('keywords')->nullable()->after('meta_description');
            $table->string('tags')->nullable()->after('keywords');
            $table->boolean('allow_comments')->default(true)->after('tags');
            $table->boolean('is_featured')->default(false)->after('allow_comments');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('berita', function (Blueprint $table) {
            $table->dropColumn([
                'alt_text',
                'prioritas', 
                'tanggal_publish',
                'meta_description',
                'keywords',
                'tags',
                'allow_comments',
                'is_featured'
            ]);
        });
    }
};
