<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Berita;
use App\Models\BeritaComment;

class BeritaCommentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get all berita
        $beritaList = Berita::all();

        if ($beritaList->count() > 0) {
            foreach ($beritaList->take(3) as $berita) {
                // Add 3-5 comments per berita
                $commentCount = rand(3, 5);
                
                for ($i = 1; $i <= $commentCount; $i++) {
                    BeritaComment::create([
                        'berita_id' => $berita->id,
                        'nama' => 'User ' . $i,
                        'email' => 'user' . $i . '@example.com',
                        'phone' => '08123456789' . $i,
                        'komentar' => 'Ini adalah komentar test nomor ' . $i . ' untuk berita ' . $berita->judul,
                        'status' => 'approved',
                        'likes_count' => rand(0, 10),
                        'created_at' => now()->subMinutes(rand(5, 120))
                    ]);
                }
                
                // Update comments count
                $berita->update(['comments_count' => $commentCount]);
            }
        }
    }
} 