-- =====================================================
-- QUERY UNTUK MEMPERBAIKI TABEL PENDUDUK
-- Menambahkan kolom yang hilang dan memperbaiki constraint
-- =====================================================

-- 1. Menambahkan kolom foto_rumah
ALTER TABLE `penduduk` 
ADD COLUMN `foto_rumah` VARCHAR(255) NULL 
AFTER `foto`;

-- 2. Menambahkan kolom pendidikan_terakhir
ALTER TABLE `penduduk` 
ADD COLUMN `pendidikan_terakhir` VARCHAR(50) NULL 
AFTER `pendidikan`;

-- 3. Mengubah kolom no_kk menjadi nullable
ALTER TABLE `penduduk` 
MODIFY COLUMN `no_kk` VARCHAR(16) NULL;

-- 4. Mengubah kolom pekerjaan menjadi nullable
ALTER TABLE `penduduk` 
MODIFY COLUMN `pekerjaan` VARCHAR(100) NULL;

-- 5. Menambahkan kolom status_kawin (jika belum ada)
ALTER TABLE `penduduk` 
ADD COLUMN `status_kawin` ENUM('Belum Kawin', 'Kawin', 'Cerai Hidup', 'Cerai Mati') 
DEFAULT 'Belum Kawin' 
AFTER `jenis_kelamin`;

-- 6. Menambahkan kolom kewarganegaraan (jika belum ada)
ALTER TABLE `penduduk` 
ADD COLUMN `kewarganegaraan` ENUM('WNI', 'WNA') 
DEFAULT 'WNI' 
AFTER `no_wa`;

-- 7. Menambahkan kolom status_hidup (jika belum ada)
ALTER TABLE `penduduk` 
ADD COLUMN `status_hidup` ENUM('Hidup', 'Meninggal') 
DEFAULT 'Hidup' 
AFTER `kewarganegaraan`;

-- 8. Menambahkan kolom golongan_darah (jika belum ada)
ALTER TABLE `penduduk` 
ADD COLUMN `golongan_darah` VARCHAR(2) NULL 
AFTER `status_hidup`;

-- 9. Menambahkan kolom data orang tua (jika belum ada)
ALTER TABLE `penduduk` 
ADD COLUMN `ayah_nik` VARCHAR(16) NULL 
AFTER `no_kk`,
ADD COLUMN `ibu_nik` VARCHAR(16) NULL 
AFTER `ayah_nik`,
ADD COLUMN `nama_ayah` VARCHAR(100) NULL 
AFTER `ayah_nik`,
ADD COLUMN `nama_ibu` VARCHAR(100) NULL 
AFTER `ibu_nik`;

-- 10. Menambahkan kolom hubungan_keluarga (jika belum ada)
ALTER TABLE `penduduk` 
ADD COLUMN `hubungan_keluarga` VARCHAR(50) NULL 
AFTER `nama_ibu`;

-- 11. Menambahkan kolom data akta lahir (jika belum ada)
ALTER TABLE `penduduk` 
ADD COLUMN `no_akta_lahir` VARCHAR(50) NULL 
AFTER `tanggal_lahir`,
ADD COLUMN `tanggal_akta_lahir` DATE NULL 
AFTER `no_akta_lahir`,
ADD COLUMN `tempat_akta_lahir` VARCHAR(100) NULL 
AFTER `tanggal_akta_lahir`;

-- 12. Menambahkan index untuk performa (jika belum ada)
ALTER TABLE `penduduk` 
ADD INDEX `idx_nama_ayah` (`nama_ayah`),
ADD INDEX `idx_nama_ibu` (`nama_ibu`),
ADD INDEX `idx_akta_lahir` (`no_akta_lahir`),
ADD INDEX `idx_status_hidup` (`status_hidup`),
ADD INDEX `idx_status_kawin` (`status_kawin`);

-- =====================================================
-- CATATAN PENTING:
-- 1. Jalankan query ini satu per satu untuk menghindari error
-- 2. Jika ada error "Duplicate column name", berarti kolom sudah ada
-- 3. Jika ada error "Column already exists", skip query tersebut
-- 4. Pastikan backup database sebelum menjalankan query
-- =====================================================
