import 'package:flutter/material.dart';

import '../core/constants/app_colors.dart';
import '../widgets/custom_header.dart';
import '../widgets/bottom_nav_widget.dart';

class DemografiScreen extends StatelessWidget {
  const DemografiScreen({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.gray50,
      body: Stack(
        children: [
          Column(
            children: [
              const CustomHeader(
                showBackButton: true,
                title: 'Demografi',
                subtitle: 'Data Penduduk',
              ),
              Expanded(
                child: Container(
                  padding: const EdgeInsets.all(24),
                  child: const Center(
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Text('👥', style: TextStyle(fontSize: 64)),
                        SizedBox(height: 16),
                        Text(
                          'Demografi Desa',
                          style: TextStyle(
                            fontSize: 24,
                            fontWeight: FontWeight.w700,
                            color: AppColors.gray800,
                            fontFamily: 'Inter',
                          ),
                        ),
                        SizedBox(height: 8),
                        Text(
                          'Sedang dalam pengembangan',
                          style: TextStyle(
                            fontSize: 16,
                            color: AppColors.gray600,
                            fontFamily: 'Inter',
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ),
            ],
          ),
          const Positioned(
            left: 0,
            right: 0,
            bottom: 0,
            child: BottomNavWidget(
              currentRoute: '/demografi',
            ),
          ),
        ],
      ),
    );
  }
}
