<?php
/**
 * Debug 500 Error
 */

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: text/html; charset=utf-8');

?>
<!DOCTYPE html>
<html>
<head>
    <title>Debug 500 Error</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
        .container { max-width: 1000px; margin: 0 auto; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .section { margin: 20px 0; padding: 15px; border: 1px solid #ddd; border-radius: 8px; background: #f9f9f9; }
        .success { color: #28a745; background: #d4edda; padding: 8px; border-radius: 4px; margin: 5px 0; }
        .error { color: #dc3545; background: #f8d7da; padding: 8px; border-radius: 4px; margin: 5px 0; }
        .warning { color: #856404; background: #fff3cd; padding: 8px; border-radius: 4px; margin: 5px 0; }
        .info { color: #0c5460; background: #d1ecf1; padding: 8px; border-radius: 4px; margin: 5px 0; }
        .code { background: #f1f1f1; padding: 8px; border-radius: 4px; font-family: monospace; margin: 5px 0; white-space: pre-wrap; }
        .btn { padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer; margin: 5px; text-decoration: none; display: inline-block; }
        .btn-success { background: #28a745; }
        .btn-danger { background: #dc3545; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Debug 500 Error</h1>
        
        <?php
        try {
            echo "<div class='section'>";
            echo "<h2>📊 Server Information</h2>";
            echo "<div class='code'>";
            echo "PHP Version: " . PHP_VERSION . "\n";
            echo "Server Software: " . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . "\n";
            echo "Document Root: " . ($_SERVER['DOCUMENT_ROOT'] ?? 'Unknown') . "\n";
            echo "Script Path: " . __FILE__ . "\n";
            echo "Current Time: " . date('Y-m-d H:i:s') . "\n";
            echo "Memory Limit: " . ini_get('memory_limit') . "\n";
            echo "Max Execution Time: " . ini_get('max_execution_time') . " seconds\n";
            echo "Upload Max Filesize: " . ini_get('upload_max_filesize') . "\n";
            echo "Post Max Size: " . ini_get('post_max_size') . "\n";
            echo "</div>";
            echo "</div>";
            
            // Check Laravel files
            echo "<div class='section'>";
            echo "<h2>📁 Laravel Files Check</h2>";
            
            $laravelFiles = [
                'bootstrap/app.php' => __DIR__ . '/../bootstrap/app.php',
                'vendor/autoload.php' => __DIR__ . '/../vendor/autoload.php',
                '.env' => __DIR__ . '/../.env',
                'storage/logs/laravel.log' => __DIR__ . '/../storage/logs/laravel.log',
                'storage/framework/cache' => __DIR__ . '/../storage/framework/cache',
                'storage/framework/sessions' => __DIR__ . '/../storage/framework/sessions',
                'storage/framework/views' => __DIR__ . '/../storage/framework/views',
            ];
            
            foreach ($laravelFiles as $name => $path) {
                $exists = file_exists($path);
                $readable = $exists && is_readable($path);
                $writable = $exists && is_writable($path);
                
                echo "<div class='" . ($exists ? 'success' : 'error') . "'>";
                echo "<strong>{$name}:</strong> ";
                echo ($exists ? '✅ EXISTS' : '❌ NOT FOUND') . " | ";
                echo ($readable ? '📖 READABLE' : '❌ NOT READABLE') . " | ";
                echo ($writable ? '✏️ WRITABLE' : '❌ NOT WRITABLE');
                echo "</div>";
            }
            echo "</div>";
            
            // Check Laravel logs
            echo "<div class='section'>";
            echo "<h2>📋 Laravel Logs</h2>";
            
            $logFile = __DIR__ . '/../storage/logs/laravel.log';
            if (file_exists($logFile)) {
                $logContent = file_get_contents($logFile);
                $logSize = filesize($logFile);
                
                echo "<div class='info'>📊 Log file size: " . number_format($logSize / 1024, 2) . " KB</div>";
                
                if ($logSize > 0) {
                    // Get last 50 lines
                    $lines = explode("\n", $logContent);
                    $lastLines = array_slice($lines, -50);
                    $recentLogs = implode("\n", $lastLines);
                    
                    echo "<div class='code'>";
                    echo "Last 50 lines of Laravel log:\n";
                    echo "==========================================\n";
                    echo htmlspecialchars($recentLogs);
                    echo "</div>";
                } else {
                    echo "<div class='warning'>⚠️ Log file is empty</div>";
                }
            } else {
                echo "<div class='error'>❌ Laravel log file not found</div>";
            }
            echo "</div>";
            
            // Check PHP error log
            echo "<div class='section'>";
            echo "<h2>🐛 PHP Error Log</h2>";
            
            $phpErrorLog = ini_get('error_log');
            if ($phpErrorLog && file_exists($phpErrorLog)) {
                $phpLogContent = file_get_contents($phpErrorLog);
                $phpLogSize = filesize($phpErrorLog);
                
                echo "<div class='info'>📊 PHP Error log size: " . number_format($phpLogSize / 1024, 2) . " KB</div>";
                
                if ($phpLogSize > 0) {
                    // Get last 20 lines
                    $lines = explode("\n", $phpLogContent);
                    $lastLines = array_slice($lines, -20);
                    $recentPhpLogs = implode("\n", $lastLines);
                    
                    echo "<div class='code'>";
                    echo "Last 20 lines of PHP error log:\n";
                    echo "==========================================\n";
                    echo htmlspecialchars($recentPhpLogs);
                    echo "</div>";
                } else {
                    echo "<div class='warning'>⚠️ PHP error log is empty</div>";
                }
            } else {
                echo "<div class='warning'>⚠️ PHP error log not found or not configured</div>";
            }
            echo "</div>";
            
            // Test Laravel bootstrap
            echo "<div class='section'>";
            echo "<h2>🚀 Laravel Bootstrap Test</h2>";
            
            try {
                if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
                    require_once __DIR__ . '/../vendor/autoload.php';
                    echo "<div class='success'>✅ Autoloader loaded successfully</div>";
                    
                    if (file_exists(__DIR__ . '/../bootstrap/app.php')) {
                        $app = require_once __DIR__ . '/../bootstrap/app.php';
                        echo "<div class='success'>✅ Laravel app bootstrap successful</div>";
                        
                        try {
                            $app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();
                            echo "<div class='success'>✅ Laravel kernel bootstrap successful</div>";
                            
                            // Test database connection
                            try {
                                $db = $app->make('db');
                                $connection = $db->connection();
                                $connection->getPdo();
                                echo "<div class='success'>✅ Database connection successful</div>";
                            } catch (Exception $e) {
                                echo "<div class='error'>❌ Database connection failed: " . $e->getMessage() . "</div>";
                            }
                            
                        } catch (Exception $e) {
                            echo "<div class='error'>❌ Laravel kernel bootstrap failed: " . $e->getMessage() . "</div>";
                        }
                    } else {
                        echo "<div class='error'>❌ bootstrap/app.php not found</div>";
                    }
                } else {
                    echo "<div class='error'>❌ vendor/autoload.php not found</div>";
                }
            } catch (Exception $e) {
                echo "<div class='error'>❌ Laravel bootstrap failed: " . $e->getMessage() . "</div>";
                echo "<div class='code'>Stack trace:\n" . $e->getTraceAsString() . "</div>";
            }
            echo "</div>";
            
            // Check .env file
            echo "<div class='section'>";
            echo "<h2>⚙️ Environment Configuration</h2>";
            
            $envFile = __DIR__ . '/../.env';
            if (file_exists($envFile)) {
                $envContent = file_get_contents($envFile);
                $envLines = explode("\n", $envContent);
                
                echo "<div class='success'>✅ .env file found</div>";
                
                // Check important configs
                $importantConfigs = [
                    'APP_ENV',
                    'APP_DEBUG',
                    'APP_URL',
                    'DB_CONNECTION',
                    'DB_HOST',
                    'DB_DATABASE',
                    'CACHE_DRIVER',
                    'SESSION_DRIVER',
                ];
                
                echo "<div class='code'>";
                foreach ($importantConfigs as $config) {
                    $value = '';
                    foreach ($envLines as $line) {
                        if (strpos($line, $config . '=') === 0) {
                            $value = trim(substr($line, strlen($config) + 1));
                            break;
                        }
                    }
                    echo "{$config}: " . ($value ?: 'NOT SET') . "\n";
                }
                echo "</div>";
            } else {
                echo "<div class='error'>❌ .env file not found</div>";
            }
            echo "</div>";
            
            // Check file permissions
            echo "<div class='section'>";
            echo "<h2>🔐 File Permissions</h2>";
            
            $directories = [
                'storage' => __DIR__ . '/../storage',
                'storage/logs' => __DIR__ . '/../storage/logs',
                'storage/framework' => __DIR__ . '/../storage/framework',
                'storage/framework/cache' => __DIR__ . '/../storage/framework/cache',
                'storage/framework/sessions' => __DIR__ . '/../storage/framework/sessions',
                'storage/framework/views' => __DIR__ . '/../storage/framework/views',
                'bootstrap/cache' => __DIR__ . '/../bootstrap/cache',
            ];
            
            foreach ($directories as $name => $path) {
                if (file_exists($path)) {
                    $perms = fileperms($path);
                    $readable = is_readable($path);
                    $writable = is_writable($path);
                    
                    echo "<div class='" . ($writable ? 'success' : 'error') . "'>";
                    echo "<strong>{$name}:</strong> ";
                    echo "Permissions: " . substr(sprintf('%o', $perms), -4) . " | ";
                    echo ($readable ? '📖 READABLE' : '❌ NOT READABLE') . " | ";
                    echo ($writable ? '✏️ WRITABLE' : '❌ NOT WRITABLE');
                    echo "</div>";
                } else {
                    echo "<div class='error'>❌ {$name}: Directory not found</div>";
                }
            }
            echo "</div>";
            
        } catch (Exception $e) {
            echo "<div class='error'>❌ Fatal error in debug script: " . $e->getMessage() . "</div>";
            echo "<div class='code'>Stack trace:\n" . $e->getTraceAsString() . "</div>";
        }
        ?>
        
        <div class="section">
            <h2>🔧 Quick Fixes</h2>
            <p><strong>Try these commands to fix common 500 errors:</strong></p>
            
            <div class="code">
# Clear all caches
php artisan config:clear
php artisan route:clear
php artisan view:clear
php artisan cache:clear

# Fix file permissions (Linux/Mac)
chmod -R 755 storage/
chmod -R 755 bootstrap/cache/

# Regenerate autoloader
composer dump-autoload

# Check Laravel logs
tail -f storage/logs/laravel.log
            </div>
            
            <h3>🔗 Useful Links</h3>
            <ul>
                <li><a href="https://susukannet.id/fix-admin-auth.php" target="_blank" class="btn">Fix Admin Auth</a></li>
                <li><a href="https://susukannet.id/test-umkm-images.php" target="_blank" class="btn">Test UMKM Images</a></li>
                <li><a href="https://susukannet.id/test-edit-form.php" target="_blank" class="btn">Test Edit Form</a></li>
            </ul>
        </div>
    </div>
</body>
</html>
