<?php
/**
 * Script untuk memperbaiki masalah gambar UMKM di shared hosting
 * Jalankan script ini setelah deploy ke shared hosting
 */

// Set error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== UMKM Images Fix Script ===\n";
echo "Memperbaiki masalah gambar UMKM di shared hosting...\n\n";

// Paths
$storagePath = __DIR__ . '/../storage/app/public';
$publicStoragePath = __DIR__ . '/storage';

// Create directories if they don't exist
$directories = [
    $storagePath . '/umkm',
    $storagePath . '/umkm/logo',
    $storagePath . '/umkm/galeri',
    $storagePath . '/produk',
    $storagePath . '/produk/galeri',
    $publicStoragePath . '/umkm',
    $publicStoragePath . '/umkm/logo', 
    $publicStoragePath . '/umkm/galeri',
    $publicStoragePath . '/produk',
    $publicStoragePath . '/produk/galeri'
];

foreach ($directories as $dir) {
    if (!is_dir($dir)) {
        if (mkdir($dir, 0755, true)) {
            echo "✓ Created directory: " . $dir . "\n";
        } else {
            echo "✗ Failed to create directory: " . $dir . "\n";
        }
    } else {
        echo "✓ Directory exists: " . $dir . "\n";
    }
}

// Create .htaccess files for image access
$htaccessContent = "Options -Indexes\n<Files \"*\">\n    Require all granted\n</Files>\n<FilesMatch \"\\.(jpg|jpeg|png|gif|webp|svg)$\">\n    Require all granted\n</FilesMatch>\n";

$htaccessDirs = [
    $storagePath . '/umkm',
    $storagePath . '/umkm/logo',
    $storagePath . '/umkm/galeri',
    $storagePath . '/produk',
    $storagePath . '/produk/galeri',
    $publicStoragePath . '/umkm',
    $publicStoragePath . '/umkm/logo',
    $publicStoragePath . '/umkm/galeri',
    $publicStoragePath . '/produk',
    $publicStoragePath . '/produk/galeri'
];

foreach ($htaccessDirs as $dir) {
    $htaccessFile = $dir . '/.htaccess';
    if (file_put_contents($htaccessFile, $htaccessContent)) {
        echo "✓ Created/Updated .htaccess: " . $htaccessFile . "\n";
    } else {
        echo "✗ Failed to create .htaccess: " . $htaccessFile . "\n";
    }
}

// Check storage symlink
if (is_link($publicStoragePath)) {
    echo "✓ Storage symlink exists\n";
} else {
    echo "! Storage symlink not found - please run: php artisan storage:link\n";
}

// Test image access
echo "\n=== Testing Image Access ===\n";

// Test UMKM logo access
$testLogoPath = $publicStoragePath . '/umkm/logo/sample-logo.png';
if (file_exists($testLogoPath)) {
    echo "✓ Test logo file exists: " . $testLogoPath . "\n";
} else {
    echo "! Test logo file not found: " . $testLogoPath . "\n";
}

// Test UMKM gallery access
$testGalleryPath = $publicStoragePath . '/umkm/galeri/sample-gallery1.png';
if (file_exists($testGalleryPath)) {
    echo "✓ Test gallery file exists: " . $testGalleryPath . "\n";
} else {
    echo "! Test gallery file not found: " . $testGalleryPath . "\n";
}

echo "\n=== Fix Complete ===\n";
echo "UMKM images should now be accessible!\n";
echo "If images still don't show, check:\n";
echo "1. Storage symlink: php artisan storage:link\n";
echo "2. File permissions (755 for directories, 644 for files)\n";
echo "3. Web server configuration\n";
echo "4. Check browser developer tools for 404 errors\n";
