

<?php $__env->startSection('title', 'Tambah Template Surat'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.template-surat.index')); ?>">Template Surat</a></li>
    <li class="breadcrumb-item active">Tambah Template</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-plus me-2 text-primary"></i>
            Tambah Template Surat
        </h2>
        <p class="text-muted mb-0">Buat template surat baru untuk mempercepat pembuatan dokumen</p>
    </div>
    <div>
        <a href="<?php echo e(route('admin.template-surat.index')); ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>
            Kembali
        </a>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="card-title mb-0">
                    <i class="fas fa-file-contract me-2"></i>
                    Form Template Surat
                </h5>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.template-surat.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    <div class="row g-4">
                        <!-- Basic Information -->
                        <div class="col-md-6">
                            <label class="form-label">Nama Template <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php $__errorArgs = ['nama_template'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="nama_template" value="<?php echo e(old('nama_template')); ?>" 
                                   placeholder="Contoh: Surat Keterangan Domisili" required>
                            <?php $__errorArgs = ['nama_template'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Jenis Surat <span class="text-danger">*</span></label>
                            <input type="text" class="form-control <?php $__errorArgs = ['jenis_surat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="jenis_surat" value="<?php echo e(old('jenis_surat')); ?>" 
                                   placeholder="Contoh: Surat Keterangan" required>
                            <?php $__errorArgs = ['jenis_surat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Kategori <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['kategori'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="kategori" required>
                                <option value="">Pilih Kategori</option>
                                <option value="Umum" <?php echo e(old('kategori') == 'Umum' ? 'selected' : ''); ?>>Umum</option>
                                <option value="Khusus" <?php echo e(old('kategori') == 'Khusus' ? 'selected' : ''); ?>>Khusus</option>
                                <option value="Resmi" <?php echo e(old('kategori') == 'Resmi' ? 'selected' : ''); ?>>Resmi</option>
                            </select>
                            <?php $__errorArgs = ['kategori'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="status" required>
                                <option value="Aktif" <?php echo e(old('status') == 'Aktif' ? 'selected' : ''); ?>>Aktif</option>
                                <option value="Tidak Aktif" <?php echo e(old('status') == 'Tidak Aktif' ? 'selected' : ''); ?>>Tidak Aktif</option>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="col-12">
                            <label class="form-label">Deskripsi</label>
                            <textarea class="form-control <?php $__errorArgs = ['deskripsi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      name="deskripsi" rows="3" 
                                      placeholder="Deskripsi singkat tentang template ini..."><?php echo e(old('deskripsi')); ?></textarea>
                            <?php $__errorArgs = ['deskripsi'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <!-- Header/Footer -->
                        <div class="col-md-6">
                            <label class="form-label">Kop Surat</label>
                            <textarea class="form-control <?php $__errorArgs = ['kop_surat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      name="kop_surat" rows="4" 
                                      placeholder="Header/kop surat..."><?php echo e(old('kop_surat')); ?></textarea>
                            <?php $__errorArgs = ['kop_surat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="col-md-6">
                            <label class="form-label">Footer Surat</label>
                            <textarea class="form-control <?php $__errorArgs = ['footer_surat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      name="footer_surat" rows="4" 
                                      placeholder="Footer surat..."><?php echo e(old('footer_surat')); ?></textarea>
                            <?php $__errorArgs = ['footer_surat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <!-- Template Content -->
                        <div class="col-12">
                            <label class="form-label">Konten Template <span class="text-danger">*</span></label>
                            <div class="mb-3">
                                <small class="text-muted">
                                    Gunakan variabel berikut dalam template: 
                                    <code>{{nama_pemohon}}</code>, <code>{{nik}}</code>, <code>{{alamat}}</code>, 
                                    <code>{{tempat_lahir}}</code>, <code>{{tanggal_lahir}}</code>, <code>{{jenis_kelamin}}</code>, 
                                    <code>{{agama}}</code>, <code>{{pekerjaan}}</code>, <code>{{keperluan}}</code>, 
                                    <code>{{tanggal_surat}}</code>, <code>{{nomor_surat}}</code>
                                </small>
                            </div>
                            <textarea class="form-control <?php $__errorArgs = ['konten_template'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      name="konten_template" rows="15" required 
                                      placeholder="Masukkan konten template surat di sini..."><?php echo e(old('konten_template')); ?></textarea>
                            <?php $__errorArgs = ['konten_template'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <!-- File Upload -->
                        <div class="col-12">
                            <label class="form-label">File Template (Opsional)</label>
                            <input type="file" class="form-control <?php $__errorArgs = ['file_template'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="file_template" accept=".docx,.doc">
                            <div class="form-text">
                                Upload file template dalam format .docx atau .doc (maksimal 2MB)
                            </div>
                            <?php $__errorArgs = ['file_template'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    
                    <div class="mt-4 d-flex justify-content-between">
                        <a href="<?php echo e(route('admin.template-surat.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>
                            Batal
                        </a>
                        <div>
                            <button type="submit" name="action" value="save_and_continue" class="btn btn-outline-primary me-2">
                                <i class="fas fa-save me-2"></i>
                                Simpan & Lanjutkan Edit
                            </button>
                            <button type="submit" name="action" value="save" class="btn btn-primary">
                                <i class="fas fa-check me-2"></i>
                                Simpan Template
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Variables Helper Modal -->
<div class="modal fade" id="variablesModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-code me-2"></i>
                    Variabel Template
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Data Pemohon</h6>
                        <ul class="list-unstyled">
                            <li><code>{{nama_pemohon}}</code> - Nama lengkap pemohon</li>
                            <li><code>{{nik}}</code> - NIK pemohon</li>
                            <li><code>{{alamat}}</code> - Alamat lengkap</li>
                            <li><code>{{tempat_lahir}}</code> - Tempat lahir</li>
                            <li><code>{{tanggal_lahir}}</code> - Tanggal lahir</li>
                            <li><code>{{jenis_kelamin}}</code> - Jenis kelamin</li>
                            <li><code>{{agama}}</code> - Agama</li>
                            <li><code>{{pekerjaan}}</code> - Pekerjaan</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <h6>Data Surat</h6>
                        <ul class="list-unstyled">
                            <li><code>{{keperluan}}</code> - Keperluan surat</li>
                            <li><code>{{tanggal_surat}}</code> - Tanggal surat</li>
                            <li><code>{{nomor_surat}}</code> - Nomor surat</li>
                            <li><code>{{nama_desa}}</code> - Nama desa</li>
                            <li><code>{{nama_kecamatan}}</code> - Nama kecamatan</li>
                            <li><code>{{nama_kabupaten}}</code> - Nama kabupaten</li>
                            <li><code>{{nama_kepala_desa}}</code> - Nama kepala desa</li>
                        </ul>
                    </div>
                </div>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    Salin dan tempel variabel di atas ke dalam konten template sesuai kebutuhan.
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add variables helper button
    const contentLabel = document.querySelector('label[for="konten_template"]') || 
                        document.querySelector('textarea[name="konten_template"]').previousElementSibling;
    
    if (contentLabel) {
        const helpButton = document.createElement('button');
        helpButton.type = 'button';
        helpButton.className = 'btn btn-sm btn-outline-info ms-2';
        helpButton.innerHTML = '<i class="fas fa-question-circle me-1"></i> Lihat Variabel';
        helpButton.onclick = function() {
            const modal = new bootstrap.Modal(document.getElementById('variablesModal'));
            modal.show();
        };
        contentLabel.appendChild(helpButton);
    }
    
    // Auto-resize textarea
    const textarea = document.querySelector('textarea[name="konten_template"]');
    if (textarea) {
        textarea.addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = (this.scrollHeight) + 'px';
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/template-surat/create.blade.php ENDPATH**/ ?>