

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.mutasi-penduduk.index')); ?>">Mutasi Penduduk</a></li>
                        <li class="breadcrumb-item active">Detail Mutasi</li>
                    </ol>
                </div>
                <h4 class="page-title">Detail Mutasi Penduduk</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-sm-6">
                            <h4 class="header-title">Informasi Mutasi</h4>
                        </div>
                        <div class="col-sm-6">
                            <div class="text-sm-end">
                                <a href="<?php echo e(route('admin.mutasi-penduduk.edit', $mutasiPenduduk->id)); ?>" class="btn btn-warning me-1">
                                    <i class="mdi mdi-pencil me-1"></i> Edit
                                </a>
                                <a href="<?php echo e(route('admin.mutasi-penduduk.index')); ?>" class="btn btn-secondary">
                                    <i class="mdi mdi-arrow-left me-1"></i> Kembali
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-8">
                            <!-- Informasi Penduduk -->
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Data Penduduk</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-2">
                                                <strong>NIK:</strong><br>
                                                <?php echo e($mutasiPenduduk->nik); ?>

                                            </div>
                                            <div class="mb-2">
                                                <strong>Nama:</strong><br>
                                                <?php echo e($mutasiPenduduk->penduduk->nama ?? 'Data tidak ditemukan'); ?>

                                            </div>
                                            <?php if($mutasiPenduduk->penduduk): ?>
                                            <div class="mb-2">
                                                <strong>Jenis Kelamin:</strong><br>
                                                <?php echo e($mutasiPenduduk->penduduk->jenis_kelamin); ?>

                                            </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-6">
                                            <?php if($mutasiPenduduk->penduduk): ?>
                                            <div class="mb-2">
                                                <strong>Tempat, Tanggal Lahir:</strong><br>
                                                <?php echo e($mutasiPenduduk->penduduk->tempat_lahir); ?>, 
                                                <?php echo e(\Carbon\Carbon::parse($mutasiPenduduk->penduduk->tanggal_lahir)->format('d F Y')); ?>

                                            </div>
                                            <div class="mb-2">
                                                <strong>Status Hidup:</strong><br>
                                                <span class="badge <?php echo e($mutasiPenduduk->penduduk->status_hidup == 'Hidup' ? 'bg-success' : 'bg-danger'); ?>">
                                                    <?php echo e($mutasiPenduduk->penduduk->status_hidup); ?>

                                                </span>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Informasi Mutasi -->
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Detail Mutasi</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="mb-3">
                                                <strong>Jenis Mutasi:</strong><br>
                                                <?php
                                                    $badgeClass = [
                                                        'Lahir' => 'bg-success',
                                                        'Meninggal' => 'bg-danger',
                                                        'Pindah Masuk' => 'bg-primary',
                                                        'Pindah Keluar' => 'bg-warning',
                                                        'Status Update' => 'bg-info'
                                                    ];
                                                ?>
                                                <span class="badge <?php echo e($badgeClass[$mutasiPenduduk->jenis_mutasi] ?? 'bg-secondary'); ?>">
                                                    <?php echo e($mutasiPenduduk->jenis_mutasi); ?>

                                                </span>
                                            </div>
                                            <div class="mb-3">
                                                <strong>Tanggal Mutasi:</strong><br>
                                                <?php echo e(\Carbon\Carbon::parse($mutasiPenduduk->tanggal_mutasi)->format('d F Y')); ?>

                                            </div>
                                            <?php if($mutasiPenduduk->no_surat_keterangan): ?>
                                            <div class="mb-3">
                                                <strong>No. Surat Keterangan:</strong><br>
                                                <?php echo e($mutasiPenduduk->no_surat_keterangan); ?>

                                            </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-6">
                                            <?php if($mutasiPenduduk->asal_daerah || $mutasiPenduduk->tujuan_daerah): ?>
                                            <div class="mb-3">
                                                <?php if($mutasiPenduduk->asal_daerah): ?>
                                                <strong>Asal Daerah:</strong><br>
                                                <?php echo e($mutasiPenduduk->asal_daerah); ?>

                                                <?php endif; ?>
                                                <?php if($mutasiPenduduk->tujuan_daerah): ?>
                                                <br><strong>Tujuan Daerah:</strong><br>
                                                <?php echo e($mutasiPenduduk->tujuan_daerah); ?>

                                                <?php endif; ?>
                                            </div>
                                            <?php endif; ?>

                                            <?php if($mutasiPenduduk->sebab_meninggal || $mutasiPenduduk->tempat_meninggal): ?>
                                            <div class="mb-3">
                                                <?php if($mutasiPenduduk->sebab_meninggal): ?>
                                                <strong>Sebab Meninggal:</strong><br>
                                                <?php echo e($mutasiPenduduk->sebab_meninggal); ?>

                                                <?php endif; ?>
                                                <?php if($mutasiPenduduk->tempat_meninggal): ?>
                                                <br><strong>Tempat Meninggal:</strong><br>
                                                <?php echo e($mutasiPenduduk->tempat_meninggal); ?>

                                                <?php endif; ?>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <?php if($mutasiPenduduk->keterangan): ?>
                                    <div class="mb-3">
                                        <strong>Keterangan:</strong><br>
                                        <div class="border rounded p-2 bg-light">
                                            <?php echo e($mutasiPenduduk->keterangan); ?>

                                        </div>
                                    </div>
                                    <?php endif; ?>

                                    <?php if($mutasiPenduduk->catatan_admin): ?>
                                    <div class="mb-3">
                                        <strong>Catatan Admin:</strong><br>
                                        <div class="border rounded p-2 bg-warning-light">
                                            <?php echo e($mutasiPenduduk->catatan_admin); ?>

                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <!-- Informasi Sistem -->
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Informasi Sistem</h5>
                                </div>
                                <div class="card-body">
                                    <div class="mb-3">
                                        <strong>Dicatat Oleh:</strong><br>
                                        <?php echo e($mutasiPenduduk->admin_user); ?>

                                    </div>
                                    <div class="mb-3">
                                        <strong>Tanggal Pencatatan:</strong><br>
                                        <?php echo e($mutasiPenduduk->created_at->format('d F Y H:i')); ?> WIB
                                    </div>
                                    <?php if($mutasiPenduduk->updated_at != $mutasiPenduduk->created_at): ?>
                                    <div class="mb-3">
                                        <strong>Terakhir Diubah:</strong><br>
                                        <?php echo e($mutasiPenduduk->updated_at->format('d F Y H:i')); ?> WIB
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Data Lama (jika ada) -->
                            <?php if($mutasiPenduduk->data_lama): ?>
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">Data Sebelum Mutasi</h5>
                                </div>
                                <div class="card-body">
                                    <div class="accordion" id="dataLamaAccordion">
                                        <div class="accordion-item">
                                            <h2 class="accordion-header">
                                                <button class="accordion-button collapsed" type="button" 
                                                        data-bs-toggle="collapse" data-bs-target="#dataLamaContent">
                                                    Lihat Data Backup
                                                </button>
                                            </h2>
                                            <div id="dataLamaContent" class="accordion-collapse collapse" 
                                                 data-bs-parent="#dataLamaAccordion">
                                                <div class="accordion-body">
                                                    <small class="text-muted">
                                                        <?php
                                                            $dataLama = json_decode($mutasiPenduduk->data_lama, true);
                                                        ?>
                                                        <?php if(is_array($dataLama)): ?>
                                                            <?php $__currentLoopData = ['nama', 'status_hidup', 'alamat', 'rt', 'rw']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if(isset($dataLama[$field])): ?>
                                                                    <strong><?php echo e(ucfirst(str_replace('_', ' ', $field))); ?>:</strong> 
                                                                    <?php echo e($dataLama[$field]); ?><br>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php else: ?>
                                                            <?php echo e($mutasiPenduduk->data_lama); ?>

                                                        <?php endif; ?>
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/mutasi-penduduk/show.blade.php ENDPATH**/ ?>