

<?php $__env->startSection('title', 'Edit Penduduk'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.penduduk.index')); ?>">Data Penduduk</a></li>
    <li class="breadcrumb-item active">Edit Penduduk</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-user-edit me-2 text-warning"></i>
            Edit Data Penduduk
        </h2>
        <p class="text-muted mb-0">Edit data penduduk: <strong><?php echo e($penduduk->nama); ?></strong></p>
    </div>
    <div>
        <a href="<?php echo e(route('admin.penduduk.show', $penduduk->id)); ?>" class="btn btn-outline-info me-2">
            <i class="fas fa-eye me-2"></i>
            Lihat Detail
        </a>
        <a href="<?php echo e(route('admin.penduduk.index')); ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>
            Kembali
        </a>
    </div>
</div>

<form action="<?php echo e(route('admin.penduduk.update', $penduduk->id)); ?>" method="POST" enctype="multipart/form-data" id="pendudukForm">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
    
    <div class="row">
        <!-- Left Column - Main Data -->
        <div class="col-lg-8">
            <!-- Personal Information -->
            <div class="card mb-4">
                <div class="card-header bg-light">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-user me-2 text-primary"></i>
                        Data Pribadi
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nik" class="form-label required">NIK</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['nik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="nik" 
                                       name="nik" 
                                       value="<?php echo e(old('nik', $penduduk->nik)); ?>" 
                                       placeholder="Nomor Induk Kependudukan"
                                       maxlength="16"
                                       required>
                                <?php $__errorArgs = ['nik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <div class="form-text">16 digit angka NIK</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nama" class="form-label required">Nama Lengkap</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['nama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="nama" 
                                       name="nama" 
                                       value="<?php echo e(old('nama', $penduduk->nama)); ?>" 
                                       placeholder="Nama lengkap sesuai KTP"
                                       required>
                                <?php $__errorArgs = ['nama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="no_kk" class="form-label">Nomor KK</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['no_kk'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="no_kk" 
                                       name="no_kk" 
                                       value="<?php echo e(old('no_kk', $penduduk->no_kk)); ?>" 
                                       placeholder="Nomor Kartu Keluarga"
                                       maxlength="16">
                                <?php $__errorArgs = ['no_kk'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <div class="form-text">16 digit angka KK (opsional)</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <!-- Placeholder for balance -->
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="jenis_kelamin" class="form-label required">Jenis Kelamin</label>
                                <select class="form-select <?php $__errorArgs = ['jenis_kelamin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="jenis_kelamin" 
                                        name="jenis_kelamin" 
                                        required>
                                    <option value="">Pilih Jenis Kelamin</option>
                                    <option value="L" <?php echo e(old('jenis_kelamin', $penduduk->jenis_kelamin) == 'L' ? 'selected' : ''); ?>>Laki-laki</option>
                                    <option value="P" <?php echo e(old('jenis_kelamin', $penduduk->jenis_kelamin) == 'P' ? 'selected' : ''); ?>>Perempuan</option>
                                </select>
                                <?php $__errorArgs = ['jenis_kelamin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tempat_lahir" class="form-label required">Tempat Lahir</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['tempat_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="tempat_lahir" 
                                       name="tempat_lahir" 
                                       value="<?php echo e(old('tempat_lahir', $penduduk->tempat_lahir)); ?>" 
                                       placeholder="Kota/Kabupaten tempat lahir"
                                       required>
                                <?php $__errorArgs = ['tempat_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tanggal_lahir" class="form-label required">Tanggal Lahir</label>
                                <input type="date" 
                                       class="form-control <?php $__errorArgs = ['tanggal_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="tanggal_lahir" 
                                       name="tanggal_lahir" 
                                       value="<?php echo e(old('tanggal_lahir', $penduduk->tanggal_lahir->format('Y-m-d'))); ?>" 
                                       required>
                                <?php $__errorArgs = ['tanggal_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="agama" class="form-label required">Agama</label>
                                <select class="form-select <?php $__errorArgs = ['agama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="agama" 
                                        name="agama" 
                                        required>
                                    <option value="">Pilih Agama</option>
                                    <option value="Islam" <?php echo e(old('agama', $penduduk->agama) == 'Islam' ? 'selected' : ''); ?>>Islam</option>
                                    <option value="Kristen" <?php echo e(old('agama', $penduduk->agama) == 'Kristen' ? 'selected' : ''); ?>>Kristen</option>
                                    <option value="Katolik" <?php echo e(old('agama', $penduduk->agama) == 'Katolik' ? 'selected' : ''); ?>>Katolik</option>
                                    <option value="Hindu" <?php echo e(old('agama', $penduduk->agama) == 'Hindu' ? 'selected' : ''); ?>>Hindu</option>
                                    <option value="Buddha" <?php echo e(old('agama', $penduduk->agama) == 'Buddha' ? 'selected' : ''); ?>>Buddha</option>
                                    <option value="Konghucu" <?php echo e(old('agama', $penduduk->agama) == 'Konghucu' ? 'selected' : ''); ?>>Konghucu</option>
                                </select>
                                <?php $__errorArgs = ['agama'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status_perkawinan" class="form-label required">Status Perkawinan</label>
                                <select class="form-select <?php $__errorArgs = ['status_perkawinan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="status_perkawinan" 
                                        name="status_perkawinan" 
                                        required>
                                    <option value="">Pilih Status Kawin</option>
                                    <option value="Belum Kawin" <?php echo e(old('status_perkawinan', $penduduk->status_kawin) == 'Belum Kawin' ? 'selected' : ''); ?>>Belum Kawin</option>
                                    <option value="Kawin" <?php echo e(old('status_perkawinan', $penduduk->status_kawin) == 'Kawin' ? 'selected' : ''); ?>>Kawin</option>
                                    <option value="Cerai Hidup" <?php echo e(old('status_perkawinan', $penduduk->status_kawin) == 'Cerai Hidup' ? 'selected' : ''); ?>>Cerai Hidup</option>
                                    <option value="Cerai Mati" <?php echo e(old('status_perkawinan', $penduduk->status_kawin) == 'Cerai Mati' ? 'selected' : ''); ?>>Cerai Mati</option>
                                </select>
                                <?php $__errorArgs = ['status_perkawinan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="pekerjaan" class="form-label">Pekerjaan</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['pekerjaan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="pekerjaan" 
                                       name="pekerjaan" 
                                       value="<?php echo e(old('pekerjaan', $penduduk->pekerjaan)); ?>" 
                                       placeholder="Pekerjaan/Profesi">
                                <?php $__errorArgs = ['pekerjaan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="pendidikan_terakhir" class="form-label">Pendidikan Terakhir</label>
                                <select class="form-select <?php $__errorArgs = ['pendidikan_terakhir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="pendidikan_terakhir" 
                                        name="pendidikan_terakhir">
                                    <option value="">Pilih Pendidikan Terakhir</option>
                                    <option value="Tidak Sekolah" <?php echo e(old('pendidikan_terakhir', $penduduk->pendidikan_terakhir) == 'Tidak Sekolah' ? 'selected' : ''); ?>>Tidak Sekolah</option>
                                    <option value="SD" <?php echo e(old('pendidikan_terakhir', $penduduk->pendidikan_terakhir) == 'SD' ? 'selected' : ''); ?>>SD/Sederajat</option>
                                    <option value="SMP" <?php echo e(old('pendidikan_terakhir', $penduduk->pendidikan_terakhir) == 'SMP' ? 'selected' : ''); ?>>SMP/Sederajat</option>
                                    <option value="SMA" <?php echo e(old('pendidikan_terakhir', $penduduk->pendidikan_terakhir) == 'SMA' ? 'selected' : ''); ?>>SMA/Sederajat</option>
                                    <option value="D1" <?php echo e(old('pendidikan_terakhir', $penduduk->pendidikan_terakhir) == 'D1' ? 'selected' : ''); ?>>Diploma 1</option>
                                    <option value="D2" <?php echo e(old('pendidikan_terakhir', $penduduk->pendidikan_terakhir) == 'D2' ? 'selected' : ''); ?>>Diploma 2</option>
                                    <option value="D3" <?php echo e(old('pendidikan_terakhir', $penduduk->pendidikan_terakhir) == 'D3' ? 'selected' : ''); ?>>Diploma 3</option>
                                    <option value="S1" <?php echo e(old('pendidikan_terakhir', $penduduk->pendidikan_terakhir) == 'S1' ? 'selected' : ''); ?>>Sarjana (S1)</option>
                                    <option value="S2" <?php echo e(old('pendidikan_terakhir', $penduduk->pendidikan_terakhir) == 'S2' ? 'selected' : ''); ?>>Magister (S2)</option>
                                    <option value="S3" <?php echo e(old('pendidikan_terakhir', $penduduk->pendidikan_terakhir) == 'S3' ? 'selected' : ''); ?>>Doktor (S3)</option>
                                </select>
                                <?php $__errorArgs = ['pendidikan_terakhir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="golongan_darah" class="form-label">Golongan Darah</label>
                                <select class="form-select <?php $__errorArgs = ['golongan_darah'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="golongan_darah" 
                                        name="golongan_darah">
                                    <option value="">Pilih Golongan Darah</option>
                                    <option value="A" <?php echo e(old('golongan_darah', $penduduk->golongan_darah) == 'A' ? 'selected' : ''); ?>>A</option>
                                    <option value="B" <?php echo e(old('golongan_darah', $penduduk->golongan_darah) == 'B' ? 'selected' : ''); ?>>B</option>
                                    <option value="AB" <?php echo e(old('golongan_darah', $penduduk->golongan_darah) == 'AB' ? 'selected' : ''); ?>>AB</option>
                                    <option value="O" <?php echo e(old('golongan_darah', $penduduk->golongan_darah) == 'O' ? 'selected' : ''); ?>>O</option>
                                </select>
                                <?php $__errorArgs = ['golongan_darah'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="kewarganegaraan" class="form-label">Kewarganegaraan</label>
                        <select class="form-select <?php $__errorArgs = ['kewarganegaraan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="kewarganegaraan" 
                                name="kewarganegaraan">
                            <option value="WNI" <?php echo e(old('kewarganegaraan', $penduduk->kewarganegaraan) == 'WNI' ? 'selected' : ''); ?>>WNI (Warga Negara Indonesia)</option>
                            <option value="WNA" <?php echo e(old('kewarganegaraan', $penduduk->kewarganegaraan) == 'WNA' ? 'selected' : ''); ?>>WNA (Warga Negara Asing)</option>
                        </select>
                        <?php $__errorArgs = ['kewarganegaraan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="no_wa" class="form-label">Nomor WhatsApp</label>
                                <input type="tel" 
                                       class="form-control <?php $__errorArgs = ['no_wa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="no_wa" 
                                       name="no_wa" 
                                       value="<?php echo e(old('no_wa', $penduduk->no_wa)); ?>" 
                                       placeholder="628123456789"
                                       maxlength="15">
                                <?php $__errorArgs = ['no_wa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <div class="form-text">
                                    Format: 628xxx (dimulai dengan 628)
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="status_hidup" class="form-label">Status Hidup</label>
                                <select class="form-select <?php $__errorArgs = ['status_hidup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                        id="status_hidup" 
                                        name="status_hidup">
                                    <option value="Hidup" <?php echo e(old('status_hidup', $penduduk->status_hidup) == 'Hidup' ? 'selected' : ''); ?>>Hidup</option>
                                    <option value="Meninggal" <?php echo e(old('status_hidup', $penduduk->status_hidup) == 'Meninggal' ? 'selected' : ''); ?>>Meninggal</option>
                                </select>
                                <?php $__errorArgs = ['status_hidup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Address Information -->
            <div class="card mb-4">
                <div class="card-header bg-light">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-map-marker-alt me-2 text-success"></i>
                        Alamat & Lokasi
                    </h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="alamat" class="form-label required">Alamat Lengkap</label>
                        <textarea class="form-control <?php $__errorArgs = ['alamat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                  id="alamat" 
                                  name="alamat" 
                                  rows="3" 
                                  placeholder="Alamat lengkap (nama jalan, nomor rumah, dll)"
                                  required><?php echo e(old('alamat', $penduduk->alamat)); ?></textarea>
                        <?php $__errorArgs = ['alamat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="rt" class="form-label">RT</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['rt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="rt" 
                                       name="rt" 
                                       value="<?php echo e(old('rt', $penduduk->rt)); ?>" 
                                       placeholder="001"
                                       maxlength="3">
                                <?php $__errorArgs = ['rt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="rw" class="form-label">RW</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['rw'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="rw" 
                                       name="rw" 
                                       value="<?php echo e(old('rw', $penduduk->rw)); ?>" 
                                       placeholder="001"
                                       maxlength="3">
                                <?php $__errorArgs = ['rw'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="dusun" class="form-label">Dusun</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['dusun'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="dusun" 
                                       name="dusun" 
                                       value="<?php echo e(old('dusun', $penduduk->dusun)); ?>" 
                                       placeholder="Nama dusun">
                                <?php $__errorArgs = ['dusun'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="mb-3">
                                <label for="desa" class="form-label">Desa</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['desa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="desa" 
                                       name="desa" 
                                       value="<?php echo e(old('desa', $penduduk->desa)); ?>" 
                                       placeholder="Nama desa">
                                <?php $__errorArgs = ['desa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Location Picker -->
                    <div class="mb-3">
                        <label class="form-label">Koordinat Lokasi</label>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="latitude" class="form-label visually-hidden">Latitude</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['latitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="latitude" 
                                       name="latitude" 
                                       value="<?php echo e(old('latitude', $penduduk->latitude)); ?>" 
                                       placeholder="Latitude"
                                       readonly>
                                <?php $__errorArgs = ['latitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label for="longitude" class="form-label visually-hidden">Longitude</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['longitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="longitude" 
                                       name="longitude" 
                                       value="<?php echo e(old('longitude', $penduduk->longitude)); ?>" 
                                       placeholder="Longitude"
                                       readonly>
                                <?php $__errorArgs = ['longitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-text">
                            Klik pada peta di bawah untuk menentukan lokasi rumah
                        </div>
                    </div>
                    
                    <!-- Map -->
                    <div class="mb-3">
                        <div id="locationMap" class="map-container" style="height: 300px;"></div>
                    </div>
                    
                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="getCurrentLocation()">
                        <i class="fas fa-location-arrow me-2"></i>
                        Gunakan Lokasi Saat Ini
                    </button>
                </div>
            </div>
            
            <!-- Birth Certificate Information -->
            <div class="card mb-4">
                <div class="card-header bg-light">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-certificate me-2 text-info"></i>
                        Data Akta Lahir
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="no_akta_lahir" class="form-label">Nomor Akta Lahir</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['no_akta_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="no_akta_lahir" 
                                       name="no_akta_lahir" 
                                       value="<?php echo e(old('no_akta_lahir', $penduduk->no_akta_lahir)); ?>" 
                                       placeholder="Nomor akta kelahiran"
                                       maxlength="50">
                                <?php $__errorArgs = ['no_akta_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="tanggal_akta_lahir" class="form-label">Tanggal Akta Lahir</label>
                                <input type="date" 
                                       class="form-control <?php $__errorArgs = ['tanggal_akta_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="tanggal_akta_lahir" 
                                       name="tanggal_akta_lahir" 
                                       value="<?php echo e(old('tanggal_akta_lahir', $penduduk->tanggal_akta_lahir ? $penduduk->tanggal_akta_lahir->format('Y-m-d') : '')); ?>">
                                <?php $__errorArgs = ['tanggal_akta_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="tempat_akta_lahir" class="form-label">Tempat Akta Lahir</label>
                        <input type="text" 
                               class="form-control <?php $__errorArgs = ['tempat_akta_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="tempat_akta_lahir" 
                               name="tempat_akta_lahir" 
                               value="<?php echo e(old('tempat_akta_lahir', $penduduk->tempat_akta_lahir)); ?>" 
                               placeholder="Tempat pembuatan akta kelahiran">
                        <?php $__errorArgs = ['tempat_akta_lahir'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Parent Information -->
            <div class="card mb-4">
                <div class="card-header bg-light">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-users me-2 text-purple"></i>
                        Data Orang Tua
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="ayah_nik" class="form-label">NIK Ayah</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['ayah_nik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="ayah_nik" 
                                       name="ayah_nik" 
                                       value="<?php echo e(old('ayah_nik', $penduduk->ayah_nik)); ?>" 
                                       placeholder="NIK Ayah (16 digit)"
                                       maxlength="16">
                                <?php $__errorArgs = ['ayah_nik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nama_ayah" class="form-label">Nama Ayah</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['nama_ayah'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="nama_ayah" 
                                       name="nama_ayah" 
                                       value="<?php echo e(old('nama_ayah', $penduduk->nama_ayah)); ?>" 
                                       placeholder="Nama lengkap ayah">
                                <?php $__errorArgs = ['nama_ayah'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <div class="form-text">
                                    <i class="fas fa-info-circle me-1"></i>
                                    Sistem akan mencoba mencocokkan NIK dengan nama
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="ibu_nik" class="form-label">NIK Ibu</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['ibu_nik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="ibu_nik" 
                                       name="ibu_nik" 
                                       value="<?php echo e(old('ibu_nik', $penduduk->ibu_nik)); ?>" 
                                       placeholder="NIK Ibu (16 digit)"
                                       maxlength="16">
                                <?php $__errorArgs = ['ibu_nik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nama_ibu" class="form-label">Nama Ibu</label>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['nama_ibu'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       id="nama_ibu" 
                                       name="nama_ibu" 
                                       value="<?php echo e(old('nama_ibu', $penduduk->nama_ibu)); ?>" 
                                       placeholder="Nama lengkap ibu">
                                <?php $__errorArgs = ['nama_ibu'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                <div class="form-text">
                                    <i class="fas fa-info-circle me-1"></i>
                                    Sistem akan mencoba mencocokkan NIK dengan nama
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="hubungan_keluarga" class="form-label">Hubungan dalam Keluarga</label>
                        <select class="form-select <?php $__errorArgs = ['hubungan_keluarga'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="hubungan_keluarga" 
                                name="hubungan_keluarga">
                            <option value="">Pilih Hubungan Keluarga</option>
                            <option value="Kepala Keluarga" <?php echo e(old('hubungan_keluarga', $penduduk->hubungan_keluarga) == 'Kepala Keluarga' ? 'selected' : ''); ?>>Kepala Keluarga</option>
                            <option value="Istri" <?php echo e(old('hubungan_keluarga', $penduduk->hubungan_keluarga) == 'Istri' ? 'selected' : ''); ?>>Istri</option>
                            <option value="Anak" <?php echo e(old('hubungan_keluarga', $penduduk->hubungan_keluarga) == 'Anak' ? 'selected' : ''); ?>>Anak</option>
                            <option value="Menantu" <?php echo e(old('hubungan_keluarga', $penduduk->hubungan_keluarga) == 'Menantu' ? 'selected' : ''); ?>>Menantu</option>
                            <option value="Cucu" <?php echo e(old('hubungan_keluarga', $penduduk->hubungan_keluarga) == 'Cucu' ? 'selected' : ''); ?>>Cucu</option>
                            <option value="Orang Tua" <?php echo e(old('hubungan_keluarga', $penduduk->hubungan_keluarga) == 'Orang Tua' ? 'selected' : ''); ?>>Orang Tua</option>
                            <option value="Mertua" <?php echo e(old('hubungan_keluarga', $penduduk->hubungan_keluarga) == 'Mertua' ? 'selected' : ''); ?>>Mertua</option>
                            <option value="Saudara" <?php echo e(old('hubungan_keluarga', $penduduk->hubungan_keluarga) == 'Saudara' ? 'selected' : ''); ?>>Saudara</option>
                            <option value="Lainnya" <?php echo e(old('hubungan_keluarga', $penduduk->hubungan_keluarga) == 'Lainnya' ? 'selected' : ''); ?>>Lainnya</option>
                        </select>
                        <?php $__errorArgs = ['hubungan_keluarga'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Family Information -->
            <div class="card mb-4">
                <div class="card-header bg-light">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-home me-2 text-warning"></i>
                        Data Keluarga
                    </h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label for="keluarga_id" class="form-label">Keluarga (Nomor KK)</label>
                        <select class="form-select <?php $__errorArgs = ['keluarga_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                id="keluarga_id" 
                                name="keluarga_id">
                            <option value="">Pilih Keluarga</option>
                            <?php $__currentLoopData = $keluarga; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($k->id); ?>" <?php echo e(old('keluarga_id', $penduduk->keluarga_id) == $k->id ? 'selected' : ''); ?>>
                                    <?php echo e($k->no_kk); ?> - <?php echo e($k->kepala_keluarga); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['keluarga_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-check">
                        <input class="form-check-input" 
                               type="checkbox" 
                               id="is_kepala_keluarga" 
                               name="is_kepala_keluarga" 
                               value="1" 
                               <?php echo e(old('is_kepala_keluarga', $penduduk->is_kepala_keluarga) ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="is_kepala_keluarga">
                            Kepala Keluarga
                        </label>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Right Column - Photo & Actions -->
        <div class="col-lg-4">
            <!-- Photo Upload -->
            <div class="card mb-4">
                <div class="card-header bg-light">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-camera me-2 text-info"></i>
                        Foto Penduduk
                    </h5>
                </div>
                <div class="card-body text-center">
                    <div class="photo-preview mb-3">
                        <!-- Always show current avatar/photo -->
                        <img id="photoPreviewImage" 
                             src="<?php echo e(\App\Helpers\ImageHelper::getAvatarUrl($penduduk->foto, $penduduk->nama)); ?>" 
                             class="img-fluid rounded-circle" 
                             style="max-height: 250px; max-width: 250px; object-fit: cover; display: block;"
                             alt="Foto <?php echo e($penduduk->nama); ?>">
                        
                        <!-- Hidden placeholder for when user selects new photo -->
                        <div id="photoPreview" class="default-avatar-container" style="display: none;">
                            <i class="fas fa-user default-avatar-icon"></i>
                            <div class="default-avatar-text">Pilih Foto</div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <input type="file" 
                               class="form-control <?php $__errorArgs = ['foto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="foto" 
                               name="foto" 
                               accept="image/*"
                               onchange="previewPhoto(this)">
                        <?php $__errorArgs = ['foto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="form-text">
                            Format: JPG, PNG, JPEG (Maks. 2MB)<br>
                            Kosongkan jika tidak ingin mengubah foto
                        </div>
                    </div>
                    
                    <?php if($penduduk->foto): ?>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" id="remove_foto" name="remove_foto" value="1">
                        <label class="form-check-label" for="remove_foto">
                            Hapus foto yang ada
                        </label>
                    </div>
                    <?php endif; ?>
                    
                    <button type="button" class="btn btn-outline-secondary btn-sm" onclick="resetPhoto()">
                        <i class="fas fa-trash me-2"></i>
                        Reset Foto
                    </button>
                </div>
            </div>
            
            <!-- Change Log -->
            <div class="card mb-4">
                <div class="card-header bg-light">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-history me-2 text-secondary"></i>
                        Riwayat Perubahan
                    </h5>
                </div>
                <div class="card-body">
                    <div class="small">
                        <div class="mb-2">
                            <strong>Dibuat:</strong><br>
                            <?php echo e($penduduk->created_at->format('d/m/Y H:i')); ?>

                        </div>
                        <div class="mb-2">
                            <strong>Terakhir Diupdate:</strong><br>
                            <?php echo e($penduduk->updated_at->format('d/m/Y H:i')); ?>

                        </div>
                        <?php if($penduduk->created_at != $penduduk->updated_at): ?>
                        <div class="text-muted">
                            <i class="fas fa-info-circle me-1"></i>
                            Data telah diubah <?php echo e($penduduk->updated_at->diffForHumans()); ?>

                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Action Buttons -->
            <div class="card">
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-gradient-warning" id="submitBtn">
                            <i class="fas fa-save me-2"></i>
                            Update Data
                        </button>
                        
                        <button type="button" class="btn btn-outline-info" onclick="previewChanges()">
                            <i class="fas fa-eye me-2"></i>
                            Preview Perubahan
                        </button>
                        
                        <a href="<?php echo e(route('admin.penduduk.show', $penduduk->id)); ?>" class="btn btn-outline-primary">
                            <i class="fas fa-user me-2"></i>
                            Lihat Detail
                        </a>
                        
                        <a href="<?php echo e(route('admin.penduduk.index')); ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-times me-2"></i>
                            Batal
                        </a>
                    </div>
                    
                    <div class="mt-3">
                        <small class="text-muted">
                            <i class="fas fa-info-circle me-1"></i>
                            Field dengan tanda (*) wajib diisi
                        </small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .required::after {
        content: ' *';
        color: #dc3545;
    }
    
    .photo-preview {
        border: 2px dashed #e9ecef;
        border-radius: 10px;
        padding: 20px;
        transition: all 0.3s ease;
    }
    
    .photo-preview:hover {
        border-color: #667eea;
        background: rgba(102, 126, 234, 0.05);
    }
    
    .map-container {
        border: 2px solid #e9ecef;
        border-radius: 10px;
        overflow: hidden;
    }
    
    .form-control:focus, .form-select:focus {
        border-color: #667eea;
        box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
    }
    
    .card-header {
        border-bottom: 2px solid #e9ecef;
    }
    
    .btn-gradient-warning {
        background: linear-gradient(135deg, #ffc107 0%, #ff8f00 100%);
        border: none;
        color: white;
        font-weight: 600;
    }
    
    .btn-gradient-warning:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(255, 193, 7, 0.3);
        color: white;
    }
    
    .leaflet-container {
        font-family: inherit;
    }
    
    .default-avatar-container {
        width: 100%;
        max-width: 250px;
        height: 250px;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        border: 2px dashed #dee2e6;
        border-radius: 12px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        margin: 0 auto;
        transition: all 0.3s ease;
    }
    
    .default-avatar-container:hover {
        border-color: #667eea;
        background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(102, 126, 234, 0.05) 100%);
    }
    
    .default-avatar-icon {
        font-size: 3rem;
        color: #9ca3af;
        margin-bottom: 10px;
    }
    
    .default-avatar-text {
        color: #6b7280;
        font-size: 0.9rem;
        font-weight: 500;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
let map;
let marker;

document.addEventListener('DOMContentLoaded', function() {
    initializeMap();
    initializeForm();
});

// Initialize map - same as create form
function initializeMap() {
    const lat = <?php echo e($penduduk->latitude ?? -6.5971); ?>;
    const lng = <?php echo e($penduduk->longitude ?? 106.8060); ?>;
    
    map = L.map('locationMap').setView([lat, lng], 15);
    
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);
    
    // Add existing marker if coordinates exist
    <?php if($penduduk->latitude && $penduduk->longitude): ?>
        setMapLocation(<?php echo e($penduduk->latitude); ?>, <?php echo e($penduduk->longitude); ?>);
    <?php endif; ?>
    
    // Add click event
    map.on('click', function(e) {
        setMapLocation(e.latlng.lat, e.latlng.lng);
    });
}

// Set location on map - same as create form
function setMapLocation(lat, lng) {
    if (marker) {
        map.removeLayer(marker);
    }
    
    marker = L.marker([lat, lng]).addTo(map);
    
    document.getElementById('latitude').value = lat.toFixed(6);
    document.getElementById('longitude').value = lng.toFixed(6);
}

// Get current location - same as create form
function getCurrentLocation() {
    if (navigator.geolocation) {
        showLoading();
        
        navigator.geolocation.getCurrentPosition(
            function(position) {
                const lat = position.coords.latitude;
                const lng = position.coords.longitude;
                
                setMapLocation(lat, lng);
                map.setView([lat, lng], 17);
                
                hideLoading();
                showToast('Lokasi berhasil didapatkan', 'success');
            },
            function(error) {
                hideLoading();
                showToast('Gagal mendapatkan lokasi', 'error');
            }
        );
    }
}

// Photo preview - enhanced with better error handling
function previewPhoto(input) {
    console.log('previewPhoto called', input.files);
    
    if (input.files && input.files[0]) {
        const file = input.files[0];
        console.log('File selected:', file.name, file.size, file.type);
        
        // Validate file size
        if (file.size > 2 * 1024 * 1024) {
            alert('Ukuran file terlalu besar. Maksimal 2MB.');
            input.value = '';
            return;
        }
        
        // Validate file type
        if (!file.type.match('image.*')) {
            alert('File harus berupa gambar (JPG, PNG, JPEG).');
            input.value = '';
            return;
        }
        
        const reader = new FileReader();
        reader.onload = function(e) {
            console.log('File loaded for preview');
            
            // Update preview image
            const previewImg = document.getElementById('photoPreviewImage');
            if (previewImg) {
                previewImg.src = e.target.result;
                previewImg.style.display = 'block';
                console.log('Preview image updated');
            }
            
            // Hide placeholder if exists
            const placeholder = document.getElementById('photoPreview');
            if (placeholder) {
                placeholder.style.display = 'none';
            }
            
            // Show success message
            alert('Foto berhasil dipilih. Foto akan diresize otomatis ke 400x400 pixel saat disimpan.');
        };
        
        reader.onerror = function() {
            console.error('Error reading file');
            alert('Error membaca file. Silakan coba lagi.');
        };
        
        reader.readAsDataURL(file);
    } else {
        console.log('No file selected');
    }
}

// Reset photo
function resetPhoto() {
    document.getElementById('foto').value = '';
    
    // Always reset to original avatar (real photo or generated)
    document.getElementById('photoPreview').style.display = 'none';
    document.getElementById('photoPreviewImage').src = '<?php echo e(\App\Helpers\ImageHelper::getAvatarUrl($penduduk->foto, $penduduk->nama)); ?>';
    document.getElementById('photoPreviewImage').style.display = 'block';
}

// Initialize form - same as create form
function initializeForm() {
    // NIK validation
    document.getElementById('nik').addEventListener('input', function() {
        this.value = this.value.replace(/\D/g, '');
    });
    
    // Date validation
    document.getElementById('tanggal_lahir').addEventListener('change', function() {
        const today = new Date();
        const birthDate = new Date(this.value);
        
        if (birthDate > today) {
            showToast('Tanggal lahir tidak boleh di masa depan', 'error');
            this.value = '';
        }
    });
    
    // Kepala keluarga logic
    document.getElementById('is_kepala_keluarga').addEventListener('change', function() {
        const keluargaSelect = document.getElementById('keluarga_id');
        
        if (this.checked) {
            if (confirm('Jika dipilih sebagai kepala keluarga, data keluarga yang ada akan diupdate. Lanjutkan?')) {
                // Keep current selection but show warning
            } else {
                this.checked = false;
            }
        }
    });
}

// Preview changes
function previewChanges() {
    const modal = new bootstrap.Modal(document.createElement('div'));
    // Implementation for change preview
    showToast('Fitur preview perubahan akan segera tersedia', 'info');
}

// Form submission with enhanced debugging
document.getElementById('pendudukForm').addEventListener('submit', function(e) {
    console.log('Form submission started');
    
    const submitBtn = document.getElementById('submitBtn');
    const fotoInput = document.getElementById('foto');
    
    // Log form data for debugging
    console.log('Form action:', this.action);
    console.log('Form method:', this.method);
    console.log('Form enctype:', this.enctype);
    
    if (fotoInput && fotoInput.files.length > 0) {
        console.log('File to upload:', fotoInput.files[0].name, fotoInput.files[0].size);
    } else {
        console.log('No file selected for upload');
    }
    
    // Check form validity
    if (!this.checkValidity()) {
        console.log('Form validation failed');
        e.preventDefault();
        alert('Silakan lengkapi semua field yang wajib diisi.');
        return;
    }
    
    // Disable submit button to prevent double submission
    submitBtn.disabled = true;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Menyimpan...';
    
    console.log('Form submitted successfully');
    
    // Re-enable button after 10 seconds as safety measure
    setTimeout(function() {
        if (submitBtn.disabled) {
            submitBtn.disabled = false;
            submitBtn.innerHTML = '<i class="fas fa-save me-2"></i>Update Data';
            console.log('Submit button re-enabled after timeout');
        }
    }, 10000);
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/penduduk/edit.blade.php ENDPATH**/ ?>