

<?php $__env->startSection('title', 'Pohon Keluarga Multigenerasi'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active">Pohon Keluarga</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <!-- Statistics Cards -->
    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-primary h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-users"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold"><?php echo e($stats['total_penduduk'] ?? 0); ?></div>
                    <div class="small">Total Penduduk</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-success h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-sitemap"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold"><?php echo e($stats['with_parents'] ?? 0); ?></div>
                    <div class="small">Memiliki Relasi Orang Tua</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-warning h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-crown"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold"><?php echo e($stats['generasi_pertama'] ?? 0); ?></div>
                    <div class="small">Generasi Pertama</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-info h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-tree"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold"><?php echo e($stats['total_keluarga_besar'] ?? 0); ?></div>
                    <div class="small">Keluarga Besar</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Action Buttons -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-sitemap me-2 text-primary"></i>
                        Manajemen Pohon Keluarga Multigenerasi
                    </h5>
                    <div class="btn-group">
                        <a href="<?php echo e(route('admin.pohon-keluarga.statistik')); ?>" class="btn btn-info">
                            <i class="fas fa-chart-bar me-2"></i>Statistik Keluarga
                        </a>
                        <a href="<?php echo e(route('admin.penduduk.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-user-plus me-2"></i>Tambah Penduduk
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Search and Filter -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form method="GET" action="<?php echo e(route('admin.pohon-keluarga.index')); ?>">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">Pencarian</label>
                            <input type="text" name="search" class="form-control" 
                                   placeholder="Cari nama atau NIK..." 
                                   value="<?php echo e(request('search')); ?>">
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Dusun</label>
                            <select name="dusun" class="form-select">
                                <option value="">Semua Dusun</option>
                                <?php $__currentLoopData = $dusunList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dusun): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($dusun); ?>" <?php echo e(request('dusun') == $dusun ? 'selected' : ''); ?>>
                                        <?php echo e($dusun); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">&nbsp;</label>
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search"></i> Cari
                                </button>
                                <a href="<?php echo e(route('admin.pohon-keluarga.index')); ?>" class="btn btn-secondary">
                                    <i class="fas fa-refresh"></i> Reset
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Family Tree Data -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="card-title mb-0">
                    <i class="fas fa-users me-2 text-success"></i>
                    Data Penduduk & Pohon Keluarga
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>NIK</th>
                                <th>Nama</th>
                                <th>Jenis Kelamin</th>
                                <th>Umur</th>
                                <th>Status Keluarga</th>
                                <th>Orang Tua</th>
                                <th>Jumlah Anak</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $penduduk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <code><?php echo e($person->nik); ?></code>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-circle me-2 <?php echo e($person->jenis_kelamin == 'L' ? 'bg-primary' : 'bg-pink'); ?>">
                                            <i class="fas fa-<?php echo e($person->jenis_kelamin == 'L' ? 'male' : 'female'); ?> text-white"></i>
                                        </div>
                                        <div>
                                            <strong><?php echo e($person->nama); ?></strong>
                                            <br>
                                            <small class="text-muted"><?php echo e($person->no_kk); ?></small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($person->jenis_kelamin == 'L' ? 'primary' : 'pink'); ?>">
                                        <?php echo e($person->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan'); ?>

                                    </span>
                                </td>
                                <td><?php echo e($person->umur); ?> tahun</td>
                                <td>
                                    <span class="badge bg-info"><?php echo e($person->status_keluarga ?? 'Tidak Diset'); ?></span>
                                </td>
                                <td>
                                    <?php if($person->ayah || $person->ibu): ?>
                                        <div class="small">
                                            <?php if($person->ayah): ?>
                                                <div><i class="fas fa-male text-primary"></i> <?php echo e($person->ayah->nama); ?></div>
                                            <?php endif; ?>
                                            <?php if($person->ibu): ?>
                                                <div><i class="fas fa-female text-pink"></i> <?php echo e($person->ibu->nama); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-success"><?php echo e($person->getAllChildren()->count()); ?></span>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <a href="<?php echo e(route('admin.pohon-keluarga.show', $person->nik)); ?>" 
                                           class="btn btn-sm btn-info" title="Lihat Pohon Keluarga">
                                            <i class="fas fa-sitemap"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.pohon-keluarga.edit', $person->nik)); ?>" 
                                           class="btn btn-sm btn-warning" title="Edit Relasi">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.pohon-keluarga.visualisasi', $person->nik)); ?>" 
                                           class="btn btn-sm btn-success" title="Visualisasi Pohon">
                                            <i class="fas fa-project-diagram"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-4">
                                    <div class="text-muted">
                                        <i class="fas fa-users fa-3x mb-3"></i>
                                        <p>Belum ada data penduduk.</p>
                                    </div>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if($penduduk->hasPages()): ?>
                <div class="d-flex justify-content-between align-items-center mt-4">
                    <div class="text-muted">
                        Menampilkan <?php echo e($penduduk->firstItem()); ?> - <?php echo e($penduduk->lastItem()); ?> dari <?php echo e($penduduk->total()); ?> data
                    </div>
                    <?php echo e($penduduk->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.avatar-circle {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 14px;
}

.bg-pink {
    background-color: #e91e63 !important;
}

.text-pink {
    color: #e91e63 !important;
}

.stats-icon {
    width: 50px;
    height: 50px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
}

.card-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.card-gradient-success {
    background: linear-gradient(135deg, #56ab2f 0%, #a8e6cf 100%);
    color: white;
}

.card-gradient-warning {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
}

.card-gradient-info {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    color: white;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Auto-submit form on select change
    $('select[name="dusun"]').on('change', function() {
        $(this).closest('form').submit();
    });
    
    // Tooltip initialization
    $('[title]').tooltip();
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/pohon-keluarga/index.blade.php ENDPATH**/ ?>