

<?php $__env->startSection('title', 'Kelola Tiket Wisata'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Kelola Tiket Wisata</h1>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Booking</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['total'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-ticket-alt fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Confirmed</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['confirmed'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-check-circle fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Pending</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['pending'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-clock fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Revenue</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">Rp <?php echo e(number_format($stats['revenue'] ?? 0)); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-dollar-sign fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter & Search -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter Booking</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('admin.tiket-wisata.index')); ?>">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Pencarian</label>
                            <input type="text" class="form-control" name="search" value="<?php echo e(request('search')); ?>" placeholder="Nama, email, kode booking...">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" name="status">
                                <option value="">Semua Status</option>
                                <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                                <option value="confirmed" <?php echo e(request('status') === 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                                <option value="cancelled" <?php echo e(request('status') === 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                <option value="completed" <?php echo e(request('status') === 'completed' ? 'selected' : ''); ?>>Completed</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="objek_wisata">Objek Wisata</label>
                            <select class="form-control" name="objek_wisata_id">
                                <option value="">Semua Objek</option>
                                <?php $__currentLoopData = $objekWisataList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $objek): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($objek->id); ?>" <?php echo e(request('objek_wisata_id') == $objek->id ? 'selected' : ''); ?>>
                                        <?php echo e($objek->nama); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="tanggal_mulai">Tanggal Mulai</label>
                            <input type="date" class="form-control" name="tanggal_mulai" value="<?php echo e(request('tanggal_mulai')); ?>">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="tanggal_selesai">Tanggal Selesai</label>
                            <input type="date" class="form-control" name="tanggal_selesai" value="<?php echo e(request('tanggal_selesai')); ?>">
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="d-flex flex-column">
                                <button type="submit" class="btn btn-primary btn-sm mb-1"><i class="fas fa-search"></i></button>
                                <a href="<?php echo e(route('admin.tiket-wisata.index')); ?>" class="btn btn-secondary btn-sm"><i class="fas fa-undo"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Data Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Booking Tiket</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Kode Booking</th>
                            <th>Pemesan</th>
                            <th>Objek Wisata</th>
                            <th>Tanggal Kunjungan</th>
                            <th>Jumlah Tiket</th>
                            <th>Total Bayar</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $tiketWisata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tiket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td><span class="font-weight-bold"><?php echo e($tiket->kode_booking); ?></span></td>
                            <td>
                                <div class="font-weight-bold"><?php echo e($tiket->nama_pemesan); ?></div>
                                <small><?php echo e($tiket->email_pemesan); ?></small><br>
                                <small><?php echo e($tiket->nomor_hp_pemesan); ?></small>
                            </td>
                            <td><?php echo e($tiket->objekWisata->nama); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($tiket->tanggal_kunjungan)->format('d/m/Y')); ?></td>
                            <td>
                                <div>Dewasa: <?php echo e($tiket->jumlah_dewasa); ?></div>
                                <?php if($tiket->jumlah_anak > 0): ?>
                                    <div>Anak: <?php echo e($tiket->jumlah_anak); ?></div>
                                <?php endif; ?>
                            </td>
                            <td class="font-weight-bold">Rp <?php echo e(number_format($tiket->total_harga)); ?></td>
                            <td>
                                <?php if($tiket->status === 'confirmed'): ?>
                                    <span class="badge badge-success">Confirmed</span>
                                <?php elseif($tiket->status === 'pending'): ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif($tiket->status === 'cancelled'): ?>
                                    <span class="badge badge-danger">Cancelled</span>
                                <?php else: ?>
                                    <span class="badge badge-info"><?php echo e(ucfirst($tiket->status)); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('admin.tiket-wisata.show', $tiket->id)); ?>" class="btn btn-info btn-sm"><i class="fas fa-eye"></i></a>
                                    <?php if($tiket->status === 'pending'): ?>
                                        <button class="btn btn-success btn-sm" onclick="confirmBooking(<?php echo e($tiket->id); ?>)"><i class="fas fa-check"></i></button>
                                    <?php endif; ?>
                                    <?php if($tiket->status === 'confirmed'): ?>
                                        <button class="btn btn-primary btn-sm" onclick="checkinBooking(<?php echo e($tiket->id); ?>)"><i class="fas fa-qrcode"></i></button>
                                    <?php endif; ?>
                                    <button class="btn btn-danger btn-sm" onclick="cancelBooking(<?php echo e($tiket->id); ?>)"><i class="fas fa-times"></i></button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center">Tidak ada data booking</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <?php if($tiketWisata->hasPages()): ?>
                <?php echo e($tiketWisata->appends(request()->query())->links()); ?>

            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Action Modals -->
<div class="modal fade" id="actionModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="actionModalTitle">Konfirmasi</h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
            </div>
            <div class="modal-body" id="actionModalBody"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <form id="actionForm" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PATCH'); ?>
                    <button type="submit" class="btn btn-primary" id="actionSubmitBtn">Konfirmasi</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function confirmBooking(id) {
    $('#actionModalTitle').text('Konfirmasi Booking');
    $('#actionModalBody').text('Konfirmasi booking tiket ini?');
    $('#actionForm').attr('action', `/admin/tiket-wisata/${id}/confirm`);
    $('#actionSubmitBtn').removeClass().addClass('btn btn-success').text('Konfirmasi');
    $('#actionModal').modal('show');
}

function cancelBooking(id) {
    $('#actionModalTitle').text('Batalkan Booking');
    $('#actionModalBody').text('Batalkan booking tiket ini?');
    $('#actionForm').attr('action', `/admin/tiket-wisata/${id}/cancel`);
    $('#actionSubmitBtn').removeClass().addClass('btn btn-danger').text('Batalkan');
    $('#actionModal').modal('show');
}

function checkinBooking(id) {
    $('#actionModalTitle').text('Check-in Booking');
    $('#actionModalBody').text('Lakukan check-in untuk booking ini?');
    $('#actionForm').attr('action', `/admin/tiket-wisata/${id}/checkin`);
    $('#actionSubmitBtn').removeClass().addClass('btn btn-primary').text('Check-in');
    $('#actionModal').modal('show');
}
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/tiket-wisata/index.blade.php ENDPATH**/ ?>