

<?php $__env->startSection('title', 'Detail User'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-user me-2 text-primary"></i>Detail User
            </h2>
            <p class="text-muted mb-0">Informasi lengkap pengguna sistem</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-outline-secondary me-2">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
            <a href="<?php echo e(route('admin.users.edit', $user->id)); ?>" class="btn btn-primary">
                <i class="fas fa-edit me-2"></i>Edit
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-user me-2"></i>Informasi User</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-2">
                            <div class="avatar bg-primary text-white mb-3" 
                                 style="width: 80px; height: 80px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 2rem;">
                                <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

                            </div>
                        </div>
                        <div class="col-md-10">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="200"><strong>ID User</strong></td>
                                    <td>: <?php echo e($user->id); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Nama Lengkap</strong></td>
                                    <td>: <?php echo e($user->name); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Email</strong></td>
                                    <td>: <?php echo e($user->email); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Role</strong></td>
                                    <td>: 
                                        <?php if($user->userRole): ?>
                                            <span class="badge bg-info"><?php echo e($user->userRole->display_name); ?></span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Tidak ada role</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Status</strong></td>
                                    <td>: 
                                        <?php if($user->is_active): ?>
                                            <span class="badge bg-success">Aktif</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Non-aktif</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Tanggal Dibuat</strong></td>
                                    <td>: <?php echo e($user->created_at->format('d/m/Y H:i:s')); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Terakhir Diubah</strong></td>
                                    <td>: <?php echo e($user->updated_at->format('d/m/Y H:i:s')); ?></td>
                                </tr>
                                <?php if($user->last_login_at): ?>
                                <tr>
                                    <td><strong>Login Terakhir</strong></td>
                                    <td>: <?php echo e($user->last_login_at->format('d/m/Y H:i:s')); ?></td>
                                </tr>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Role Permissions -->
            <?php if($user->userRole && $user->userRole->permissions): ?>
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-key me-2"></i>Hak Akses (Permissions)</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php
                            $permissions = json_decode($user->userRole->permissions, true) ?? [];
                            $groupedPermissions = collect($permissions)->groupBy(function($permission) {
                                return explode('.', $permission)[0];
                            });
                        ?>
                        
                        <?php $__currentLoopData = $groupedPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module => $modulePermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 mb-3">
                            <div class="card border">
                                <div class="card-header py-2">
                                    <h6 class="mb-0 text-capitalize"><?php echo e(ucwords(str_replace(['_', '-'], ' ', $module))); ?></h6>
                                </div>
                                <div class="card-body py-2">
                                    <?php $__currentLoopData = $modulePermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" checked disabled>
                                        <label class="form-check-label small">
                                            <?php echo e(ucwords(str_replace(['.', '_', '-'], ' ', $permission))); ?>

                                        </label>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-cogs me-2"></i>Aksi</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('admin.users.edit', $user->id)); ?>" class="btn btn-primary">
                            <i class="fas fa-edit me-2"></i>Edit User
                        </a>
                        
                        <?php if($user->id !== auth()->id()): ?>
                        <button type="button" class="btn btn-outline-warning" onclick="resetPassword()">
                            <i class="fas fa-key me-2"></i>Reset Password
                        </button>
                        
                        <button type="button" class="btn btn-outline-secondary" onclick="toggleStatus()">
                            <i class="fas fa-toggle-<?php echo e($user->is_active ? 'on' : 'off'); ?> me-2"></i>
                            <?php echo e($user->is_active ? 'Nonaktifkan' : 'Aktifkan'); ?>

                        </button>
                        
                        <button type="button" class="btn btn-outline-danger" onclick="deleteUser()">
                            <i class="fas fa-trash me-2"></i>Hapus User
                        </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-chart-line me-2"></i>Statistik</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6">
                            <div class="border-end">
                                <h4 class="text-primary mb-1"><?php echo e($user->created_at->diffInDays()); ?></h4>
                                <small class="text-muted">Hari Bergabung</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h4 class="text-info mb-1">
                                <?php if($user->last_login_at): ?>
                                    <?php echo e($user->last_login_at->diffInDays()); ?>

                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </h4>
                            <small class="text-muted">Hari Login Terakhir</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reset Password Modal -->
<div class="modal fade" id="resetPasswordModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Reset Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="resetPasswordForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Password Baru</label>
                        <input type="password" class="form-control" name="password" required minlength="8">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Konfirmasi Password</label>
                        <input type="password" class="form-control" name="password_confirmation" required minlength="8">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Reset Password</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function resetPassword() {
    const modal = new bootstrap.Modal(document.getElementById('resetPasswordModal'));
    modal.show();
}

function toggleStatus() {
    fetch(`<?php echo e(route('admin.users.toggle-status', $user->id)); ?>`, {
        method: 'PUT',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Content-Type': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Status user berhasil diubah', 'success');
            location.reload();
        } else {
            showToast(data.message || 'Gagal mengubah status', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    });
}

function deleteUser() {
    if (confirm('Apakah Anda yakin ingin menghapus user ini?')) {
        fetch(`<?php echo e(route('admin.users.destroy', $user->id)); ?>`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('User berhasil dihapus', 'success');
                setTimeout(() => {
                    window.location.href = '<?php echo e(route("admin.users.index")); ?>';
                }, 1500);
            } else {
                showToast(data.message || 'Gagal menghapus user', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        });
    }
}

document.getElementById('resetPasswordForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const password = formData.get('password');
    const confirmation = formData.get('password_confirmation');
    
    if (password !== confirmation) {
        showToast('Password dan konfirmasi password tidak cocok', 'error');
        return;
    }
    
    fetch(`<?php echo e(route('admin.users.reset-password', $user->id)); ?>`, {
        method: 'PUT',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Password berhasil direset', 'success');
            const modal = bootstrap.Modal.getInstance(document.getElementById('resetPasswordModal'));
            modal.hide();
            this.reset();
        } else {
            showToast(data.message || 'Gagal reset password', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    });
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/users/show.blade.php ENDPATH**/ ?>