

<?php $__env->startSection('title', 'Detail Arsip Surat Keluar'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title">
                            <i class="fas fa-file-export me-2"></i>
                            Detail Arsip Surat Keluar
                        </h3>
                        <div>
                            <a href="<?php echo e(route('admin.arsip-surat-keluar.edit', $arsipSuratKeluar)); ?>" class="btn btn-warning">
                                <i class="fas fa-edit me-1"></i>
                                Edit
                            </a>
                            <a href="<?php echo e(route('admin.arsip-surat-keluar.index')); ?>" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-1"></i>
                                Kembali
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="200" class="fw-bold">Nomor Surat</td>
                                    <td>: <?php echo e($arsipSuratKeluar->nomor_surat); ?></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Tipe Surat</td>
                                    <td>: <span class="badge bg-info"><?php echo e($arsipSuratKeluar->tipe_surat); ?></span></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Perihal</td>
                                    <td>: <?php echo e($arsipSuratKeluar->perihal); ?></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Tujuan</td>
                                    <td>: <?php echo e($arsipSuratKeluar->tujuan); ?></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Tanggal Surat</td>
                                    <td>: <?php echo e($arsipSuratKeluar->tanggal_surat->format('d F Y')); ?></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Dibuat Oleh</td>
                                    <td>: <?php echo e($arsipSuratKeluar->creator->name ?? 'System'); ?></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold">Tanggal Dibuat</td>
                                    <td>: <?php echo e($arsipSuratKeluar->created_at->format('d F Y H:i')); ?></td>
                                </tr>
                                <?php if($arsipSuratKeluar->keterangan): ?>
                                <tr>
                                    <td class="fw-bold">Keterangan</td>
                                    <td>: <?php echo e($arsipSuratKeluar->keterangan); ?></td>
                                </tr>
                                <?php endif; ?>
                            </table>
                        </div>

                        <div class="col-md-4">
                            <div class="card border">
                                <div class="card-header">
                                    <h6 class="card-title mb-0">
                                        <i class="fas fa-file-alt me-2"></i>
                                        File Surat
                                    </h6>
                                </div>
                                <div class="card-body text-center">
                                    <?php if($arsipSuratKeluar->file_surat): ?>
                                        <div class="mb-3">
                                            <i class="fas fa-file-pdf fa-4x text-danger"></i>
                                        </div>
                                        <div class="d-grid gap-2">
                                            <a href="<?php echo e(route('admin.arsip-surat-keluar.download', $arsipSuratKeluar)); ?>" 
                                               class="btn btn-primary" target="_blank">
                                                <i class="fas fa-download me-1"></i>
                                                Download File
                                            </a>
                                            <a href="<?php echo e(route('admin.arsip-surat-keluar.download', $arsipSuratKeluar)); ?>?view=1" 
                                               class="btn btn-outline-primary" target="_blank">
                                                <i class="fas fa-eye me-1"></i>
                                                Lihat File
                                            </a>
                                        </div>
                                    <?php else: ?>
                                        <div class="text-muted">
                                            <i class="fas fa-file-times fa-4x mb-3"></i>
                                            <p>File tidak tersedia</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card-footer">
                    <div class="d-flex justify-content-between">
                        <div>
                            <small class="text-muted">
                                Terakhir diubah: <?php echo e($arsipSuratKeluar->updated_at->format('d F Y H:i')); ?>

                            </small>
                        </div>
                        <div>
                            <form action="<?php echo e(route('admin.arsip-surat-keluar.destroy', $arsipSuratKeluar)); ?>" 
                                  method="POST" 
                                  onsubmit="return confirm('Yakin ingin menghapus arsip surat ini?')"
                                  class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                    <i class="fas fa-trash me-1"></i>
                                    Hapus
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/arsip-surat-keluar/show.blade.php ENDPATH**/ ?>