

<?php $__env->startSection('title', 'Laporan APBDes'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
<li class="breadcrumb-item active">Laporan APBDes</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Summary Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Total Anggaran</h6>
                            <h4>Rp <?php echo e(number_format($summary['total_anggaran'] ?? 0, 0, ',', '.')); ?></h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-wallet fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Total Realisasi</h6>
                            <h4>Rp <?php echo e(number_format($summary['total_realisasi'] ?? 0, 0, ',', '.')); ?></h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-chart-line fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Sisa Anggaran</h6>
                            <h4>Rp <?php echo e(number_format(($summary['total_anggaran'] ?? 0) - ($summary['total_realisasi'] ?? 0), 0, ',', '.')); ?></h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-piggy-bank fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex justify-content-between">
                        <div>
                            <h6 class="card-title">Presentase</h6>
                            <h4><?php echo e($summary['persentase'] ?? 0); ?>%</h4>
                        </div>
                        <div class="align-self-center">
                            <i class="fas fa-percentage fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Filter Laporan</h5>
                </div>
                <div class="card-body">
                    <form method="GET" action="<?php echo e(route('admin.apbdes.laporan')); ?>">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Tahun</label>
                                    <select class="form-select" name="tahun">
                                        <?php for($year = date('Y'); $year >= 2020; $year--): ?>
                                            <option value="<?php echo e($year); ?>" <?php echo e(request('tahun', date('Y')) == $year ? 'selected' : ''); ?>>
                                                <?php echo e($year); ?>

                                            </option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Kategori</label>
                                    <select class="form-select" name="kategori">
                                        <option value="">Semua Kategori</option>
                                        <option value="pendapatan" <?php echo e(request('kategori') == 'pendapatan' ? 'selected' : ''); ?>>Pendapatan</option>
                                        <option value="belanja" <?php echo e(request('kategori') == 'belanja' ? 'selected' : ''); ?>>Belanja</option>
                                        <option value="pembiayaan" <?php echo e(request('kategori') == 'pembiayaan' ? 'selected' : ''); ?>>Pembiayaan</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">Status</label>
                                    <select class="form-select" name="status">
                                        <option value="">Semua Status</option>
                                        <option value="verified" <?php echo e(request('status') == 'verified' ? 'selected' : ''); ?>>Terverifikasi</option>
                                        <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                        <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>Ditolak</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label class="form-label">&nbsp;</label>
                                    <div class="d-grid gap-2">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-filter me-1"></i> Filter
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Report Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-file-invoice text-primary me-2"></i>
                        Laporan Detail APBDes
                    </h5>
                    <div class="btn-group">
                        <button class="btn btn-success" onclick="exportExcel()">
                            <i class="fas fa-file-excel me-1"></i> Export Excel
                        </button>
                        <button class="btn btn-danger" onclick="exportPDF()">
                            <i class="fas fa-file-pdf me-1"></i> Export PDF
                        </button>
                        <button class="btn btn-info" onclick="print()">
                            <i class="fas fa-print me-1"></i> Print
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="laporanTable">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Kode Rekening</th>
                                    <th>Uraian</th>
                                    <th>Kategori</th>
                                    <th>Anggaran</th>
                                    <th>Realisasi</th>
                                    <th>Sisa</th>
                                    <th>Persentase</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $laporan ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><code><?php echo e($item->kode_rekening); ?></code></td>
                                    <td><?php echo e($item->uraian); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($item->kategori == 'pendapatan' ? 'success' : ($item->kategori == 'belanja' ? 'warning' : 'info')); ?>">
                                            <?php echo e(ucfirst($item->kategori)); ?>

                                        </span>
                                    </td>
                                    <td>Rp <?php echo e(number_format($item->anggaran, 0, ',', '.')); ?></td>
                                    <td>Rp <?php echo e(number_format($item->total_realisasi ?? 0, 0, ',', '.')); ?></td>
                                    <td>Rp <?php echo e(number_format($item->anggaran - ($item->total_realisasi ?? 0), 0, ',', '.')); ?></td>
                                    <td>
                                        <?php
                                            $persentase = $item->anggaran > 0 ? (($item->total_realisasi ?? 0) / $item->anggaran) * 100 : 0;
                                        ?>
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar bg-<?php echo e($persentase > 80 ? 'danger' : ($persentase > 60 ? 'warning' : 'success')); ?>" 
                                                 style="width: <?php echo e($persentase); ?>%">
                                                <?php echo e(number_format($persentase, 1)); ?>%
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($item->status == 'aktif' ? 'success' : 'secondary'); ?>">
                                            <?php echo e(ucfirst($item->status)); ?>

                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">Tidak ada data laporan</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Chart Section -->
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Grafik Anggaran vs Realisasi</h5>
                </div>
                <div class="card-body">
                    <canvas id="budgetChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Distribusi per Kategori</h5>
                </div>
                <div class="card-body">
                    <canvas id="categoryChart" width="400" height="200"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Sample chart data - replace with actual data
const budgetData = {
    labels: ['Pendapatan', 'Belanja', 'Pembiayaan'],
    datasets: [{
        label: 'Anggaran',
        data: [500000000, 450000000, 50000000],
        backgroundColor: 'rgba(54, 162, 235, 0.7)'
    }, {
        label: 'Realisasi',
        data: [450000000, 400000000, 30000000],
        backgroundColor: 'rgba(255, 99, 132, 0.7)'
    }]
};

const budgetCtx = document.getElementById('budgetChart').getContext('2d');
const budgetChart = new Chart(budgetCtx, {
    type: 'bar',
    data: budgetData,
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return 'Rp ' + value.toLocaleString('id-ID');
                    }
                }
            }
        }
    }
});

const categoryData = {
    labels: ['Pendapatan', 'Belanja', 'Pembiayaan'],
    datasets: [{
        data: [500000000, 450000000, 50000000],
        backgroundColor: [
            'rgba(54, 162, 235, 0.7)',
            'rgba(255, 206, 86, 0.7)',
            'rgba(75, 192, 192, 0.7)'
        ]
    }]
};

const categoryCtx = document.getElementById('categoryChart').getContext('2d');
const categoryChart = new Chart(categoryCtx, {
    type: 'doughnut',
    data: categoryData,
    options: {
        responsive: true
    }
});

function exportExcel() {
    alert('Export Excel akan segera diimplementasikan');
}

function exportPDF() {
    alert('Export PDF akan segera diimplementasikan');
}

function print() {
    window.print();
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<style>
@media print {
    .card-header .btn-group,
    .topbar,
    .sidebar {
        display: none !important;
    }
    
    .main-content {
        margin-left: 0 !important;
    }
    
    .card {
        box-shadow: none !important;
        border: 1px solid #000 !important;
    }
}
</style>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/apbdes/laporan.blade.php ENDPATH**/ ?>