

<?php $__env->startSection('title', 'Data Penduduk - Test Version'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4>🧪 Data Penduduk - Test Version</h4>
                    <p class="text-muted mb-0">Versi sederhana untuk testing - Modal backdrop sudah diperbaiki</p>
                </div>
                <div class="card-body">
                    <!-- Test Modal Backdrop Fix -->
                    <div class="alert alert-info">
                        <h5><i class="fas fa-info-circle"></i> Status Perbaikan Modal Backdrop</h5>
                        <ul class="mb-0">
                            <li>✅ CSS modal-fix.css telah ditambahkan</li>
                            <li>✅ JavaScript modal-fix.js telah ditambahkan</li>
                            <li>✅ Enhanced event handlers telah diimplementasi</li>
                            <li>✅ Periodic cleanup telah diaktifkan</li>
                        </ul>
                    </div>

                    <!-- Test Button -->
                    <div class="mb-4">
                        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#testModal">
                            <i class="fas fa-test-tube"></i> Test Modal (Tidak Ada Backdrop)
                        </button>
                        <button type="button" class="btn btn-success" onclick="testCleanup()">
                            <i class="fas fa-broom"></i> Manual Cleanup
                        </button>
                        <button type="button" class="btn btn-info" onclick="checkBackdrops()">
                            <i class="fas fa-search"></i> Check Backdrops
                        </button>
                    </div>

                    <!-- Stats Cards -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card bg-primary text-white">
                                <div class="card-body">
                                    <h4><?php echo e($stats['total'] ?? 0); ?></h4>
                                    <p class="mb-0">Total Penduduk</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-info text-white">
                                <div class="card-body">
                                    <h4><?php echo e($stats['laki_laki'] ?? 0); ?></h4>
                                    <p class="mb-0">Laki-laki</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-pink text-white">
                                <div class="card-body">
                                    <h4><?php echo e($stats['perempuan'] ?? 0); ?></h4>
                                    <p class="mb-0">Perempuan</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card bg-warning text-white">
                                <div class="card-body">
                                    <h4><?php echo e($stats['anak'] ?? 0); ?></h4>
                                    <p class="mb-0">Anak-anak</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Simple Data Table -->
                    <div class="card">
                        <div class="card-header">
                            <h5>Data Penduduk</h5>
                        </div>
                        <div class="card-body">
                            <?php if(isset($penduduk) && count($penduduk) > 0): ?>
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>No</th>
                                                <th>NIK</th>
                                                <th>Nama</th>
                                                <th>L/P</th>
                                                <th>Umur</th>
                                                <th>Alamat</th>
                                                <th>Aksi</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $penduduk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($index + 1); ?></td>
                                                <td><?php echo e($p->nik ?? '-'); ?></td>
                                                <td><?php echo e($p->nama ?? '-'); ?></td>
                                                <td>
                                                    <?php if($p->jenis_kelamin == 'L'): ?>
                                                        <span class="badge bg-primary">L</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-pink">P</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($p->tanggal_lahir ? \Carbon\Carbon::parse($p->tanggal_lahir)->age : '-'); ?></td>
                                                <td><?php echo e($p->alamat ?? '-'); ?></td>
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-info" onclick="showDetail(<?php echo e($p->id); ?>)">
                                                        <i class="fas fa-eye"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>

                                <!-- Pagination -->
                                <?php if(method_exists($penduduk, 'links')): ?>
                                    <?php echo e($penduduk->links()); ?>

                                <?php endif; ?>
                            <?php else: ?>
                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    Tidak ada data penduduk yang ditemukan.
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Test Modal -->
<div class="modal fade" id="testModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Test Modal</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Ini adalah test modal untuk memastikan backdrop tidak tertinggal.</p>
                <p><strong>Cara test:</strong></p>
                <ol>
                    <li>Tutup modal ini dengan tombol X atau click outside</li>
                    <li>Pastikan tidak ada overlay gelap yang tertinggal</li>
                    <li>Halaman masih bisa di-scroll normal</li>
                </ol>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

<!-- Detail Modal -->
<div class="modal fade" id="detailModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detail Penduduk</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="detailContent">
                <div class="text-center">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.bg-pink {
    background-color: #e91e63 !important;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    console.log('🧪 Test version loaded');
    
    // Force clean on page load
    if (typeof window.forceCleanModalBackdrops === 'function') {
        window.forceCleanModalBackdrops();
        console.log('✅ Modal cleanup function available');
    } else {
        console.log('⚠️ Modal cleanup function not available');
    }
});

function testCleanup() {
    if (typeof window.forceCleanModalBackdrops === 'function') {
        window.forceCleanModalBackdrops();
        alert('✅ Manual cleanup executed!');
    } else {
        alert('❌ Cleanup function not available');
    }
}

function checkBackdrops() {
    const backdrops = document.querySelectorAll('.modal-backdrop, div[class*="backdrop"]');
    const modalOpen = document.body.classList.contains('modal-open');
    
    alert(`📊 Backdrop Check:\n` +
          `- Backdrop elements: ${backdrops.length}\n` +
          `- Body modal-open class: ${modalOpen ? 'Yes' : 'No'}\n` +
          `- Body overflow: ${document.body.style.overflow || 'default'}`);
}

function showDetail(id) {
    $('#detailModal').modal('show');
    
    fetch(`/admin/penduduk/${id}`, {
        method: 'GET',
        headers: {
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const penduduk = data.data;
            $('#detailContent').html(`
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr><td><strong>NIK:</strong></td><td>${penduduk.nik}</td></tr>
                            <tr><td><strong>Nama:</strong></td><td>${penduduk.nama}</td></tr>
                            <tr><td><strong>Jenis Kelamin:</strong></td><td>${penduduk.jenis_kelamin === 'L' ? 'Laki-laki' : 'Perempuan'}</td></tr>
                            <tr><td><strong>Tempat/Tgl Lahir:</strong></td><td>${penduduk.tempat_lahir}, ${penduduk.tanggal_lahir}</td></tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr><td><strong>Alamat:</strong></td><td>${penduduk.alamat}</td></tr>
                            <tr><td><strong>RT/RW:</strong></td><td>${penduduk.rt}/${penduduk.rw}</td></tr>
                            <tr><td><strong>Agama:</strong></td><td>${penduduk.agama}</td></tr>
                            <tr><td><strong>Status Kawin:</strong></td><td>${penduduk.status_kawin}</td></tr>
                        </table>
                    </div>
                </div>
            `);
        } else {
            $('#detailContent').html('<div class="alert alert-danger">Gagal memuat detail penduduk</div>');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        $('#detailContent').html('<div class="alert alert-danger">Terjadi kesalahan saat memuat data</div>');
    });
}

// Enhanced modal event handlers
$(document).on('hidden.bs.modal', '.modal', function () {
    console.log('Modal hidden, cleaning up...');
    if (typeof window.forceCleanModalBackdrops === 'function') {
        window.forceCleanModalBackdrops();
    }
});
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/penduduk/index-simple.blade.php ENDPATH**/ ?>