<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Berita Desa - Portal Desa</title>
    <meta name="description" content="Kumpulan berita terbaru dari desa. Informasi kegiatan, pengumuman, dan perkembangan terkini.">
    <meta name="keywords" content="berita desa, pengumuman, informasi desa, kegiatan">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
        }
        
        .hero-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 80px 0 50px;
        }
        
        .page-title {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 20px;
        }
        
        .page-subtitle {
            font-size: 1.2rem;
            opacity: 0.9;
            margin-bottom: 30px;
        }
        
        .search-filter-section {
            background: white;
            border-radius: 20px;
            padding: 30px;
            margin-top: -30px;
            position: relative;
            z-index: 3;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .search-box input {
            border-radius: 25px;
            padding: 15px 50px 15px 20px;
            border: 2px solid #e9ecef;
        }
        
        .filter-tabs .nav-link {
            border: 2px solid #e9ecef;
            border-radius: 25px;
            color: #6c757d;
            font-weight: 500;
            padding: 10px 20px;
            margin-right: 10px;
            transition: all 0.3s ease;
        }
        
        .filter-tabs .nav-link.active {
            background: #667eea;
            border-color: #667eea;
            color: white;
        }
        
        .news-card {
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            height: 100%;
            margin-bottom: 30px;
        }
        
        .news-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 50px rgba(0,0,0,0.15);
        }
        
        .news-image {
            width: 100%;
            height: 250px;
            object-fit: cover;
        }
        
        .news-content {
            padding: 25px;
        }
        
        .news-category {
            display: inline-block;
            background: #667eea;
            color: white;
            padding: 5px 15px;
            border-radius: 15px;
            font-size: 0.8rem;
            font-weight: 500;
            margin-bottom: 15px;
        }
        
        .news-title {
            font-size: 1.3rem;
            font-weight: 600;
            margin-bottom: 15px;
            color: #2c3e50;
            line-height: 1.4;
        }
        
        .news-title a {
            color: inherit;
            text-decoration: none;
        }
        
        .news-title a:hover {
            color: #667eea;
        }
        
        .news-excerpt {
            color: #6c757d;
            font-size: 0.95rem;
            line-height: 1.6;
            margin-bottom: 20px;
        }
        
        .news-meta {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding-top: 20px;
            border-top: 1px solid #e9ecef;
            font-size: 0.85rem;
            color: #6c757d;
        }
        
        .empty-state {
            text-align: center;
            padding: 80px 20px;
            color: #6c757d;
        }
        
        .empty-state i {
            font-size: 4rem;
            margin-bottom: 20px;
            color: #dee2e6;
        }
    </style>
</head>
<body>
    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="text-center">
                <h1 class="page-title">Berita Desa</h1>
                <p class="page-subtitle">Informasi terkini dan kegiatan desa</p>
            </div>
        </div>
    </section>

    <!-- Search and Filter Section -->
    <div class="container">
        <div class="search-filter-section">
            <form method="GET" action="<?php echo e(route('public.berita.index')); ?>">
                <div class="row align-items-end">
                    <div class="col-lg-6 mb-3">
                        <label class="form-label fw-bold">Cari Berita</label>
                        <div class="search-box">
                            <input type="text" name="search" class="form-control" 
                                   placeholder="Masukkan kata kunci..." 
                                   value="<?php echo e(request('search')); ?>">
                        </div>
                    </div>
                    <div class="col-lg-6 mb-3">
                        <label class="form-label fw-bold">Filter Kategori</label>
                        <div class="filter-tabs">
                            <a class="nav-link <?php echo e(!request('kategori') ? 'active' : ''); ?>" 
                               href="<?php echo e(route('public.berita.index')); ?>">
                                Semua
                            </a>
                            <?php if(isset($categories)): ?>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a class="nav-link <?php echo e(request('kategori') == $category ? 'active' : ''); ?>" 
                               href="<?php echo e(route('public.berita.index', ['kategori' => $category])); ?>">
                                <?php echo e(ucfirst($category)); ?>

                            </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="text-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-search"></i> Cari
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- News Grid -->
    <div class="container">
        <div class="news-grid mt-5">
            <?php if(isset($berita) && $berita->count() > 0): ?>
            <div class="row">
                <?php $__currentLoopData = $berita; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="news-card">
                        <?php if($item->gambar): ?>
                        <img src="<?php echo e(asset('storage/' . $item->gambar)); ?>" 
                             alt="<?php echo e($item->alt_text ?? $item->judul); ?>" 
                             class="news-image">
                        <?php else: ?>
                        <div style="height: 250px; background: linear-gradient(45deg, #f8f9fa, #e9ecef); display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-newspaper fa-4x text-muted"></i>
                        </div>
                        <?php endif; ?>
                        
                        <div class="news-content">
                            <span class="news-category"><?php echo e(ucfirst($item->kategori)); ?></span>
                            <h4 class="news-title">
                                <a href="<?php echo e(route('public.berita.show', $item->slug)); ?>">
                                    <?php echo e(Str::limit($item->judul, 60)); ?>

                                </a>
                            </h4>
                            <?php if($item->ringkasan): ?>
                            <p class="news-excerpt"><?php echo e(Str::limit($item->ringkasan, 120)); ?></p>
                            <?php endif; ?>
                            <div class="news-meta">
                                <div>
                                    <i class="fas fa-user"></i>
                                    <span><?php echo e($item->user->name ?? 'Admin'); ?></span>
                                </div>
                                <div>
                                    <i class="fas fa-calendar-alt"></i>
                                    <span><?php echo e($item->tanggal_terbit ? $item->tanggal_terbit->format('d/m/Y') : $item->created_at->format('d/m/Y')); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <!-- Pagination -->
            <?php if(method_exists($berita, 'links')): ?>
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($berita->appends(request()->query())->links()); ?>

            </div>
            <?php endif; ?>
            
            <?php else: ?>
            <div class="empty-state">
                <i class="fas fa-newspaper"></i>
                <h4>Belum Ada Berita</h4>
                <p>Berita akan ditampilkan di sini ketika sudah tersedia.</p>
                <?php if(request('search') || request('kategori')): ?>
                <a href="<?php echo e(route('public.berita.index')); ?>" class="btn btn-primary">
                    <i class="fas fa-arrow-left"></i> Lihat Semua Berita
                </a>
                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Footer Spacing -->
    <div style="height: 80px;"></div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> <?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/public/berita/index.blade.php ENDPATH**/ ?>