

<?php $__env->startSection('title', 'Edit Bantuan Sosial'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-edit me-2 text-primary"></i>Edit Bantuan Sosial
            </h2>
            <p class="text-muted mb-0">Edit program bantuan #<?php echo e($bantuan->id ?? '1'); ?></p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.bantuan.index')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-hand-holding-heart me-2"></i>Edit Program Bantuan</h5>
                </div>
                <div class="card-body">
                    <form id="editBantuanForm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        
                        <div class="mb-3">
                            <label class="form-label">Jenis Bantuan</label>
                            <select class="form-select" name="jenis_bantuan" required>
                                <option value="">Pilih Jenis Bantuan</option>
                                <option value="blt">Bantuan Langsung Tunai (BLT)</option>
                                <option value="pkh">Program Keluarga Harapan (PKH)</option>
                                <option value="bpnt">Bantuan Pangan Non Tunai (BPNT)</option>
                                <option value="bansos">Bantuan Sosial</option>
                                <option value="bpjs">Bantuan BPJS</option>
                                <option value="lainnya">Lainnya</option>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Nama Program</label>
                            <input type="text" class="form-control" name="nama_program" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Status Program</label>
                            <select class="form-select" name="status">
                                <option value="aktif">Aktif</option>
                                <option value="nonaktif">Non Aktif</option>
                                <option value="selesai">Selesai</option>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Deskripsi</label>
                            <textarea class="form-control" name="deskripsi" rows="4"></textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Periode Mulai</label>
                                    <input type="date" class="form-control" name="periode_mulai" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Periode Selesai</label>
                                    <input type="date" class="form-control" name="periode_selesai">
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Jumlah Bantuan</label>
                            <input type="number" class="form-control" name="jumlah_bantuan">
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Update Program Bantuan
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h6><i class="fas fa-info-circle me-2"></i>Informasi</h6>
                    <p class="text-muted">Form edit untuk memperbarui data program bantuan sosial.</p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.getElementById('editBantuanForm').addEventListener('submit', function(e) {
    e.preventDefault();
    showToast('Program bantuan berhasil diperbarui', 'success');
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/bantuan/edit.blade.php ENDPATH**/ ?>