

<?php $__env->startSection('title', 'Role Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-user-shield me-2 text-primary"></i>Role Management
            </h2>
            <p class="text-muted mb-0">Kelola peran dan hak akses pengguna</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.roles.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i>Tambah Role
            </a>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="rolesTable">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Nama Role</th>
                            <th>Display Name</th>
                            <th>Deskripsi</th>
                            <th>Jumlah User</th>
                            <th>Status</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $roles ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($loop->iteration); ?></td>
                            <td>
                                <span class="badge bg-secondary"><?php echo e($role->name); ?></span>
                            </td>
                            <td class="fw-bold"><?php echo e($role->display_name); ?></td>
                            <td><?php echo e(Str::limit($role->description, 50)); ?></td>
                            <td>
                                <span class="badge bg-info"><?php echo e($role->users_count); ?> User</span>
                            </td>
                            <td>
                                <?php if($role->is_active): ?>
                                    <span class="badge bg-success">Aktif</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Non-aktif</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('admin.roles.show', $role->id)); ?>" 
                                       class="btn btn-sm btn-outline-info" title="Lihat Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.roles.edit', $role->id)); ?>" 
                                       class="btn btn-sm btn-outline-warning" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-sm btn-outline-secondary" 
                                            onclick="toggleStatus(<?php echo e($role->id); ?>)" title="Toggle Status">
                                        <i class="fas fa-toggle-<?php echo e($role->is_active ? 'on' : 'off'); ?>"></i>
                                    </button>
                                    <?php if($role->users_count == 0): ?>
                                    <button type="button" class="btn btn-sm btn-outline-danger" 
                                            onclick="deleteRole(<?php echo e($role->id); ?>)" title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    $('#rolesTable').DataTable({
        responsive: true,
        language: {
            url: '//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json'
        }
    });
});

function toggleStatus(roleId) {
    fetch(`/admin/roles/${roleId}/toggle-status`, {
        method: 'PUT',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Content-Type': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Status role berhasil diubah', 'success');
            location.reload();
        } else {
            showToast(data.message || 'Gagal mengubah status', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    });
}

function deleteRole(roleId) {
    if (confirm('Apakah Anda yakin ingin menghapus role ini?')) {
        fetch(`/admin/roles/${roleId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Role berhasil dihapus', 'success');
                location.reload();
            } else {
                showToast(data.message || 'Gagal menghapus role', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        });
    }
}
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/roles/index.blade.php ENDPATH**/ ?>