

<?php $__env->startSection('title', 'Portal Desa Digital - Beranda'); ?>

<?php $__env->startSection('content'); ?>
<!-- Header with Village Info -->
<section class="hero-section-mobile py-4">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-auto">
                <i class="fas fa-map-marker-alt fa-2x text-warning"></i>
            </div>
            <div class="col">
                <h5 class="mb-0 text-white fw-bold">Portal Desa Digital</h5>
                <p class="mb-0 text-light small">Sistem Informasi Desa Terpadu</p>
            </div>
            <div class="col-auto">
                <button class="btn btn-outline-light btn-sm">
                    <i class="fas fa-bell"></i>
                </button>
            </div>
        </div>
    </div>
</section>

<!-- Quick Stats Cards -->
<section class="py-3 bg-light">
    <div class="container">
        <div class="row g-2">
            <div class="col-6 col-md-3">
                <div class="stats-card-mini text-center p-3">
                    <h4 class="fw-bold text-primary mb-1"><?php echo e(number_format($stats['total_penduduk'])); ?></h4>
                    <small class="text-muted">Penduduk</small>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="stats-card-mini text-center p-3">
                    <h4 class="fw-bold text-success mb-1"><?php echo e(number_format($stats['total_keluarga'])); ?></h4>
                    <small class="text-muted">Keluarga</small>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="stats-card-mini text-center p-3">
                    <h4 class="fw-bold text-warning mb-1"><?php echo e(number_format($stats['total_surat'])); ?></h4>
                    <small class="text-muted">Surat</small>
                </div>
            </div>
            <div class="col-6 col-md-3">
                <div class="stats-card-mini text-center p-3">
                    <h4 class="fw-bold text-info mb-1"><?php echo e(number_format($stats['total_pengaduan'])); ?></h4>
                    <small class="text-muted">Pengaduan</small>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Services Grid -->
<section class="py-4">
    <div class="container">
        <div class="row mb-3">
            <div class="col">
                <h5 class="fw-bold mb-0">Layanan Desa</h5>
                <small class="text-muted">Pilih layanan yang Anda butuhkan</small>
            </div>
        </div>
        
        <div class="row g-3">
            <div class="col-6 col-md-3">
                <a href="<?php echo e(route('public.ajukan-surat')); ?>" class="text-decoration-none">
                    <div class="service-card-mobile text-center p-3">
                        <div class="service-icon-mobile mb-2">
                            <i class="fas fa-file-alt fa-2x text-primary"></i>
                        </div>
                        <h6 class="fw-bold mb-1">Surat Online</h6>
                        <small class="text-muted">Pengajuan surat</small>
                    </div>
                </a>
            </div>
            
            <div class="col-6 col-md-3">
                <a href="<?php echo e(route('public.pengaduan')); ?>" class="text-decoration-none">
                    <div class="service-card-mobile text-center p-3">
                        <div class="service-icon-mobile mb-2">
                            <i class="fas fa-comments fa-2x text-danger"></i>
                        </div>
                        <h6 class="fw-bold mb-1">Pengaduan</h6>
                        <small class="text-muted">Lapor masalah</small>
                    </div>
                </a>
            </div>
            
            <div class="col-6 col-md-3">
                <a href="<?php echo e(route('public.cek-layanan')); ?>" class="text-decoration-none">
                    <div class="service-card-mobile text-center p-3">
                        <div class="service-icon-mobile mb-2">
                            <i class="fas fa-search fa-2x text-success"></i>
                        </div>
                        <h6 class="fw-bold mb-1">Cek Status</h6>
                        <small class="text-muted">Tracking layanan</small>
                    </div>
                </a>
            </div>
            
            <div class="col-6 col-md-3">
                <a href="<?php echo e(route('berita.index')); ?>" class="text-decoration-none">
                    <div class="service-card-mobile text-center p-3">
                        <div class="service-icon-mobile mb-2">
                            <i class="fas fa-newspaper fa-2x text-info"></i>
                        </div>
                        <h6 class="fw-bold mb-1">Berita</h6>
                        <small class="text-muted">Info terbaru</small>
                    </div>
                </a>
            </div>
            
            <div class="col-6 col-md-3">
                <a href="<?php echo e(route('peta.index')); ?>" class="text-decoration-none">
                    <div class="service-card-mobile text-center p-3">
                        <div class="service-icon-mobile mb-2">
                            <i class="fas fa-map-marked-alt fa-2x text-warning"></i>
                        </div>
                        <h6 class="fw-bold mb-1">Peta Desa</h6>
                        <small class="text-muted">Lokasi warga</small>
                    </div>
                </a>
            </div>
            
            <div class="col-6 col-md-3">
                <a href="<?php echo e(route('public.info-bantuan')); ?>" class="text-decoration-none">
                    <div class="service-card-mobile text-center p-3">
                        <div class="service-icon-mobile mb-2">
                            <i class="fas fa-heart fa-2x text-danger"></i>
                        </div>
                        <h6 class="fw-bold mb-1">Bantuan</h6>
                        <small class="text-muted">Program sosial</small>
                    </div>
                </a>
            </div>
            
            <div class="col-6 col-md-3">
                <a href="<?php echo e(route('public.tentang')); ?>" class="text-decoration-none">
                    <div class="service-card-mobile text-center p-3">
                        <div class="service-icon-mobile mb-2">
                            <i class="fas fa-home fa-2x text-success"></i>
                        </div>
                        <h6 class="fw-bold mb-1">Profil Desa</h6>
                        <small class="text-muted">Info lengkap</small>
                    </div>
                </a>
            </div>
            
            <div class="col-6 col-md-3">
                <a href="<?php echo e(route('public.kontak')); ?>" class="text-decoration-none">
                    <div class="service-card-mobile text-center p-3">
                        <div class="service-icon-mobile mb-2">
                            <i class="fas fa-phone fa-2x text-primary"></i>
                        </div>
                        <h6 class="fw-bold mb-1">Kontak</h6>
                        <small class="text-muted">Hubungi kami</small>
                    </div>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- News Section -->
<?php if($berita_terbaru->count() > 0): ?>
<section class="py-4 bg-light">
    <div class="container">
        <div class="row mb-3">
            <div class="col">
                <h5 class="fw-bold mb-0">Berita & Pengumuman</h5>
                <small class="text-muted">Informasi terkini dari desa</small>
            </div>
            <div class="col-auto">
                <a href="<?php echo e(route('public.berita.index')); ?>" class="btn btn-outline-primary btn-sm">Lihat Semua</a>
            </div>
        </div>
        
        <div class="row g-3">
            <?php $__currentLoopData = $berita_terbaru->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $berita): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-12">
                <a href="<?php echo e(route('public.berita.show', $berita->slug)); ?>" class="text-decoration-none">
                    <div class="card news-card-mobile">
                        <div class="row g-0">
                            <div class="col-4">
                                <?php if($berita->gambar): ?>
                                    <img src="<?php echo e(Storage::url($berita->gambar)); ?>" 
                                         class="img-fluid rounded-start h-100" 
                                         alt="<?php echo e($berita->judul); ?>" 
                                         style="object-fit: cover; min-height: 100px;">
                                <?php else: ?>
                                    <div class="bg-light d-flex align-items-center justify-content-center h-100 rounded-start" style="min-height: 100px;">
                                        <i class="fas fa-image fa-2x text-muted"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-8">
                                <div class="card-body p-3">
                                    <h6 class="card-title mb-2 text-dark"><?php echo e(Str::limit($berita->judul, 50)); ?></h6>
                                    <p class="card-text small text-muted mb-2">
                                        <?php echo e(Str::limit(strip_tags($berita->konten ?? $berita->isi), 80)); ?>

                                    </p>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <small class="text-muted">
                                            <i class="fas fa-calendar me-1"></i><?php echo e($berita->created_at->format('d M Y')); ?>

                                        </small>
                                        <?php if($berita->views > 0): ?>
                                        <small class="text-muted">
                                            <i class="fas fa-eye me-1"></i><?php echo e(number_format($berita->views)); ?> views
                                        </small>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Village Info Cards -->
<section class="py-4">
    <div class="container">
        <div class="row mb-3">
            <div class="col">
                <h5 class="fw-bold mb-0">Informasi Desa</h5>
                <small class="text-muted">Data dan statistik desa</small>
            </div>
        </div>
        
        <div class="row g-3">
            <div class="col-12 col-md-6">
                <div class="info-card p-3">
                    <div class="d-flex align-items-center mb-3">
                        <i class="fas fa-chart-bar fa-2x text-primary me-3"></i>
                        <div>
                            <h6 class="mb-0 fw-bold">Data Demografis</h6>
                            <small class="text-muted">Update terbaru</small>
                        </div>
                    </div>
                    <div class="row text-center">
                        <div class="col-6">
                            <h4 class="fw-bold text-primary"><?php echo e(number_format($stats['total_penduduk'])); ?></h4>
                            <small>Total Penduduk</small>
                        </div>
                        <div class="col-6">
                            <h4 class="fw-bold text-success"><?php echo e(number_format($stats['total_keluarga'])); ?></h4>
                            <small>Kepala Keluarga</small>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-12 col-md-6">
                <div class="info-card p-3">
                    <div class="d-flex align-items-center mb-3">
                        <i class="fas fa-cogs fa-2x text-success me-3"></i>
                        <div>
                            <h6 class="mb-0 fw-bold">Layanan Aktif</h6>
                            <small class="text-muted">Bulan ini</small>
                        </div>
                    </div>
                    <div class="row text-center">
                        <div class="col-6">
                            <h4 class="fw-bold text-warning"><?php echo e(number_format($stats['total_surat'])); ?></h4>
                            <small>Surat Diproses</small>
                        </div>
                        <div class="col-6">
                            <h4 class="fw-bold text-info"><?php echo e(number_format($stats['total_pengaduan'])); ?></h4>
                            <small>Pengaduan</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Quick Actions -->
<section class="py-4 bg-primary text-white">
    <div class="container">
        <div class="text-center mb-4">
            <h5 class="fw-bold mb-2">Perlu Bantuan?</h5>
            <p class="mb-0">Akses cepat ke layanan yang sering digunakan</p>
        </div>
        
        <div class="row g-2">
            <div class="col-6">
                <a href="<?php echo e(route('public.ajukan-surat')); ?>" class="btn btn-warning w-100">
                    <i class="fas fa-file-alt me-2"></i>Ajukan Surat
                </a>
            </div>
            <div class="col-6">
                <a href="<?php echo e(route('public.pengaduan')); ?>" class="btn btn-outline-light w-100">
                    <i class="fas fa-comments me-2"></i>Buat Pengaduan
                </a>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .hero-section-mobile {
        background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
        min-height: auto;
    }
    
    .stats-card-mini {
        background: white;
        border-radius: 10px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        transition: transform 0.2s;
    }
    
    .stats-card-mini:hover {
        transform: translateY(-2px);
    }
    
    .service-card-mobile {
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        transition: all 0.3s;
        border: 1px solid #f0f0f0;
    }
    
    .service-card-mobile:hover {
        transform: translateY(-3px);
        box-shadow: 0 8px 25px rgba(0,0,0,0.15);
    }
    
    .service-icon-mobile {
        width: 60px;
        height: 60px;
        background: rgba(44, 90, 160, 0.1);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto;
    }
    
    .news-card-mobile {
        border: none;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        overflow: hidden;
        transition: all 0.3s ease;
    }
    
    .news-card-mobile:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 20px rgba(0,0,0,0.15);
    }
    
    .news-card-mobile img {
        transition: transform 0.3s ease;
    }
    
    .news-card-mobile:hover img {
        transform: scale(1.05);
    }
    
    .info-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.08);
        border: 1px solid #f0f0f0;
    }
    
    /* Mobile optimizations */
    @media (max-width: 768px) {
        .container {
            padding-left: 1rem;
            padding-right: 1rem;
        }
        
        .service-card-mobile {
            padding: 1rem 0.5rem !important;
        }
        
        .service-card-mobile h6 {
            font-size: 0.9rem;
        }
        
        .service-card-mobile small {
            font-size: 0.75rem;
        }
        
        .service-icon-mobile {
            width: 50px;
            height: 50px;
        }
        
        .service-icon-mobile i {
            font-size: 1.5rem !important;
        }
    }
</style>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/public/index.blade.php ENDPATH**/ ?>