<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($berita->judul ?? 'Detail Berita'); ?> - Sistem Informasi Desa</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <!-- Meta Tags -->
    <meta name="description" content="<?php echo e(Str::limit(strip_tags($berita->konten ?? ''), 160)); ?>">
    <meta name="keywords" content="berita desa, <?php echo e($berita->kategori ?? ''); ?>, informasi desa">
    <meta name="author" content="<?php echo e($berita->penulis ?? 'Admin Desa'); ?>">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="<?php echo e($berita->judul ?? 'Detail Berita'); ?>">
    <meta property="og:description" content="<?php echo e(Str::limit(strip_tags($berita->konten ?? ''), 160)); ?>">
    <?php
        // Get the best image for sharing
        $shareImage = '';
        if($berita->gambar ?? false) {
            $shareImage = asset('storage/' . $berita->gambar);
        } else {
            // Try to get first image from content
            if($berita->konten ?? false) {
                try {
                    $dom = new DOMDocument();
                    libxml_use_internal_errors(true);
                    $dom->loadHTML('<?xml encoding="utf-8" ?>' . $berita->konten);
                    libxml_clear_errors();
                    
                    $imageElements = $dom->getElementsByTagName('img');
                    if($imageElements->length > 0) {
                        $firstImg = $imageElements->item(0);
                        $src = $firstImg->getAttribute('src');
                        
                        if($src && !empty(trim($src))) {
                            if(strpos($src, 'http') === 0) {
                                $shareImage = $src;
                            } elseif(strpos($src, '/storage/') === 0) {
                                $shareImage = asset($src);
                            } elseif(strpos($src, 'storage/') === 0) {
                                $shareImage = asset($src);
                            } else {
                                $shareImage = asset('storage/' . $src);
                            }
                        }
                    }
                } catch (Exception $e) {
                    // Silently handle errors
                }
            }
        }
        
        // Fallback to default image
        if(empty($shareImage)) {
            $shareImage = asset('img/default-news.jpg');
        }
    ?>
    <meta property="og:image" content="<?php echo e($shareImage); ?>">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:type" content="image/jpeg">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:type" content="article">
    <meta property="og:site_name" content="Sistem Informasi Desa">
    <meta property="og:locale" content="id_ID">
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e($berita->judul ?? 'Detail Berita'); ?>">
    <meta name="twitter:description" content="<?php echo e(Str::limit(strip_tags($berita->konten ?? ''), 160)); ?>">
    <meta name="twitter:image" content="<?php echo e($shareImage); ?>">
    <meta name="twitter:image:alt" content="<?php echo e($berita->judul ?? 'Detail Berita'); ?>">
    
    <!-- Additional Article Meta Tags -->
    <?php if($berita->created_at ?? false): ?>
    <meta property="article:published_time" content="<?php echo e($berita->created_at->toISOString()); ?>">
    <?php endif; ?>
    <?php if($berita->updated_at ?? false): ?>
    <meta property="article:modified_time" content="<?php echo e($berita->updated_at->toISOString()); ?>">
    <?php endif; ?>
    <?php if($berita->penulis ?? false): ?>
    <meta property="article:author" content="<?php echo e($berita->penulis); ?>">
    <?php endif; ?>
    <?php if($berita->kategori ?? false): ?>
    <meta property="article:section" content="<?php echo e($berita->kategori); ?>">
    <?php endif; ?>
    
    <!-- Schema.org Structured Data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "NewsArticle",
        "headline": "<?php echo e($berita->judul ?? 'Detail Berita'); ?>",
        "description": "<?php echo e(Str::limit(strip_tags($berita->konten ?? ''), 160)); ?>",
        "image": "<?php echo e($shareImage); ?>",
        "datePublished": "<?php echo e(($berita->created_at ?? now())->toISOString()); ?>",
        "dateModified": "<?php echo e(($berita->updated_at ?? $berita->created_at ?? now())->toISOString()); ?>",
        "author": {
            "@type": "Person",
            "name": "<?php echo e($berita->penulis ?? 'Admin Desa'); ?>"
        },
        "publisher": {
            "@type": "Organization",
            "name": "Sistem Informasi Desa",
            "logo": {
                "@type": "ImageObject",
                "url": "<?php echo e(asset('img/logo.png')); ?>"
            }
        },
        "url": "<?php echo e(url()->current()); ?>",
        "mainEntityOfPage": "<?php echo e(url()->current()); ?>"
    }
    </script>
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#3B82F6">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Sistem Desa">
    <link rel="manifest" href="/manifest.json">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    
    <!-- CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eff6ff',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8'
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        /* Custom SweetAlert2 Styles */
        .swal2-popup {
            font-family: 'Inter', system-ui, sans-serif !important;
            border-radius: 16px !important;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25) !important;
        }
        
        .swal2-title {
            font-weight: 600 !important;
            color: #1f2937 !important;
        }
        
        .swal2-content {
            color: #6b7280 !important;
        }
        
        .swal2-confirm {
            border-radius: 8px !important;
            padding: 10px 20px !important;
            font-weight: 500 !important;
        }
        
        .swal2-cancel {
            border-radius: 8px !important;
            padding: 10px 20px !important;
            font-weight: 500 !important;
        }
        
        .swal2-timer-progress-bar {
            background: rgba(59, 130, 246, 0.8) !important;
        }
        
        /* Toast positioning for mobile */
        .swal2-toast {
            margin: 20px !important;
        }
        
        body {
            font-family: 'Inter', system-ui, sans-serif;
        }
        
        .mobile-card {
            background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
            border-radius: 0;
            padding: 0;
            box-shadow: none;
            border: none;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            overflow: hidden;
            word-wrap: break-word;
            position: relative;
            margin-bottom: 0;
            transform: none;
            width: 100%;
        }
        
        .mobile-card:hover {
            transform: none;
            box-shadow: none;
        }
        
        /* Instagram-style post header */
        .post-header {
            padding: 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-bottom: none;
            background: linear-gradient(135deg, rgba(255,255,255,0.98) 0%, rgba(248,250,252,0.95) 100%);
            border-radius: 0;
            position: relative;
            backdrop-filter: blur(10px);
        }
        
        .post-header::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 20px;
            right: 20px;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(0,0,0,0.08), transparent);
        }
        
        .post-author {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .author-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: linear-gradient(45deg, #f09433 0%, #e6683c 25%, #dc2743 50%, #cc2366 75%, #bc1888 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 14px;
            box-shadow: 0 4px 12px rgba(240, 148, 51, 0.3);
            border: 2px solid rgba(255,255,255,0.8);
        }
        
        .author-info h4 {
            font-size: 14px;
            font-weight: 600;
            color: #262626;
            margin: 0;
        }
        
        .author-info p {
            font-size: 12px;
            color: #8e8e8e;
            margin: 0;
        }
        
        .post-menu {
            color: #262626;
            cursor: pointer;
        }
        
        .article-content-card {
            background: transparent;
            border-radius: 0;
            padding: 0;
            box-shadow: none;
            border: none;
            position: relative;
            overflow: visible;
        }
        
        /* Instagram-style post image carousel */
        .post-image-container {
            position: relative;
            width: 100%;
            min-height: 300px;
            max-height: 500px;
            overflow: hidden;
            background: #f8f9fa;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .post-image-container {
                min-height: 250px;
                max-height: 400px;
            }
            
            .post-image {
                min-height: 250px;
                max-height: 400px;
            }
        }
        
        @media (max-width: 480px) {
            .post-image-container {
                min-height: 200px;
                max-height: 350px;
            }
            
            .post-image {
                min-height: 200px;
                max-height: 350px;
            }
        }
        
        .post-image-carousel {
            display: flex;
            transition: transform 0.3s ease;
            width: 100%;
            cursor: grab;
            user-select: none;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
        }
        
        .post-image-carousel:active {
            cursor: grabbing;
        }
        
        .post-image-carousel.dragging {
            transition: none;
        }
        
        .post-image {
            width: 100%;
            height: auto;
            min-height: 300px;
            max-height: 500px;
            object-fit: contain;
            object-position: center;
            display: block;
            flex-shrink: 0;
            background: #f8f9fa;
            transition: opacity 0.3s ease, transform 0.2s ease;
        }
        
        .post-image:hover {
            transform: scale(1.02);
        }
        
        .post-image.loading {
            opacity: 0.7;
            background-image: linear-gradient(90deg, #f0f0f0 25%, transparent 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: loading 1.5s infinite;
        }
        
        @keyframes loading {
            0% { background-position: 200% 0; }
            100% { background-position: -200% 0; }
        }
        
        /* Share Article Section Styles */
        .share-header {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 20px;
            padding: 0 20px;
            padding-top: 20px;
        }
        
        .share-icon {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, #3b82f6, #1d4ed8);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
        }
        
        .share-title {
            font-size: 16px;
            font-weight: 600;
            color: #1f2937;
            margin: 0;
        }
        
        .share-buttons-grid {
            display: flex;
            flex-wrap: nowrap;
            gap: 8px;
            padding: 0 20px 20px 20px;
            overflow-x: auto;
            scrollbar-width: none;
            -ms-overflow-style: none;
        }
        
        .share-buttons-grid::-webkit-scrollbar {
            display: none;
        }
        
        .share-btn {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 6px;
            padding: 12px 8px;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            background: white;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
            font-size: 12px;
            font-weight: 500;
            text-align: center;
            position: relative;
            overflow: hidden;
            min-width: 70px;
            flex-shrink: 0;
        }
        
        .share-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.8), transparent);
            transition: left 0.5s ease;
        }
        
        .share-btn:hover::before {
            left: 100%;
        }
        
        .share-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }
        
        .share-btn:active {
            transform: translateY(0);
        }
        
        .share-btn-icon {
            width: 28px;
            height: 28px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }
        
        .share-btn-icon svg {
            width: 18px;
            height: 18px;
        }
        
        .share-btn-text {
            color: #374151;
            font-weight: 500;
        }
        
        /* Individual share button styles */
        .share-btn.whatsapp:hover {
            border-color: #25d366;
            background: linear-gradient(135deg, #25d366, #128c7e);
            color: white;
        }
        
        .share-btn.whatsapp .share-btn-icon {
            background: linear-gradient(135deg, #25d366, #128c7e);
            color: white;
        }
        
        .share-btn.whatsapp:hover .share-btn-text {
            color: white;
        }
        
        .share-btn.facebook:hover {
            border-color: #1877f2;
            background: linear-gradient(135deg, #1877f2, #166fe5);
            color: white;
        }
        
        .share-btn.facebook .share-btn-icon {
            background: linear-gradient(135deg, #1877f2, #166fe5);
            color: white;
        }
        
        .share-btn.facebook:hover .share-btn-text {
            color: white;
        }
        
        .share-btn.twitter:hover {
            border-color: #1da1f2;
            background: linear-gradient(135deg, #1da1f2, #0d8bd9);
            color: white;
        }
        
        .share-btn.twitter .share-btn-icon {
            background: linear-gradient(135deg, #1da1f2, #0d8bd9);
            color: white;
        }
        
        .share-btn.twitter:hover .share-btn-text {
            color: white;
        }
        
        .share-btn.telegram:hover {
            border-color: #0088cc;
            background: linear-gradient(135deg, #0088cc, #006699);
            color: white;
        }
        
        .share-btn.telegram .share-btn-icon {
            background: linear-gradient(135deg, #0088cc, #006699);
            color: white;
        }
        
        .share-btn.telegram:hover .share-btn-text {
            color: white;
        }
        
        .share-btn.copy-link:hover {
            border-color: #6b7280;
            background: linear-gradient(135deg, #6b7280, #4b5563);
            color: white;
        }
        
        .share-btn.copy-link .share-btn-icon {
            background: linear-gradient(135deg, #6b7280, #4b5563);
            color: white;
        }
        
        .share-btn.copy-link:hover .share-btn-text {
            color: white;
        }
        

        
        /* Responsive adjustments for share buttons */
        @media (max-width: 480px) {
            .share-btn {
                min-width: 65px;
                padding: 10px 6px;
            }
            
            .share-btn-text {
                font-size: 11px;
            }
            
            .share-btn-icon {
                width: 24px;
                height: 24px;
            }
            
            .share-btn-icon svg {
                width: 16px;
                height: 16px;
            }
        }
        
        .post-image-placeholder {
            width: 100%;
            height: 300px;
            background: #f0f0f0;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }
        
        /* Carousel navigation dots */
        .carousel-dots {
            position: absolute;
            bottom: 12px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 6px;
            z-index: 10;
        }
        
        .carousel-dot {
            width: 6px;
            height: 6px;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.4);
            cursor: pointer;
            transition: background 0.2s ease;
        }
        
        .carousel-dot.active {
            background: rgba(255, 255, 255, 1);
        }
        
        /* Carousel navigation arrows */
        .carousel-nav {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            width: 30px;
            height: 30px;
            background: rgba(0, 0, 0, 0.5);
            border: none;
            border-radius: 50%;
            color: white;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 10;
            opacity: 0;
            transition: opacity 0.2s ease;
        }
        
        .carousel-nav:hover {
            background: rgba(0, 0, 0, 0.7);
        }
        
        .carousel-nav.prev {
            left: 12px;
        }
        
        .carousel-nav.next {
            right: 12px;
        }
        
        .post-image-container:hover .carousel-nav {
            opacity: 1;
        }
        
        /* Image counter */
        .image-counter {
            position: absolute;
            top: 12px;
            right: 12px;
            background: rgba(0, 0, 0, 0.6);
            color: white;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 500;
            z-index: 10;
        }
        
        /* Instagram-style action buttons */
        .post-actions {
            padding: 12px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: none;
            background: linear-gradient(135deg, rgba(255,255,255,0.98) 0%, rgba(248,250,252,0.95) 100%);
            position: relative;
        }
        
        .post-actions::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 20px;
            right: 20px;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(0,0,0,0.06), transparent);
        }
        
        .action-buttons {
            display: flex;
            gap: 16px;
        }
        
                .action-btn {
            background: none;
            border: none;
            cursor: pointer;
            padding: 10px;
            color: #262626;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            border-radius: 50%;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .action-btn:hover {
            color: #8e8e8e;
            background: rgba(0,0,0,0.05);
            transform: scale(1.1);
        }

        .action-btn.liked {
            color: #ed4956;
            animation: heartBeat 0.6s ease-in-out;
        }

        .action-btn.with-count {
            flex-direction: row;
            gap: 6px;
            padding: 8px 12px;
            border-radius: 20px;
        }

        .action-count {
            font-size: 13px;
            font-weight: 600;
            color: #262626;
            min-width: 16px;
            text-align: center;
            line-height: 1;
        }

        .action-btn.with-count:hover .action-count {
            color: #8e8e8e;
        }

        .action-btn.liked .action-count {
            color: #ed4956;
        }
        
        @keyframes heartBeat {
            0% { transform: scale(1); }
            50% { transform: scale(1.2); }
            100% { transform: scale(1); }
        }
        
        /* Instagram-style content area */
        .post-content {
            padding: 20px;
            background: linear-gradient(135deg, rgba(255,255,255,0.98) 0%, rgba(248,250,252,0.95) 100%);
            border-radius: 0;
            position: relative;
        }
        
        .post-likes {
            font-size: 14px;
            font-weight: 600;
            color: #262626;
            margin-bottom: 8px;
        }
        
        .post-caption {
            font-size: 14px;
            color: #262626;
            line-height: 1.4;
            margin-bottom: 8px;
        }
        
        .post-caption .username {
            font-weight: 600;
            margin-right: 8px;
        }
        
        .instagram-content {
            font-size: 14px;
            line-height: 1.4;
            color: #262626;
            word-wrap: break-word;
            display: inline;
        }
        
        .post-time {
            font-size: 10px;
            color: #8e8e8e;
            text-transform: uppercase;
            letter-spacing: 0.2px;
            margin-top: 8px;
        }
        
        .share-card {
            background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
            border-radius: 30px 15px 30px 15px;
            padding: 20px;
            box-shadow: 0 6px 24px rgba(0,0,0,0.1), 0 2px 8px rgba(0,0,0,0.06);
            border: none;
            position: relative;
            overflow: hidden;
            transform: rotate(0.3deg);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .share-card:hover {
            transform: rotate(0deg) translateY(-2px);
            box-shadow: 0 8px 30px rgba(0,0,0,0.12), 0 3px 10px rgba(0,0,0,0.08);
        }
        
        .share-card:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, #10b981, #3b82f6, #8b5cf6);
            border-radius: 30px 15px 0 0;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .category-badge {
            display: inline-block;
            padding: 0;
            font-size: 14px;
            font-weight: 400;
            border-radius: 0;
            position: relative;
            overflow: visible;
            text-transform: lowercase;
            letter-spacing: 0;
            box-shadow: none;
            border: none;
            backdrop-filter: none;
            background: none;
            color: #00376b;
            cursor: pointer;
        }
        
        .category-badge:hover {
            text-decoration: underline;
        }
        
        .category-pengumuman { background-color: #fef2f2; color: #991b1b; }
        .category-berita { background-color: #eff6ff; color: #1e40af; }
        .category-kegiatan { background-color: #f0fdf4; color: #166534; }
        .category-kesehatan { background-color: #ecfdf5; color: #065f46; }
        .category-umkm { background-color: #fef3c7; color: #92400e; }
        .category-pembangunan { background-color: #fef3e2; color: #ea580c; }
        .category-sosial { background-color: #f3e8ff; color: #7c3aed; }
        .category-pendidikan { background-color: #ecfeff; color: #0891b2; }
        .category-keamanan { background-color: #fefce8; color: #ca8a04; }
        .category-lainnya { background-color: #f1f5f9; color: #475569; }
        .category-default { background-color: #f9fafb; color: #374151; }
        
        .content-body {
            line-height: 1.4;
            word-wrap: break-word;
            word-break: break-word;
            overflow-wrap: break-word;
            max-width: 100%;
            overflow: hidden;
            font-size: 14px;
            color: #262626;
            text-align: left;
            letter-spacing: 0;
            font-weight: 400;
        }
        
        .content-body h1, .content-body h2, .content-body h3 {
            font-weight: 700;
            margin: 2rem 0 1.2rem 0;
            color: #1a202c;
            word-wrap: break-word;
            overflow-wrap: break-word;
            max-width: 100%;
            position: relative;
            padding-left: 16px;
            line-height: 1.3;
        }
        
        .content-body h1:before, .content-body h2:before, .content-body h3:before {
            content: '';
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            width: 4px;
            height: 60%;
            background: linear-gradient(135deg, #3b82f6, #8b5cf6);
            border-radius: 2px;
        }
        
        .content-body h1 { 
            font-size: 1.5rem; 
            color: #2563eb;
            margin-top: 2.5rem;
        }
        .content-body h2 { 
            font-size: 1.3rem; 
            color: #3730a3;
            margin-top: 2.2rem;
        }
        .content-body h3 { 
            font-size: 1.15rem; 
            color: #4338ca;
            margin-top: 2rem;
        }
        
        .content-body p {
            margin-bottom: 1.4rem;
            color: #2d3748;
            word-wrap: break-word;
            overflow-wrap: break-word;
            max-width: 100%;
            text-indent: 0;
            line-height: 1.7;
            font-size: 16px;
            text-align: left;
            orphans: 2;
            widows: 2;
        }
        
        .content-body p:first-of-type {
            font-size: 17px;
            font-weight: 500;
            color: #1a202c;
            background: linear-gradient(135deg, #f7fafc 0%, #edf2f7 100%);
            padding: 20px;
            border-radius: 12px;
            border-left: 4px solid #3b82f6;
            text-indent: 0;
            margin-bottom: 2rem;
            line-height: 1.6;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }
        
        .content-body ul, .content-body ol {
            margin: 2rem 0;
            padding-left: 2rem;
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            border-radius: 12px;
            padding: 20px 20px 20px 3rem;
            border: 1px solid #e2e8f0;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        }
        
        .content-body li {
            margin-bottom: 1rem;
            color: #2d3748;
            word-wrap: break-word;
            overflow-wrap: break-word;
            max-width: 100%;
            line-height: 1.6;
            position: relative;
            font-size: 16px;
        }
        
        .content-body ul li:before {
            content: '•';
            color: #3b82f6;
            font-weight: bold;
            position: absolute;
            left: -1.5rem;
            font-size: 1.2rem;
        }
        
        .content-body img {
            max-width: 100%;
            height: auto;
            border-radius: 12px;
            margin: 1.5rem 0;
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
            border: 1px solid #e2e8f0;
        }
        
        .content-body blockquote {
            background: linear-gradient(135deg, #eff6ff 0%, #dbeafe 100%);
            border-left: 4px solid #3b82f6;
            border-radius: 0 12px 12px 0;
            padding: 24px 28px;
            margin: 2.5rem 0;
            font-style: italic;
            color: #1e40af;
            word-wrap: break-word;
            overflow-wrap: break-word;
            max-width: 100%;
            position: relative;
            font-size: 17px;
            line-height: 1.7;
            box-shadow: 0 2px 10px rgba(59, 130, 246, 0.1);
            font-weight: 500;
        }
        
        .content-body blockquote:before {
            content: '"';
            font-size: 4rem;
            color: #3b82f6;
            opacity: 0.3;
            position: absolute;
            top: -10px;
            left: 10px;
            font-family: serif;
        }
        
        /* Universal text wrapping for all content-body elements */
        .content-body * {
            word-wrap: break-word !important;
            overflow-wrap: break-word !important;
            max-width: 100% !important;
            box-sizing: border-box !important;
        }
        
        /* Reading enhancement effects */
        .content-body p:hover {
            background: linear-gradient(135deg, rgba(59, 130, 246, 0.02) 0%, rgba(139, 92, 246, 0.02) 100%);
            border-radius: 8px;
            padding: 12px 16px;
            margin: 0 -16px;
            transition: all 0.3s ease;
            box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        }
        
        /* Better reading flow */
        .content-body {
            max-width: none;
            margin: 0 auto;
        }
        
        /* Improved spacing for better reading rhythm */
        .content-body > *:first-child {
            margin-top: 0;
        }
        
        .content-body > *:last-child {
            margin-bottom: 0;
        }
        
        /* Enhanced focus for screen readers */
        .content-body:focus {
            outline: 2px solid #3b82f6;
            outline-offset: 4px;
        }
        
        .article-content-card:hover {
            box-shadow: 0 8px 35px rgba(0,0,0,0.12), inset 0 1px 0 rgba(255,255,255,0.8);
            transform: translateY(-1px);
        }
        
        /* Smooth scroll behavior */
        html {
            scroll-behavior: smooth;
        }
        
        /* Selection styling */
        .content-body ::selection {
            background: linear-gradient(135deg, #3b82f6, #8b5cf6);
            color: white;
        }
        
        /* Focus states for accessibility */
        .mobile-card:focus-within,
        .article-content-card:focus-within,
        .share-card:focus-within {
            outline: 2px solid #3b82f6;
            outline-offset: 2px;
        }
        
        .share-button {
            background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
            border: 2px solid #e2e8f0;
            border-radius: 14px;
            padding: 14px;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            overflow: hidden;
        }
        
        .share-button:before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.8), transparent);
            transition: left 0.6s;
        }
        
        .share-button:hover:before {
            left: 100%;
        }
        
        .share-button:hover {
            transform: translateY(-3px) scale(1.05);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
            border-color: currentColor;
        }
        
        .related-article {
            background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
            border-radius: 20px 8px 20px 8px;
            padding: 16px;
            box-shadow: 0 4px 16px rgba(0,0,0,0.08), 0 2px 6px rgba(0,0,0,0.04);
            border: none;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            cursor: pointer;
            position: relative;
            overflow: hidden;
            transform: rotate(-0.2deg);
        }
        
        .related-article:nth-child(even) {
            transform: rotate(0.2deg);
            border-radius: 8px 20px 8px 20px;
        }
        
        .related-article:before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, #3b82f6, #8b5cf6, #ec4899);
            border-radius: 20px 8px 0 0;
            transform: scaleX(0);
            transition: transform 0.3s ease;
        }
        
        .related-article:nth-child(even):before {
            border-radius: 8px 20px 0 0;
        }
        
        .related-article:hover:before {
            transform: scaleX(1);
        }
        
        .related-article:hover {
            transform: rotate(0deg) translateY(-3px) scale(1.02);
            box-shadow: 0 8px 28px rgba(0, 0, 0, 0.12), 0 4px 10px rgba(0,0,0,0.08);
        }
        
        .reading-progress {
            position: fixed;
            top: 0;
            left: 0;
            width: 0%;
            height: 4px;
            background: linear-gradient(135deg, #3b82f6 0%, #8b5cf6 50%, #ec4899 100%);
            z-index: 1000;
            transition: width 0.3s ease;
            border-radius: 0 0 2px 0;
        }
        
        /* Organic floating elements */
        .organic-bg {
            position: relative;
            overflow: hidden;
        }
        
        .organic-bg::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -10%;
            width: 100px;
            height: 100px;
            background: linear-gradient(45deg, rgba(59, 130, 246, 0.1), rgba(139, 92, 246, 0.1));
            border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%;
            animation: float 6s ease-in-out infinite;
            z-index: 1;
        }
        
        .organic-bg::after {
            content: '';
            position: absolute;
            bottom: -30%;
            left: -5%;
            width: 80px;
            height: 80px;
            background: linear-gradient(45deg, rgba(236, 72, 153, 0.1), rgba(59, 130, 246, 0.1));
            border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%;
            animation: float 8s ease-in-out infinite reverse;
            z-index: 1;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px) rotate(0deg); }
            50% { transform: translateY(-20px) rotate(180deg); }
        }
        
        /* Content area organic styling */
        .content-area {
            position: relative;
            z-index: 10;
        }
        
        /* Comments Section Styling - Instagram Style */
        .comments-section {
            background: white;
            padding: 0;
            border-top: none;
        }
        
        .comments-header {
            display: none;
        }
        
        /* Add Comment Form - Instagram Style */
        .add-comment-form {
            display: flex;
            align-items: flex-start;
            padding: 16px 20px;
            border-top: 1px solid #efefef;
            background: white;
            gap: 12px;
        }
        
        .comment-user-avatar .user-avatar,
        .comment-avatar .user-avatar {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            background: linear-gradient(45deg, #f09433 0%, #e6683c 25%, #dc2743 50%, #cc2366 75%, #bc1888 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 10px;
            flex-shrink: 0;
        }

        .comment-form-wrapper {
            flex: 1;
            display: flex;
            flex-direction: column;
            gap: 8px;
        }

        .user-info-fields {
            display: flex;
            flex-direction: column;
            gap: 8px;
            margin-bottom: 8px;
            animation: slideDown 0.3s ease;
        }

        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .input-group {
            display: flex;
            flex-direction: column;
        }

        .user-info-input {
            width: 100%;
            border: 1px solid #dbdbdb;
            border-radius: 8px;
            padding: 10px 12px;
            font-size: 14px;
            outline: none;
            background: #fafafa;
            transition: all 0.2s ease;
        }

        .user-info-input:focus {
            border-color: #0095f6;
            background: white;
            box-shadow: 0 0 0 2px rgba(0, 149, 246, 0.1);
        }
        
        .comment-input-wrapper {
            width: 100%;
            display: flex;
            align-items: center;
        }
        
        .comment-input {
            width: 100%;
            border: none;
            outline: none;
            padding: 0;
            font-size: 14px;
            color: #262626;
            background: transparent;
            resize: none;
            font-family: inherit;
            line-height: 18px;
        }
        
        .comment-input::placeholder {
            color: #8e8e8e;
        }
        
        .comment-actions {
            margin: 0;
            display: flex;
            gap: 8px;
            justify-content: flex-end;
            margin-top: 8px;
            animation: slideDown 0.3s ease;
        }

        .comment-cancel-btn {
            background: transparent;
            color: #8e8e8e;
            border: 1px solid #dbdbdb;
            border-radius: 6px;
            padding: 8px 16px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .comment-cancel-btn:hover {
            background: #f5f5f5;
            color: #262626;
        }
        
        .comment-submit-btn {
            background: #0095f6;
            color: white;
            border: none;
            border-radius: 6px;
            padding: 8px 16px;
            font-size: 14px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
        }
        
        .comment-submit-btn:hover {
            background: #1877f2;
        }
        
        .comment-submit-btn:disabled {
            background: #b3d9ff;
            cursor: not-allowed;
        }
        
        /* Comments List - Instagram Style */
        .comments-list {
            background: white;
            padding: 0;
        }
        
        .comment-item {
            display: flex;
            align-items: flex-start;
            padding: 12px 20px;
            gap: 12px;
        }
        
        .comment-content {
            flex: 1;
            min-width: 0;
        }
        
        .comment-header {
            display: none;
        }
        
        .comment-text {
            font-size: 14px;
            color: #262626;
            line-height: 18px;
            margin: 0;
            word-wrap: break-word;
        }
        
        .comment-username {
            font-weight: 600;
            color: #262626;
            margin-right: 6px;
        }
        
        .comment-meta {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-top: 8px;
        }
        
        .comment-time {
            font-size: 12px;
            color: #8e8e8e;
            font-weight: 400;
        }
        
        .comment-actions {
            display: flex;
            align-items: center;
            gap: 12px;
            margin: 0;
        }
        
        .comment-like-btn,
        .comment-reply-btn {
            background: none;
            border: none;
            color: #8e8e8e;
            font-size: 12px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 4px;
            transition: color 0.2s ease;
            padding: 0;
        }
        
        .comment-like-btn:hover,
        .comment-reply-btn:hover {
            color: #262626;
        }
        
        .comment-like-btn.liked {
            color: #ed4956;
        }
        
        .comment-like-btn svg {
            width: 12px;
            height: 12px;
        }
        
        .load-more-comments {
            padding: 16px 20px;
            background: white;
        }
        
        .load-more-btn {
            background: none;
            border: none;
            color: #8e8e8e;
            padding: 0;
            font-size: 14px;
            font-weight: 400;
            cursor: pointer;
            transition: color 0.2s ease;
        }
        
        .load-more-btn:hover {
            color: #262626;
            background: rgba(0,0,0,0.05);
        }
        
        .load-more-btn {
            display: flex;
            align-items: center;
            gap: 8px;
            margin: 0 auto;
            padding: 8px 16px;
            border-radius: 20px;
            transition: all 0.3s ease;
        }
        
        .load-more-icon {
            transition: transform 0.3s ease;
        }
        
        .load-more-btn.expanded .load-more-icon {
            transform: rotate(180deg);
        }
        
        .hidden-comments {
            transition: all 0.3s ease;
            overflow: hidden;
            max-height: 0;
            opacity: 0;
        }
        
        .hidden-comments.show {
            display: block;
            max-height: 1000px;
            opacity: 1;
            animation: slideDown 0.4s ease;
        }
        
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* FontAwesome Icon Emoji Fallbacks */
        .fas.fa-home:before { 
            content: "🏠" !important; 
            font-family: system-ui !important; 
        }
        .fas.fa-newspaper:before { 
            content: "📰" !important; 
            font-family: system-ui !important; 
        }
        .fas.fa-map-marked-alt:before { 
            content: "🗺️" !important; 
            font-family: system-ui !important; 
        }
        .fas.fa-store:before { 
            content: "🏪" !important; 
            font-family: system-ui !important; 
        }
        .fas.fa-user-shield:before { 
            content: "🛡️" !important; 
            font-family: system-ui !important; 
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Reading Progress Bar -->
    <div class="reading-progress" id="readingProgress"></div>
    
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        
        <!-- Header/Status Bar -->
        <div class="gradient-bg text-white px-6 py-5 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 left-0 w-40 h-40 bg-white rounded-full -translate-x-20 -translate-y-20"></div>
                <div class="absolute bottom-0 right-0 w-32 h-32 bg-white rounded-full translate-x-16 translate-y-16"></div>
            </div>
            
            <!-- Header Content -->
            <div class="relative z-10">
                <div class="flex items-center justify-between">
                    <div class="flex items-center space-x-3">
                        <button onclick="history.back()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                            </svg>
                        </button>
                        <div>
                            <h1 class="text-lg font-bold">Detail Berita</h1>
                            <p class="text-white/80 text-sm"><?php echo e($berita->kategori ?? 'Berita'); ?></p>
                        </div>
                    </div>
                    
                    <div class="flex space-x-2">
                        <button onclick="shareArticle()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.367 2.684 3 3 0 00-5.367-2.684z"/>
                            </svg>
                        </button>
                        <button onclick="toggleBookmark()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 5a2 2 0 012-2h10a2 2 0 012 2v16l-7-3.5L5 21V5z"/>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Content Area -->
        <div class="px-0 -mt-3 relative z-20 organic-bg">
            <div class="content-area">
            
            <!-- Instagram-style Post -->
            <div class="mobile-card mb-0">
                <!-- Post Header -->
                <div class="post-header">
                    <div class="post-author">
                        <div class="author-avatar">
                            AD
                        </div>
                        <div class="author-info">
                            <h4><?php echo e($berita->penulis ?? 'Admin Desa'); ?></h4>
                            <p><?php echo e($berita->created_at->diffForHumans() ?? ''); ?></p>
                        </div>
                    </div>
                    <div class="post-menu">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                            <path d="M10 6a2 2 0 110-4 2 2 0 010 4zM10 12a2 2 0 110-4 2 2 0 010 4zM10 18a2 2 0 110-4 2 2 0 010 4z"/>
                        </svg>
                    </div>
                </div>
                
                <!-- Post Image Carousel -->
                <?php
                    // Collect all images: featured image + images from content
                    $images = [];
                    
                    // Add featured image first
                    if($berita->gambar ?? false) {
                        $images[] = [
                            'type' => 'featured',
                            'src' => $berita->gambar,
                            'alt' => $berita->judul ?? 'Featured Image'
                        ];
                    }
                    
                    // Extract images from content (CKEditor)
                    if($berita->konten ?? false) {
                        try {
                            $dom = new DOMDocument();
                            libxml_use_internal_errors(true);
                            $dom->loadHTML('<?xml encoding="utf-8" ?>' . $berita->konten);
                            libxml_clear_errors();
                            
                            $imageElements = $dom->getElementsByTagName('img');
                            foreach($imageElements as $img) {
                                $src = $img->getAttribute('src');
                                $alt = $img->getAttribute('alt') ?: 'Content Image';
                                
                                if($src && !empty(trim($src))) {
                                    // Handle different image URL formats
                                    $imagePath = $src;
                                    
                                    // Clean up the image path
                                    if(strpos($src, 'http') === 0) {
                                        // External URL or full URL - check if it's our own domain
                                        $baseUrl = url('/storage/');
                                        if(strpos($src, $baseUrl) === 0) {
                                            // It's our own storage URL, extract relative path
                                            $imagePath = str_replace($baseUrl . '/', '', $src);
                                            // Make sure it starts with storage/ for consistency
                                            if(strpos($imagePath, 'storage/') !== 0) {
                                                $imagePath = 'storage/' . $imagePath;
                                            }
                                        } else {
                                            // External URL - use as is
                                            $imagePath = $src;
                                        }
                                    } elseif(strpos($src, '/storage/') === 0) {
                                        // Starts with /storage/ - remove prefix and ensure storage/ prefix
                                        $imagePath = ltrim($src, '/');
                                    } elseif(strpos($src, 'storage/') === 0) {
                                        // Already starts with storage/ - use as is
                                        $imagePath = $src;
                                    } else {
                                        // Relative path - add storage/ prefix
                                        $imagePath = 'storage/' . $src;
                                    }
                                    
                                    // Avoid duplicate images (check if featured image is same)
                                    $isDuplicate = false;
                                    if(isset($berita->gambar) && $berita->gambar) {
                                        $featuredPath = $berita->gambar;
                                        if($imagePath === $featuredPath || 
                                           basename($imagePath) === basename($featuredPath)) {
                                            $isDuplicate = true;
                                        }
                                    }
                                    
                                    if(!$isDuplicate) {
                                        $images[] = [
                                            'type' => 'content',
                                            'src' => $imagePath,
                                            'alt' => $alt,
                                            'original_src' => $src
                                        ];
                                    }
                                }
                            }
                        } catch (Exception $e) {
                            // Silently handle DOM parsing errors
                        }
                    }
                ?>
                
                <div class="post-image-container" id="imageContainer">
                    <?php if(count($images) > 0): ?>
                        <!-- Image Counter -->
                        <?php if(count($images) > 1): ?>
                        <div class="image-counter">
                            <span id="currentImageIndex">1</span> / <?php echo e(count($images)); ?>

                        </div>
                        <?php endif; ?>
                        
                        <!-- Carousel -->
                        <div class="post-image-carousel" id="imageCarousel">
                            <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($image['type'] === 'featured'): ?>
                                    <img src="<?php echo e(asset('storage/' . $image['src'])); ?>" 
                                         alt="<?php echo e($image['alt']); ?>" 
                                         class="post-image">
                                <?php elseif($image['type'] === 'content'): ?>
                                    <?php if(strpos($image['src'], 'http') === 0): ?>
                                        <!-- External URL -->
                                        <img src="<?php echo e($image['src']); ?>" 
                                             alt="<?php echo e($image['alt']); ?>" 
                                             class="post-image">
                                    <?php else: ?>
                                        <!-- Local storage image -->
                                        <img src="<?php echo e(asset('storage/' . $image['src'])); ?>" 
                                             alt="<?php echo e($image['alt']); ?>" 
                                             class="post-image">
                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        
                        <!-- Navigation Arrows -->
                        <?php if(count($images) > 1): ?>
                        <button class="carousel-nav prev" onclick="previousImage()">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                            </svg>
                        </button>
                        <button class="carousel-nav next" onclick="nextImage()">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                            </svg>
                        </button>
                        
                        <!-- Dots Navigation -->
                        <div class="carousel-dots">
                            <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="carousel-dot <?php echo e($index === 0 ? 'active' : ''); ?>" 
                                 onclick="goToImage(<?php echo e($index); ?>)"
                                 title="<?php echo e($image['alt']); ?>"></div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="post-image-placeholder">
                            <svg class="w-16 h-16 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z"/>
                            </svg>
                        </div>
                    <?php endif; ?>
                </div>
                
                <!-- Post Actions -->
                <div class="post-actions">
                    <div class="action-buttons">
                        <button class="action-btn with-count" onclick="toggleLike()">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                            </svg>
                            <span class="action-count" id="likeCount"><?php echo e($berita->likes_count ?? 0); ?></span>
                        </button>
                        <button class="action-btn with-count" onclick="openComments()">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 12h.01M12 12h.01M16 12h.01M21 12c0 4.418-4.03 8-9 8a9.863 9.863 0 01-4.255-.949L3 20l1.395-3.72C3.512 15.042 3 13.574 3 12c0-4.418 4.03-8 9-8s9 3.582 9 8z"/>
                            </svg>
                            <span class="action-count" id="commentCount"><?php echo e($berita->comments_count ?? 0); ?></span>
                        </button>
                        <button class="action-btn with-count" onclick="sharePost()">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8"/>
                            </svg>
                            <span class="action-count" id="shareCount"><?php echo e($berita->shares_count ?? 0); ?></span>
                        </button>
                    </div>
                    <button class="action-btn" onclick="savePost()">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 5a2 2 0 012-2h10a2 2 0 012 2v16l-7-3.5L5 21V5z"/>
                        </svg>
                    </button>
                </div>
                
                <!-- Post Content -->
                <div class="post-content">
                    <div class="post-likes"><?php echo e($berita->views ?? 0); ?> views</div>
                    
                    <div class="post-caption">
                        <span class="username">admin_desa</span>
                        <span class="instagram-content">
                            <?php
                                // Remove images from content text to avoid duplication
                                $cleanContent = $berita->konten ?? 'Konten berita tidak tersedia.';
                                if($cleanContent) {
                                    // Remove img tags from content
                                    $cleanContent = preg_replace('/<img[^>]*>/i', '', $cleanContent);
                                    // Remove empty paragraphs that might be left
                                    $cleanContent = preg_replace('/<p[^>]*>\s*<\/p>/i', '', $cleanContent);
                                    // Strip remaining HTML tags
                                    $cleanContent = strip_tags($cleanContent);
                                    // Clean up extra whitespace
                                    $cleanContent = preg_replace('/\s+/', ' ', trim($cleanContent));
                                }
                            ?>
                            <?php echo e($cleanContent); ?>

                        </span>
                        <br><br>
                        <span style="color: #00376b; font-weight: 500;">
                            #<?php echo e(strtolower(str_replace(' ', '', $berita->kategori ?? 'berita'))); ?> 
                            #desaku #pembangunan #infrastruktur #dana_desa #gotong_royong #kemajuan_desa
                        </span>
                    </div>
                    

                    
                    <div class="post-time"><?php echo e($berita->created_at->format('d M Y') ?? ''); ?></div>
                </div>
                
                <!-- Comments Section -->
                <div class="comments-section">
                    <!-- Comments List -->
                    <div class="comments-list">
                        <?php if($berita->comments && $berita->comments->count() > 0): ?>
                            <?php $__currentLoopData = $berita->comments->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="comment-item visible-comment">
                                <div class="comment-avatar">
                                    <div class="user-avatar"><?php echo e(strtoupper(substr($comment->author_name, 0, 1))); ?></div>
                                </div>
                                <div class="comment-content">
                                    <div class="comment-text">
                                        <span class="comment-username"><?php echo e($comment->author_name); ?></span>
                                        <?php echo e($comment->komentar); ?>

                                    </div>
                                    <div class="comment-meta">
                                        <span class="comment-time"><?php echo e($comment->time_ago); ?></span>
                                        <button class="comment-like-btn" onclick="toggleCommentLike(this)">
                                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                                            </svg>
                                        </button>
                                        <button class="comment-reply-btn" onclick="replyToComment('<?php echo e($comment->author_name); ?>')">Balas</button>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <div class="no-comments">
                                <p class="text-gray-500 text-sm text-center py-4">Belum ada komentar. Jadilah yang pertama berkomentar!</p>
                            </div>
                        <?php endif; ?>
                        
                        <?php if($berita->comments && $berita->comments->count() > 2): ?>
                        <!-- Hidden Comments (Initially Hidden) -->
                        <div class="hidden-comments" style="display: none;">
                            <?php $__currentLoopData = $berita->comments->skip(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="comment-item">
                                <div class="comment-avatar">
                                    <div class="user-avatar"><?php echo e(strtoupper(substr($comment->author_name, 0, 1))); ?></div>
                                </div>
                                <div class="comment-content">
                                    <div class="comment-text">
                                        <span class="comment-username"><?php echo e($comment->author_name); ?></span>
                                        <?php echo e($comment->komentar); ?>

                                    </div>
                                    <div class="comment-meta">
                                        <span class="comment-time"><?php echo e($comment->time_ago); ?></span>
                                        <button class="comment-like-btn" onclick="toggleCommentLike(this)">
                                            <svg fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                                            </svg>
                                        </button>
                                        <button class="comment-reply-btn" onclick="replyToComment('<?php echo e($comment->author_name); ?>')">Balas</button>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endif; ?>
                        
                        <?php if($berita->comments && $berita->comments->count() > 2): ?>
                        <!-- Load More Comments -->
                        <div class="load-more-comments">
                            <button class="load-more-btn" onclick="toggleAllComments()">
                                <span class="load-more-text">Lihat semua <?php echo e($berita->comments->count()); ?> komentar</span>
                                <svg class="load-more-icon" width="16" height="16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Add Comment Form -->
                    <div class="add-comment-form">
                        <div class="comment-user-avatar">
                            <div class="user-avatar">U</div>
                        </div>
                        <div class="comment-form-wrapper">
                            <!-- User Info Fields (Initially Hidden) -->
                            <div class="user-info-fields" id="userInfoFields" style="display: none;">
                                <div class="input-group">
                                    <input type="text" class="user-info-input" id="commentNama" placeholder="Nama Lengkap" required>
                                </div>
                                <div class="input-group">
                                    <input type="tel" class="user-info-input" id="commentHP" placeholder="Nomor HP (08xxxxxxxxxx)" required>
                                </div>
                            </div>
                            
                            <!-- Comment Input -->
                            <div class="comment-input-wrapper">
                                <input type="text" class="comment-input" id="commentText" placeholder="Tambahkan komentar..." onclick="showUserFields()">
                            </div>
                            
                            <!-- Submit Actions (Initially Hidden) -->
                            <div class="comment-actions" id="commentActions" style="display: none;">
                                <button class="comment-cancel-btn" onclick="cancelComment()">Batal</button>
                                <button class="comment-submit-btn" onclick="submitComment()">Kirim</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Share Article Section -->
            <div class="mobile-card mb-4">
                <div class="share-header">
                    <div class="share-icon">
                        <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.367 2.684 3 3 0 00-5.367-2.684z"/>
                        </svg>
                    </div>
                    <h3 class="share-title">Bagikan Artikel</h3>
                </div>
                
                <div class="share-buttons-grid">
                    <button onclick="showSharePreview('WhatsApp')" class="share-btn whatsapp">
                        <div class="share-btn-icon">
                            <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893A11.821 11.821 0 0020.885 3.488"/>
                            </svg>
                        </div>
                        <span class="share-btn-text">WhatsApp</span>
                    </button>
                    
                    <button onclick="showSharePreview('Facebook')" class="share-btn facebook">
                        <div class="share-btn-icon">
                            <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                            </svg>
                        </div>
                        <span class="share-btn-text">Facebook</span>
                    </button>
                    
                    <button onclick="showSharePreview('Twitter')" class="share-btn twitter">
                        <div class="share-btn-icon">
                            <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/>
                            </svg>
                        </div>
                        <span class="share-btn-text">Twitter</span>
                    </button>
                    
                    <button onclick="showSharePreview('Telegram')" class="share-btn telegram">
                        <div class="share-btn-icon">
                            <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M11.944 0A12 12 0 0 0 0 12a12 12 0 0 0 12 12 12 12 0 0 0 12-12A12 12 0 0 0 12 0a12 12 0 0 0-.056 0zm4.962 7.224c.1-.002.321.023.465.14a.506.506 0 0 1 .171.325c.016.093.036.306.02.472-.18 1.898-.962 6.502-1.36 8.627-.168.9-.499 1.201-.82 1.23-.696.065-1.225-.46-1.9-.902-1.056-.693-1.653-1.124-2.678-1.8-1.185-.78-.417-1.21.258-1.91.177-.184 3.247-2.977 3.307-3.23.007-.032.014-.15-.056-.212s-.174-.041-.249-.024c-.106.024-1.793 1.14-5.061 3.345-.48.33-.913.49-1.302.48-.428-.008-1.252-.241-1.865-.44-.752-.245-1.349-.374-1.297-.789.027-.216.325-.437.893-.663 3.498-1.524 5.83-2.529 6.998-3.014 3.332-1.386 4.025-1.627 4.476-1.635z"/>
                            </svg>
                        </div>
                        <span class="share-btn-text">Telegram</span>
                    </button>
                    
                    <button onclick="showSharePreview('Copy Link')" class="share-btn copy-link">
                        <div class="share-btn-icon">
                            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 16H6a2 2 0 01-2-2V6a2 2 0 012-2h8a2 2 0 012 2v2m-6 12h8a2 2 0 002-2v-8a2 2 0 00-2-2h-8a2 2 0 00-2 2v8a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <span class="share-btn-text">Salin Link</span>
                    </button>
                    

                </div>
            </div>

            <!-- Related Articles -->
            <?php if(isset($relatedBerita) && $relatedBerita->count() > 0): ?>
            <div class="mobile-card mb-4">
                <h3 class="font-medium text-gray-800 mb-3 text-sm">Berita Terkait</h3>
                <div class="space-y-2">
                    <?php $__currentLoopData = $relatedBerita; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="related-article" onclick="openArticle('<?php echo e($related->slug); ?>')">
                        <div class="flex space-x-2">
                            <?php if($related->gambar): ?>
                            <img src="<?php echo e(asset('storage/' . $related->gambar)); ?>" 
                                 alt="<?php echo e($related->judul); ?>" 
                                 class="w-14 h-10 object-cover rounded-lg flex-shrink-0">
                            <?php else: ?>
                            <div class="w-14 h-10 bg-gray-200 rounded-lg flex-shrink-0 flex items-center justify-center">
                                <svg class="w-3 h-3 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z"/>
                                </svg>
                            </div>
                            <?php endif; ?>
                            
                            <div class="flex-1">
                                <h4 class="font-medium text-gray-800 text-xs line-clamp-2 mb-1">
                                    <?php echo e($related->judul); ?>

                                </h4>
                                <div class="flex items-center justify-between text-xs text-gray-500">
                                    <span><?php echo e($related->created_at->diffForHumans()); ?></span>
                                    <span><?php echo e($related->views ?? 0); ?> views</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Comments Section (Optional) -->
            <div class="mobile-card mb-4">


            </div>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-100 px-4 py-3 z-50 shadow-lg backdrop-blur-sm bg-white/95">
            <div class="flex justify-around items-center">
                <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-home text-lg"></i>
                    </div>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1.5 text-blue-600 transition-all duration-200">
                    <div class="bg-blue-50 p-2 rounded-xl">
                        <i class="fas fa-newspaper text-lg"></i>
                    </div>
                    <span class="text-xs font-semibold">Berita</span>
                </button>
                
                <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-map-marked-alt text-lg"></i>
                    </div>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToService('umkm')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-store text-lg"></i>
                    </div>
                    <span class="text-xs">UMKM</span>
                </button>
                
                <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-user-shield text-lg"></i>
                    </div>
                    <span class="text-xs">Portal</span>
                </button>
            </div>
        </div>
        
        <!-- Spacer for bottom navigation -->
        <div class="h-24"></div>
    </div>

    <!-- JavaScript -->
    <script>
        // Instagram-style interactions
        let isLiked = false;
        let isSaved = false;
        
        // Image Carousel functionality
        let currentImageIndex = 0;
        let totalImages = 0;
        let startX = 0;
        let currentX = 0;
        let isDragging = false;
        let imageObserver = null;
        let lastImageCount = 0;
        
        // Initialize carousel
        function initializeCarousel() {
            const carousel = document.getElementById('imageCarousel');
            if (!carousel) return;
            
            totalImages = carousel.children.length;
            lastImageCount = totalImages;
            
            if (totalImages <= 1) {
                hideCarouselControls();
                return;
            }
            
            showCarouselControls();
            
            // Add touch event listeners for swipe
            carousel.addEventListener('touchstart', handleTouchStart, { passive: true });
            carousel.addEventListener('touchmove', handleTouchMove, { passive: true });
            carousel.addEventListener('touchend', handleTouchEnd, { passive: true });
            
            // Add mouse event listeners for desktop
            carousel.addEventListener('mousedown', handleMouseStart);
            carousel.addEventListener('mousemove', handleMouseMove);
            carousel.addEventListener('mouseup', handleMouseEnd);
            carousel.addEventListener('mouseleave', handleMouseEnd);
            
            // Initialize image synchronization
            initializeImageSync();
        }
        
        // Auto-sync images from content
        function initializeImageSync() {
            // Check for content changes periodically
            setInterval(syncImagesFromContent, 3000);
            
            // Setup advanced synchronization
            document.addEventListener('visibilitychange', handleVisibilityChange);
            
            // Setup content mutation observer
            setupContentObserver();
            
            // Sync from server periodically (every 30 seconds)
            setInterval(syncImagesFromServer, 30000);
            
            // Initial sync
            syncImagesFromContent();
            
            // Sync from server after a short delay
            setTimeout(syncImagesFromServer, 2000);
        }
        
        function syncImagesFromContent() {
            // This would be called to re-sync images if content changes
            const carousel = document.getElementById('imageCarousel');
            if (!carousel) return;
            
            const currentCount = carousel.children.length;
            
            // If image count changed, reinitialize
            if (currentCount !== lastImageCount) {
                console.log('Image count changed from', lastImageCount, 'to', currentCount);
                lastImageCount = currentCount;
                totalImages = currentCount;
                
                // Reset to first image if current index is out of bounds
                if (currentImageIndex >= totalImages) {
                    currentImageIndex = 0;
                }
                
                // Update UI
                updateCarouselControls();
                updateCarousel();
            }
        }
        
        // Advanced sync function for real-time content updates
        function syncImagesFromServer() {
            // This function can be called to fetch updated content from server
            const articleId = <?php echo e($berita->id ?? 'null'); ?>;
            if (!articleId) return;
            
                            fetch(`/api/v1/berita/${articleId}/images`, {
                method: 'GET',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '',
                    'Content-Type': 'application/json',
                },
            })
            .then(response => response.json())
            .then(data => {
                if (data.success && data.images) {
                    updateCarouselImages(data.images);
                }
            })
            .catch(error => {
                console.log('Image sync error:', error);
            });
        }
        
        function updateCarouselImages(newImages) {
            const carousel = document.getElementById('imageCarousel');
            const imageContainer = document.getElementById('imageContainer');
            if (!carousel || !imageContainer) return;
            
            // Store current position
            const wasAtIndex = currentImageIndex;
            
            // Clear existing images
            carousel.innerHTML = '';
            
            // Add new images
            newImages.forEach((image, index) => {
                const img = document.createElement('img');
                img.className = 'post-image';
                img.alt = image.alt || `Image ${index + 1}`;
                
                // Handle different image sources properly
                if (image.src.startsWith('http')) {
                    // Full URL - use as is
                    img.src = image.src;
                } else if (image.src.startsWith('/storage/')) {
                    // Already has /storage/ prefix
                    img.src = image.src;
                } else if (image.src.startsWith('storage/')) {
                    // Add leading slash
                    img.src = `/${image.src}`;
                } else {
                    // Assume it's a relative path that needs /storage/ prefix
                    img.src = `/storage/${image.src}`;
                }
                
                // Add loading error handler
                img.onerror = function() {
                    console.error('Failed to load image:', this.src);
                    
                    // Try to fix the URL if it's malformed
                    const originalSrc = this.src;
                    if (originalSrc.includes('/storage/http://') || originalSrc.includes('/storage/https://')) {
                        // Remove the /storage/ prefix from full URLs
                        const fixedSrc = originalSrc.replace('/storage/http://', 'http://').replace('/storage/https://', 'https://');
                        console.log('Attempting to fix malformed URL from:', originalSrc, 'to:', fixedSrc);
                        this.src = fixedSrc;
                        return;
                    }
                    
                    // If still fails, hide the image
                    this.style.display = 'none';
                };
                
                carousel.appendChild(img);
            });
            
            // Update counters and controls
            totalImages = newImages.length;
            lastImageCount = totalImages;
            
            // Adjust current index if needed
            if (wasAtIndex >= totalImages) {
                currentImageIndex = Math.max(0, totalImages - 1);
            } else {
                currentImageIndex = wasAtIndex;
            }
            
            // Update UI
            updateCarouselControls();
            updateCarousel();
            
            console.log('Images synchronized:', totalImages, 'images loaded');
        }
        
        // Auto-refresh images when page becomes visible
        function handleVisibilityChange() {
            if (!document.hidden) {
                // Page became visible, sync images
                setTimeout(() => {
                    syncImagesFromServer();
                }, 500);
            }
        }
        
        // Mutation observer for content changes
        function setupContentObserver() {
            const contentArea = document.querySelector('.post-content');
            if (!contentArea) return;
            
            const observer = new MutationObserver(function(mutations) {
                let hasImageChanges = false;
                
                mutations.forEach(function(mutation) {
                    if (mutation.type === 'childList') {
                        mutation.addedNodes.forEach(function(node) {
                            if (node.tagName === 'IMG' || (node.querySelector && node.querySelector('img'))) {
                                hasImageChanges = true;
                            }
                        });
                        
                        mutation.removedNodes.forEach(function(node) {
                            if (node.tagName === 'IMG' || (node.querySelector && node.querySelector('img'))) {
                                hasImageChanges = true;
                            }
                        });
                    }
                });
                
                if (hasImageChanges) {
                    console.log('Content images changed, syncing...');
                    setTimeout(() => {
                        syncImagesFromServer();
                    }, 1000);
                }
            });
            
            observer.observe(contentArea, {
                childList: true,
                subtree: true
            });
            
            return observer;
        }
        
        function updateCarouselControls() {
            const imageContainer = document.getElementById('imageContainer');
            if (!imageContainer) return;
            
            if (totalImages <= 1) {
                hideCarouselControls();
            } else {
                showCarouselControls();
                updateDotsNavigation();
                updateImageCounter();
            }
        }
        
        function hideCarouselControls() {
            const counter = document.querySelector('.image-counter');
            const dots = document.querySelector('.carousel-dots');
            const navButtons = document.querySelectorAll('.carousel-nav');
            
            if (counter) counter.style.display = 'none';
            if (dots) dots.style.display = 'none';
            navButtons.forEach(btn => btn.style.display = 'none');
        }
        
        function showCarouselControls() {
            const counter = document.querySelector('.image-counter');
            const dots = document.querySelector('.carousel-dots');
            const navButtons = document.querySelectorAll('.carousel-nav');
            
            if (counter) counter.style.display = 'block';
            if (dots) dots.style.display = 'flex';
            navButtons.forEach(btn => btn.style.display = 'flex');
        }
        
        function updateDotsNavigation() {
            const dotsContainer = document.querySelector('.carousel-dots');
            if (!dotsContainer) return;
            
            // Clear existing dots
            dotsContainer.innerHTML = '';
            
            // Create new dots based on current image count
            for (let i = 0; i < totalImages; i++) {
                const dot = document.createElement('div');
                dot.className = `carousel-dot ${i === currentImageIndex ? 'active' : ''}`;
                dot.onclick = () => goToImage(i);
                dot.title = `Image ${i + 1}`;
                dotsContainer.appendChild(dot);
            }
        }
        
        function updateImageCounter() {
            const counter = document.getElementById('currentImageIndex');
            const totalCounter = document.querySelector('.image-counter');
            
            if (counter) {
                counter.textContent = currentImageIndex + 1;
            }
            
            if (totalCounter) {
                const totalSpan = totalCounter.textContent.split(' / ')[1];
                totalCounter.innerHTML = `<span id="currentImageIndex">${currentImageIndex + 1}</span> / ${totalImages}`;
            }
        }
        
        function handleTouchStart(e) {
            startX = e.touches[0].clientX;
            isDragging = true;
            const carousel = document.getElementById('imageCarousel');
            if (carousel) {
                carousel.classList.add('dragging');
            }
        }
        
        function handleTouchMove(e) {
            if (!isDragging) return;
            currentX = e.touches[0].clientX;
            
            // Optional: Add visual feedback during drag
            const carousel = document.getElementById('imageCarousel');
            if (carousel && totalImages > 1) {
                const diffX = startX - currentX;
                const dragDistance = Math.min(Math.abs(diffX), 100); // Limit drag distance
                const opacity = 1 - (dragDistance / 200); // Fade effect
                
                // You can add visual feedback here if needed
            }
        }
        
        function handleTouchEnd(e) {
            if (!isDragging) return;
            isDragging = false;
            
            const carousel = document.getElementById('imageCarousel');
            if (carousel) {
                carousel.classList.remove('dragging');
            }
            
            const diffX = startX - currentX;
            const threshold = 50; // Minimum swipe distance
            
            if (Math.abs(diffX) > threshold) {
                if (diffX > 0) {
                    nextImage(); // Swipe left - next image
                } else {
                    previousImage(); // Swipe right - previous image
                }
            }
        }
        
        function handleMouseStart(e) {
            startX = e.clientX;
            isDragging = true;
            e.preventDefault();
        }
        
        function handleMouseMove(e) {
            if (!isDragging) return;
            currentX = e.clientX;
        }
        
        function handleMouseEnd(e) {
            if (!isDragging) return;
            isDragging = false;
            
            const diffX = startX - currentX;
            const threshold = 50;
            
            if (Math.abs(diffX) > threshold) {
                if (diffX > 0) {
                    nextImage();
                } else {
                    previousImage();
                }
            }
        }
        
        function nextImage() {
            if (currentImageIndex < totalImages - 1) {
                currentImageIndex++;
            } else {
                currentImageIndex = 0; // Loop back to first image
            }
            updateCarousel();
        }
        
        function previousImage() {
            if (currentImageIndex > 0) {
                currentImageIndex--;
            } else {
                currentImageIndex = totalImages - 1; // Loop to last image
            }
            updateCarousel();
        }
        
        function goToImage(index) {
            currentImageIndex = index;
            updateCarousel();
        }
        
        function updateCarousel() {
            const carousel = document.getElementById('imageCarousel');
            const counter = document.getElementById('currentImageIndex');
            const dots = document.querySelectorAll('.carousel-dot');
            
            if (!carousel) return;
            
            // Update carousel position
            const translateX = -currentImageIndex * 100;
            carousel.style.transform = `translateX(${translateX}%)`;
            
            // Update counter
            if (counter) {
                counter.textContent = currentImageIndex + 1;
            }
            
            // Update dots
            dots.forEach((dot, index) => {
                if (index === currentImageIndex) {
                    dot.classList.add('active');
                } else {
                    dot.classList.remove('active');
                }
            });
        }
        
        function toggleLike() {
            const likeBtn = document.querySelector('.action-btn.with-count');
            const likeSvg = likeBtn.querySelector('svg');
            const likeCount = document.getElementById('likeCount');
            
            // Send API request to toggle like
            fetch(`/api/v1/berita/<?php echo e($berita->id); ?>/toggle-like`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Update UI with new count
                    likeCount.textContent = data.likes_count;
                    
                    // Toggle visual state
                    isLiked = !isLiked;
                    
                    if (isLiked) {
                        likeBtn.classList.add('liked');
                        likeSvg.setAttribute('fill', 'currentColor');
                        likeSvg.innerHTML = '<path fill="currentColor" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>';
                    } else {
                        likeBtn.classList.remove('liked');
                        likeSvg.setAttribute('fill', 'none');
                        likeSvg.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>';
                    }
                    
                    // Heart animation
                    likeBtn.style.transform = 'scale(1.2)';
                    setTimeout(() => {
                        likeBtn.style.transform = 'scale(1)';
                    }, 200);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                // Fallback to local update if API fails
                let currentCount = parseInt(likeCount.textContent);
                likeCount.textContent = currentCount + 1;
            });
        }
        
        function openComments() {
            const commentsSection = document.querySelector('.comments-section');
            commentsSection.scrollIntoView({ behavior: 'smooth' });
            document.querySelector('.comment-input').focus();
        }
        
        // Comment functionality
        function showUserFields() {
            const userInfoFields = document.getElementById('userInfoFields');
            const commentActions = document.getElementById('commentActions');
            
            userInfoFields.style.display = 'flex';
            commentActions.style.display = 'flex';
            
            // Focus pada field nama
            document.getElementById('commentNama').focus();
        }

        function cancelComment() {
            const userInfoFields = document.getElementById('userInfoFields');
            const commentActions = document.getElementById('commentActions');
            const commentText = document.getElementById('commentText');
            const commentNama = document.getElementById('commentNama');
            const commentHP = document.getElementById('commentHP');
            
            // Hide fields
            userInfoFields.style.display = 'none';
            commentActions.style.display = 'none';
            
            // Clear inputs
            commentText.value = '';
            commentNama.value = '';
            commentHP.value = '';
        }

        function validatePhoneNumber(phone) {
            // Indonesian phone number validation
            const phoneRegex = /^(08|628|\+628)[0-9]{8,11}$/;
            return phoneRegex.test(phone);
        }
        
        // SweetAlert Utility Functions
        function showSuccessToast(title, text = '') {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            });
            
            Toast.fire({
                icon: 'success',
                title: title,
                text: text
            });
        }
        
        function showErrorToast(title, text = '') {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 4000,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.addEventListener('mouseenter', Swal.stopTimer)
                    toast.addEventListener('mouseleave', Swal.resumeTimer)
                }
            });
            
            Toast.fire({
                icon: 'error',
                title: title,
                text: text
            });
        }
        
        function showInfoToast(title, text = '') {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 2500,
                timerProgressBar: true,
            });
            
            Toast.fire({
                icon: 'info',
                title: title,
                text: text
            });
        }

        function submitComment() {
            const commentText = document.getElementById('commentText').value.trim();
            const commentNama = document.getElementById('commentNama').value.trim();
            const commentHP = document.getElementById('commentHP').value.trim();
            
            // Validation
            if (!commentNama) {
                showCustomAlert('warning', 'Nama Diperlukan', 'Mohon isi nama lengkap terlebih dahulu', function() {
                    document.getElementById('commentNama').focus();
                });
                return;
            }
            
            if (!commentHP) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Nomor HP Diperlukan',
                    text: 'Mohon isi nomor HP terlebih dahulu',
                    confirmButtonColor: '#3b82f6',
                    confirmButtonText: 'OK'
                }).then(() => {
                    document.getElementById('commentHP').focus();
                });
                return;
            }
            
            if (!validatePhoneNumber(commentHP)) {
                Swal.fire({
                    icon: 'error',
                    title: 'Format Nomor HP Salah',
                    text: 'Gunakan format: 08xxxxxxxxxx, 628xxxxxxxxxx, atau +628xxxxxxxxxx',
                    confirmButtonColor: '#3b82f6',
                    confirmButtonText: 'OK'
                }).then(() => {
                    document.getElementById('commentHP').focus();
                });
                return;
            }
            
            if (!commentText) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Komentar Kosong',
                    text: 'Mohon tulis komentar terlebih dahulu',
                    confirmButtonColor: '#3b82f6',
                    confirmButtonText: 'OK'
                }).then(() => {
                    document.getElementById('commentText').focus();
                });
                return;
            }
            
            // Show confirmation dialog
            Swal.fire({
                title: 'Kirim Komentar?',
                text: `Komentar akan dikirim atas nama "${commentNama}"`,
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3b82f6',
                cancelButtonColor: '#6b7280',
                confirmButtonText: 'Ya, Kirim!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    sendComment();
                }
            });
        }
        
        function sendComment() {
            const commentText = document.getElementById('commentText').value.trim();
            const commentNama = document.getElementById('commentNama').value.trim();
            const commentHP = document.getElementById('commentHP').value.trim();
            
            // Show loading alert
            Swal.fire({
                title: 'Mengirim Komentar...',
                text: 'Mohon tunggu sebentar',
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });
            
            // Disable submit button
            const submitBtn = document.querySelector('.comment-submit-btn');
            submitBtn.disabled = true;
            submitBtn.textContent = 'Mengirim...';
            
            // Send comment to backend
            fetch(`/api/v1/berita/<?php echo e($berita->id); ?>/comment`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({
                    komentar: commentText,
                    nama: commentNama,
                    phone: commentHP
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Update comment count
                    const commentCount = document.getElementById('commentCount');
                    commentCount.textContent = data.comments_count;
                    
                    // Reset form
                    cancelComment();
                    
                    // Show success message
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil! 🎉',
                        text: 'Komentar Anda berhasil dikirim dan sedang menunggu persetujuan admin',
                        confirmButtonColor: '#10b981',
                        confirmButtonText: 'OK',
                        timer: 3000,
                        timerProgressBar: true
                    }).then(() => {
                        // Optionally reload comments section
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Gagal Mengirim',
                        text: data.message || 'Gagal mengirim komentar. Silakan coba lagi.',
                        confirmButtonColor: '#ef4444',
                        confirmButtonText: 'Coba Lagi'
                    });
                }
            })
            .catch(error => {
                console.error('Error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Terjadi Kesalahan',
                    text: 'Koneksi bermasalah. Silakan periksa internet Anda dan coba lagi.',
                    confirmButtonColor: '#ef4444',
                    confirmButtonText: 'OK'
                });
            })
            .finally(() => {
                // Close loading alert
                Swal.close();
                
                // Re-enable submit button
                submitBtn.disabled = false;
                submitBtn.textContent = 'Kirim';
            });
        }
        
        function toggleCommentLike(button) {
            const likeCount = button.querySelector('span');
            const currentCount = parseInt(likeCount.textContent);
            
            if (button.classList.contains('liked')) {
                button.classList.remove('liked');
                likeCount.textContent = currentCount - 1;
                button.querySelector('svg').setAttribute('fill', 'none');
            } else {
                button.classList.add('liked');
                likeCount.textContent = currentCount + 1;
                button.querySelector('svg').setAttribute('fill', 'currentColor');
            }
        }
        
        function replyToComment(username) {
            const commentInput = document.querySelector('.comment-input');
            commentInput.value = `@${username} `;
            commentInput.focus();
        }
        
        // Toggle all comments visibility
        function toggleAllComments() {
            const hiddenComments = document.querySelector('.hidden-comments');
            const loadMoreBtn = document.querySelector('.load-more-btn');
            const loadMoreText = document.querySelector('.load-more-text');
            const loadMoreIcon = document.querySelector('.load-more-icon');
            
            if (hiddenComments.classList.contains('show')) {
                // Hide comments
                hiddenComments.classList.remove('show');
                loadMoreBtn.classList.remove('expanded');
                loadMoreText.textContent = 'Lihat semua 6 komentar';
                
                // Scroll to first comment smoothly
                setTimeout(() => {
                    document.querySelector('.visible-comment').scrollIntoView({ 
                        behavior: 'smooth', 
                        block: 'nearest' 
                    });
                }, 100);
            } else {
                // Show comments
                hiddenComments.style.display = 'block';
                setTimeout(() => {
                    hiddenComments.classList.add('show');
                }, 10);
                loadMoreBtn.classList.add('expanded');
                loadMoreText.textContent = 'Sembunyikan komentar';
            }
        }
        
        function sharePost() {
            // Send API request to increment share count
            fetch(`/api/v1/berita/<?php echo e($berita->id); ?>/increment-share`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Update share counter
                    const shareCount = document.getElementById('shareCount');
                    shareCount.textContent = data.shares_count;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                // Fallback to local update if API fails
                const shareCount = document.getElementById('shareCount');
                let currentCount = parseInt(shareCount.textContent);
                shareCount.textContent = currentCount + 1;
            });
            
            if (navigator.share) {
                navigator.share({
                    title: '<?php echo e($berita->judul ?? "Detail Berita"); ?>',
                    text: 'Baca berita terbaru dari desa',
                    url: window.location.href
                });
            } else {
                // Fallback
                navigator.clipboard.writeText(window.location.href);
                showSuccessToast('Link Disalin! 📋', 'Link berita telah disalin ke clipboard');
            }
        }
        
        function savePost() {
            const saveBtn = document.querySelector('.action-btn:last-child');
            const saveSvg = saveBtn.querySelector('svg');
            
            isSaved = !isSaved;
            
            if (isSaved) {
                saveSvg.setAttribute('fill', 'currentColor');
                saveSvg.innerHTML = '<path fill="currentColor" d="M5 5a2 2 0 012-2h10a2 2 0 012 2v16l-7-3.5L5 21V5z"/>';
                showSuccessToast('Tersimpan! 🔖', 'Berita telah disimpan ke bookmark');
            } else {
                saveSvg.setAttribute('fill', 'none');
                saveSvg.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 5a2 2 0 012-2h10a2 2 0 012 2v16l-7-3.5L5 21V5z"/>';
                showInfoToast('Bookmark Dihapus', 'Berita telah dihapus dari bookmark');
            }
        }
        
        // Reading Progress Bar
        function updateReadingProgress() {
            const article = document.querySelector('.content-body');
            if (!article) return;
            
            const articleTop = article.offsetTop;
            const articleHeight = article.offsetHeight;
            const windowHeight = window.innerHeight;
            const scrollTop = window.pageYOffset || document.documentElement.scrollTop;
            
            const progress = Math.min(100, Math.max(0, 
                ((scrollTop - articleTop + windowHeight) / articleHeight) * 100
            ));
            
            document.getElementById('readingProgress').style.width = progress + '%';
        }

        // Share Functions
        function shareArticle() {
            if (navigator.share) {
                navigator.share({
                    title: '<?php echo e($berita->judul ?? "Detail Berita"); ?>',
                    text: '<?php echo e(Str::limit(strip_tags($berita->konten ?? ""), 100)); ?>',
                    url: window.location.href
                });
            } else {
                copyLink();
            }
        }

        function shareToWhatsApp() {
            const title = '<?php echo e($berita->judul ?? "Detail Berita"); ?>';
            const description = '<?php echo e(Str::limit(strip_tags($berita->konten ?? ""), 100)); ?>';
            const url = window.location.href;
            const text = encodeURIComponent(`*${title}*\n\n${description}\n\nBaca selengkapnya: ${url}`);
            
            window.open(`https://wa.me/?text=${text}`, '_blank');
            showShareSuccess('Membuka WhatsApp... 💬');
        }

        function shareToFacebook() {
            const url = encodeURIComponent(window.location.href);
            const title = encodeURIComponent('<?php echo e($berita->judul ?? "Detail Berita"); ?>');
            const description = encodeURIComponent('<?php echo e(Str::limit(strip_tags($berita->konten ?? ""), 160)); ?>');
            
            // Facebook will automatically fetch Open Graph data from the URL
            window.open(`https://www.facebook.com/sharer/sharer.php?u=${url}`, '_blank');
            showShareSuccess('Membuka Facebook... 👥');
        }

        function shareToTwitter() {
            const title = '<?php echo e($berita->judul ?? "Detail Berita"); ?>';
            const url = window.location.href;
            const hashtags = '<?php echo e(strtolower(str_replace(" ", "", $berita->kategori ?? "berita"))); ?>,desaku,beritadesa';
            
            const text = encodeURIComponent(`${title}\n\n#${hashtags.split(',')[0]} #desaku #beritadesa`);
            const encodedUrl = encodeURIComponent(url);
            
            // Twitter will automatically show image from Twitter Card meta tags
            window.open(`https://twitter.com/intent/tweet?text=${text}&url=${encodedUrl}`, '_blank');
            showShareSuccess('Membuka Twitter... 🐦');
        }

        function copyLink() {
            navigator.clipboard.writeText(window.location.href).then(() => {
                // Show success message with animation
                showShareSuccess('Link berhasil disalin! 📋');
            }).catch(() => {
                // Fallback for older browsers
                const textArea = document.createElement('textarea');
                textArea.value = window.location.href;
                document.body.appendChild(textArea);
                textArea.select();
                document.execCommand('copy');
                document.body.removeChild(textArea);
                showShareSuccess('Link berhasil disalin! 📋');
            });
        }
        
        function shareToTelegram() {
            const title = '<?php echo e($berita->judul ?? "Detail Berita"); ?>';
            const description = '<?php echo e(Str::limit(strip_tags($berita->konten ?? ""), 120)); ?>';
            const url = window.location.href;
            
            const text = encodeURIComponent(`📰 *${title}*\n\n${description}\n\n🔗 Baca selengkapnya:`);
            const encodedUrl = encodeURIComponent(url);
            
            // Telegram will show preview with image from Open Graph tags
            window.open(`https://t.me/share/url?url=${encodedUrl}&text=${text}`, '_blank');
            showShareSuccess('Membuka Telegram... ✈️');
        }
        
        function shareToEmail() {
            const title = '<?php echo e($berita->judul ?? "Detail Berita"); ?>';
            const description = '<?php echo e(Str::limit(strip_tags($berita->konten ?? ""), 200)); ?>';
            const url = window.location.href;
            const siteName = 'Sistem Informasi Desa';
            const author = '<?php echo e($berita->penulis ?? "Admin Desa"); ?>';
            const date = '<?php echo e(($berita->created_at ?? now())->format("d M Y")); ?>';
            
            const subject = encodeURIComponent(`📰 ${title} - ${siteName}`);
            const body = encodeURIComponent(`Hai,

Saya ingin berbagi artikel menarik dari ${siteName}:

📰 ${title}
✍️ Oleh: ${author}
📅 Tanggal: ${date}

📝 Ringkasan:
${description}

🔗 Baca artikel lengkap di:
${url}

---
Dikirim melalui ${siteName}
${window.location.origin}`);
            
            window.location.href = `mailto:?subject=${subject}&body=${body}`;
            showShareSuccess('Membuka aplikasi email... 📧');
        }
        
        function showSharePreview(platform) {
            const title = '<?php echo e($berita->judul ?? "Detail Berita"); ?>';
            const description = '<?php echo e(Str::limit(strip_tags($berita->konten ?? ""), 100)); ?>';
            const image = '<?php echo e($shareImage ?? ""); ?>';
            const url = window.location.href;
            
            // Create preview modal
            const modal = document.createElement('div');
            modal.className = 'share-preview-modal';
            modal.innerHTML = `
                <div class="share-preview-overlay" onclick="closeSharePreview()"></div>
                <div class="share-preview-content">
                    <div class="share-preview-header">
                        <h3>Preview Link - ${platform}</h3>
                        <button onclick="closeSharePreview()" class="close-btn">×</button>
                    </div>
                    <div class="share-preview-card">
                        ${image ? `<img src="${image}" alt="${title}" class="preview-image">` : ''}
                        <div class="preview-content">
                            <h4 class="preview-title">${title}</h4>
                            <p class="preview-description">${description}</p>
                            <span class="preview-url">${url}</span>
                        </div>
                    </div>
                    <div class="share-preview-actions">
                        <button onclick="closeSharePreview()" class="btn-cancel">Batal</button>
                        <button onclick="confirmShare('${platform}')" class="btn-share">Bagikan</button>
                    </div>
                </div>
            `;
            
            // Add styles
            modal.style.cssText = `
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                z-index: 10000;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            `;
            
            document.body.appendChild(modal);
            
            // Add CSS for modal components
            const style = document.createElement('style');
            style.textContent = `
                .share-preview-overlay {
                    position: absolute;
                    top: 0;
                    left: 0;
                    width: 100%;
                    height: 100%;
                    background: rgba(0,0,0,0.5);
                    backdrop-filter: blur(4px);
                }
                
                .share-preview-content {
                    background: white;
                    border-radius: 16px;
                    max-width: 400px;
                    width: 100%;
                    max-height: 80vh;
                    overflow: hidden;
                    position: relative;
                    box-shadow: 0 20px 40px rgba(0,0,0,0.2);
                    animation: modalSlideIn 0.3s ease;
                }
                
                @keyframes modalSlideIn {
                    from { opacity: 0; transform: scale(0.9) translateY(20px); }
                    to { opacity: 1; transform: scale(1) translateY(0); }
                }
                
                .share-preview-header {
                    padding: 20px;
                    border-bottom: 1px solid #e5e7eb;
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                }
                
                .share-preview-header h3 {
                    margin: 0;
                    font-size: 18px;
                    font-weight: 600;
                    color: #1f2937;
                }
                
                .close-btn {
                    background: none;
                    border: none;
                    font-size: 24px;
                    cursor: pointer;
                    color: #6b7280;
                    width: 32px;
                    height: 32px;
                    border-radius: 50%;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                }
                
                .close-btn:hover {
                    background: #f3f4f6;
                }
                
                .share-preview-card {
                    margin: 20px;
                    border: 1px solid #e5e7eb;
                    border-radius: 12px;
                    overflow: hidden;
                }
                
                .preview-image {
                    width: 100%;
                    height: 200px;
                    object-fit: cover;
                }
                
                .preview-content {
                    padding: 16px;
                }
                
                .preview-title {
                    margin: 0 0 8px 0;
                    font-size: 16px;
                    font-weight: 600;
                    color: #1f2937;
                    line-height: 1.4;
                }
                
                .preview-description {
                    margin: 0 0 12px 0;
                    font-size: 14px;
                    color: #6b7280;
                    line-height: 1.5;
                }
                
                .preview-url {
                    font-size: 12px;
                    color: #9ca3af;
                    word-break: break-all;
                }
                
                .share-preview-actions {
                    padding: 20px;
                    display: flex;
                    gap: 12px;
                    justify-content: flex-end;
                }
                
                .btn-cancel, .btn-share {
                    padding: 10px 20px;
                    border-radius: 8px;
                    font-weight: 500;
                    cursor: pointer;
                    transition: all 0.2s ease;
                }
                
                .btn-cancel {
                    background: #f3f4f6;
                    border: 1px solid #d1d5db;
                    color: #374151;
                }
                
                .btn-cancel:hover {
                    background: #e5e7eb;
                }
                
                .btn-share {
                    background: #3b82f6;
                    border: 1px solid #3b82f6;
                    color: white;
                }
                
                .btn-share:hover {
                    background: #2563eb;
                }
            `;
            document.head.appendChild(style);
        }
        
        function closeSharePreview() {
            const modal = document.querySelector('.share-preview-modal');
            if (modal) {
                modal.remove();
            }
        }
        
        function confirmShare(platform) {
            closeSharePreview();
            
            // Execute the actual share function
            switch(platform) {
                case 'WhatsApp':
                    shareToWhatsApp();
                    break;
                case 'Facebook':
                    shareToFacebook();
                    break;
                case 'Twitter':
                    shareToTwitter();
                    break;
                case 'Telegram':
                    shareToTelegram();
                    break;
                case 'Copy Link':
                    copyLink();
                    break;
            }
        }
        
        function showShareSuccess(message) {
            // Create success notification
            const notification = document.createElement('div');
            notification.className = 'share-success-notification';
            notification.innerHTML = `
                <div class="success-content">
                    <svg class="w-5 h-5 text-green-500" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                    </svg>
                    <span>${message}</span>
                </div>
            `;
            
            // Add styles
            notification.style.cssText = `
                position: fixed;
                top: 20px;
                right: 20px;
                background: white;
                border: 2px solid #10b981;
                border-radius: 12px;
                padding: 16px 20px;
                box-shadow: 0 10px 25px rgba(0,0,0,0.1);
                z-index: 1000;
                transform: translateX(100%);
                transition: transform 0.3s ease;
            `;
            
            notification.querySelector('.success-content').style.cssText = `
                display: flex;
                align-items: center;
                gap: 8px;
                font-weight: 500;
                color: #065f46;
            `;
            
            document.body.appendChild(notification);
            
            // Animate in
            setTimeout(() => {
                notification.style.transform = 'translateX(0)';
            }, 100);
            
            // Animate out and remove
            setTimeout(() => {
                notification.style.transform = 'translateX(100%)';
                setTimeout(() => {
                    document.body.removeChild(notification);
                }, 300);
            }, 3000);
        }

        // Bookmark Function
        function toggleBookmark() {
            const bookmarkBtn = event.target.closest('button');
            const svg = bookmarkBtn.querySelector('svg');
            
            if (svg.getAttribute('fill') === 'none') {
                svg.setAttribute('fill', 'currentColor');
                svg.classList.add('text-yellow-500');
                showSuccessToast('Bookmark Ditambahkan! 🔖', 'Artikel ditambahkan ke bookmark');
            } else {
                svg.setAttribute('fill', 'none');
                svg.classList.remove('text-yellow-500');
                showInfoToast('Bookmark Dihapus', 'Artikel dihapus dari bookmark');
            }
        }

        // Navigation Functions
        function openArticle(slug) {
            window.location.href = `/berita/${slug}`;
        }

        function navigateToService(serviceType) {
            switch(serviceType) {
                case '/':
                    window.location.href = '/';
                    break;
                case 'berita':
                    window.location.href = '/berita';
                    break;
                case 'wisata':
                    window.location.href = '/wisata';
                    break;
                case 'umkm':
                    window.location.href = '/produk-umkm';
                    break;
                case 'layanan-mandiri':
                    window.location.href = '/layanan-mandiri';
                    break;
                default:
                    window.location.href = '/';
            }
        }

        // Event Listeners
        window.addEventListener('scroll', updateReadingProgress);
        
        // Service Worker Registration with better error handling
        if ('serviceWorker' in navigator) {
            window.addEventListener('load', () => {
                navigator.serviceWorker.register('/sw.js', {
                    scope: '/'
                })
                .then(registration => {
                    console.log('SW registered successfully:', registration.scope);
                    
                    // Handle updates
                    registration.addEventListener('updatefound', () => {
                        const newWorker = registration.installing;
                        if (newWorker) {
                            newWorker.addEventListener('statechange', () => {
                                if (newWorker.state === 'installed') {
                                    if (navigator.serviceWorker.controller) {
                                        // New service worker available
                                        console.log('New service worker available');
                                    } else {
                                        console.log('Service worker installed for the first time');
                                    }
                                }
                            });
                        }
                    });
                })
                .catch(error => {
                    console.warn('SW registration failed:', error);
                    // Don't block the page if SW fails
                });
            });
        } else {
            console.log('Service Worker not supported');
        }
        
        // Image synchronization and loading functions
        function syncImageDimensions() {
            const images = document.querySelectorAll('.post-image');
            const container = document.querySelector('.post-image-container');
            
            if (!images.length || !container) return;
            
            // Get responsive height limits based on screen size
            const getHeightLimits = () => {
                const screenWidth = window.innerWidth;
                if (screenWidth <= 480) {
                    return { min: 200, max: 350 };
                } else if (screenWidth <= 768) {
                    return { min: 250, max: 400 };
                } else {
                    return { min: 300, max: 500 };
                }
            };
            
            const { min: minHeight, max: maxHeight } = getHeightLimits();
            let optimalHeight = minHeight;
            let loadedCount = 0;
            
            images.forEach((img, index) => {
                // Add loading class
                img.classList.add('loading');
                
                if (img.complete && img.naturalHeight !== 0) {
                    // Image already loaded
                    img.classList.remove('loading');
                    const aspectRatio = img.naturalWidth / img.naturalHeight;
                    const containerWidth = container.offsetWidth;
                    let calculatedHeight = containerWidth / aspectRatio;
                    
                    // Ensure height is within responsive bounds
                    calculatedHeight = Math.max(minHeight, Math.min(maxHeight, calculatedHeight));
                    optimalHeight = Math.max(optimalHeight, calculatedHeight);
                    
                    loadedCount++;
                    if (loadedCount === images.length) {
                        updateContainerHeight(optimalHeight);
                    }
                } else {
                    // Wait for image to load
                    img.onload = function() {
                        this.classList.remove('loading');
                        const aspectRatio = this.naturalWidth / this.naturalHeight;
                        const containerWidth = container.offsetWidth;
                        let calculatedHeight = containerWidth / aspectRatio;
                        
                        // Ensure height is within responsive bounds
                        calculatedHeight = Math.max(minHeight, Math.min(maxHeight, calculatedHeight));
                        optimalHeight = Math.max(optimalHeight, calculatedHeight);
                        
                        loadedCount++;
                        if (loadedCount === images.length) {
                            updateContainerHeight(optimalHeight);
                        }
                    };
                    
                    img.onerror = function() {
                        this.classList.remove('loading');
                        console.warn('Failed to load image:', this.src);
                        handleImageError(this);
                        loadedCount++;
                        if (loadedCount === images.length) {
                            updateContainerHeight(optimalHeight);
                        }
                    };
                }
            });
        }
        
        function updateContainerHeight(height) {
            const container = document.querySelector('.post-image-container');
            const carousel = document.querySelector('.post-image-carousel');
            const images = document.querySelectorAll('.post-image');
            
            if (container && carousel) {
                // Smooth transition for height changes
                container.style.transition = 'height 0.3s ease';
                carousel.style.transition = 'height 0.3s ease';
                
                container.style.height = height + 'px';
                carousel.style.height = height + 'px';
                
                images.forEach(img => {
                    img.style.height = height + 'px';
                    img.style.maxHeight = height + 'px';
                    img.style.transition = 'height 0.3s ease';
                });
                
                // Remove transition after animation completes
                setTimeout(() => {
                    container.style.transition = '';
                    carousel.style.transition = '';
                    images.forEach(img => {
                        img.style.transition = 'opacity 0.3s ease, transform 0.2s ease';
                    });
                }, 300);
            }
        }
        
        function handleImageError(img) {
            console.error('Image error for:', img.src);
            
            // Try to fix malformed URLs first
            const originalSrc = img.src;
            if (originalSrc.includes('/storage/http://') || originalSrc.includes('/storage/https://')) {
                const fixedSrc = originalSrc.replace('/storage/http://', 'http://').replace('/storage/https://', 'https://');
                console.log('Attempting to fix malformed URL from:', originalSrc, 'to:', fixedSrc);
                img.src = fixedSrc;
                return;
            }
            
            // If can't fix, hide the image
            img.style.display = 'none';
            const placeholder = img.nextElementSibling;
            if (placeholder && placeholder.classList.contains('post-image-placeholder')) {
                placeholder.style.display = 'flex';
            }
        }
        
        function retryImageLoad(img) {
            const originalSrc = img.src;
            img.src = '';
            setTimeout(() => {
                img.src = originalSrc;
            }, 1000);
        }
        
        // Responsive image handling
        function handleResponsiveImages() {
            const images = document.querySelectorAll('.post-image');
            
            images.forEach((img, index) => {
                // Add loading state
                img.style.opacity = '0';
                img.style.transition = 'opacity 0.3s ease';
                
                // Preload first image immediately, others with delay
                const delay = index === 0 ? 0 : index * 100;
                
                setTimeout(() => {
                    if (img.complete && img.naturalHeight !== 0) {
                        img.style.opacity = '1';
                    } else {
                        img.onload = function() {
                            this.style.opacity = '1';
                            this.classList.remove('loading');
                        };
                        
                        img.onerror = function() {
                            console.error('Image loading failed:', this.src);
                            handleImageError(this);
                        };
                        
                        // Force reload if image fails to load initially
                        if (!img.src) {
                            img.src = img.getAttribute('data-src') || img.src;
                        }
                    }
                }, delay);
            });
        }
        
        // Preload next images for smoother carousel experience
        function preloadImages() {
            const images = document.querySelectorAll('.post-image');
            
            images.forEach((img, index) => {
                if (index > 0) {
                    const preloadImg = new Image();
                    preloadImg.src = img.src;
                }
            });
        }

        // Initialize page
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Detail Berita PWA loaded');
            updateReadingProgress();
            initializeCarousel();
            
            // Initialize images with proper sequencing
            setTimeout(() => {
                handleResponsiveImages();
                preloadImages();
            }, 100);
            
            setTimeout(() => {
                syncImageDimensions();
            }, 200);
            
            // Handle window resize with debouncing
            let resizeTimeout;
            window.addEventListener('resize', () => {
                clearTimeout(resizeTimeout);
                resizeTimeout = setTimeout(() => {
                    syncImageDimensions();
                }, 150);
            });
            
            // Update view count
            <?php if(isset($berita) && $berita->id): ?>
            fetch('/api/berita/<?php echo e($berita->id); ?>/view', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Content-Type': 'application/json',
                },
            });
            <?php endif; ?>
        });

        // Custom Alert Modal Function
        function showCustomAlert(type, title, message, callback, showCancel = false) {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            
            let iconClass, iconColor, buttonColor;
            switch(type) {
                case 'warning':
                    iconClass = 'fas fa-exclamation-triangle';
                    iconColor = 'yellow';
                    buttonColor = 'yellow';
                    break;
                case 'error':
                    iconClass = 'fas fa-times-circle';
                    iconColor = 'red';
                    buttonColor = 'red';
                    break;
                case 'success':
                    iconClass = 'fas fa-check-circle';
                    iconColor = 'green';
                    buttonColor = 'green';
                    break;
                case 'question':
                    iconClass = 'fas fa-question-circle';
                    iconColor = 'blue';
                    buttonColor = 'blue';
                    break;
                case 'info':
                default:
                    iconClass = 'fas fa-info-circle';
                    iconColor = 'blue';
                    buttonColor = 'blue';
                    break;
            }
            
            const buttonsHtml = showCancel ? `
                <div class="flex space-x-3">
                    <button onclick="closeCustomAlert(false)" class="flex-1 bg-gray-500 text-white py-3 rounded-xl font-semibold hover:bg-gray-600 transition-all">
                        Batal
                    </button>
                    <button onclick="closeCustomAlert(true)" class="flex-1 bg-${buttonColor}-600 text-white py-3 rounded-xl font-semibold hover:bg-${buttonColor}-700 transition-all">
                        Ya
                    </button>
                </div>
            ` : `
                <button onclick="closeCustomAlert(true)" class="w-full bg-${buttonColor}-600 text-white py-3 rounded-xl font-semibold hover:bg-${buttonColor}-700 transition-all">
                    OK
                </button>
            `;
            
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-${iconColor}-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="${iconClass} text-${iconColor}-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">${title}</h3>
                        <p class="text-gray-600 text-sm">${message}</p>
                    </div>
                    
                    ${buttonsHtml}
                </div>
            `;
            
            modal.id = 'customAlertModal';
            document.body.appendChild(modal);
            
            // Store callback for when modal is closed
            window.customAlertCallback = callback;
        }

        // Close Custom Alert Modal
        function closeCustomAlert(confirmed) {
            const modal = document.getElementById('customAlertModal');
            if (modal) {
                modal.remove();
            }
            
            // Execute callback if provided
            if (window.customAlertCallback) {
                if (typeof window.customAlertCallback === 'function') {
                    window.customAlertCallback(confirmed);
                } else if (confirmed && window.customAlertCallback.then) {
                    window.customAlertCallback.then();
                }
                window.customAlertCallback = null;
            }
        }
    </script>
</body>
</html> <?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/frontend/detail-berita.blade.php ENDPATH**/ ?>