

<?php $__env->startSection('title', 'Dashboard Marketplace'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Dashboard Marketplace</h1>
        <div class="d-flex">
            <button class="btn btn-info btn-sm mr-2" onclick="exportReport()">
                <i class="fas fa-download"></i> Export Laporan
            </button>
            <a href="<?php echo e(route('admin.marketplace.settings')); ?>" class="btn btn-primary btn-sm">
                <i class="fas fa-cog"></i> Pengaturan
            </a>
        </div>
    </div>

    <!-- Overview Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total UMKM</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['total_umkm'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-store fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Produk</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['total_produk'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-box fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Pesanan Bulan Ini</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['orders_this_month'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-shopping-cart fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Revenue Bulan Ini</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">Rp <?php echo e(number_format($stats['revenue_this_month'] ?? 0)); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-dollar-sign fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row mb-4">
        <!-- Revenue Chart -->
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">Revenue Bulanan</h6>
                </div>
                <div class="card-body">
                    <div class="chart-area">
                        <canvas id="revenueChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Category Distribution -->
        <div class="col-xl-4 col-lg-5">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Distribusi Kategori</h6>
                </div>
                <div class="card-body">
                    <div class="chart-pie pt-4 pb-2">
                        <canvas id="categoryChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activities -->
    <div class="row">
        <!-- Top Products -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Produk Terlaris</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Produk</th>
                                    <th>UMKM</th>
                                    <th>Terjual</th>
                                    <th>Revenue</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $topProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div class="font-weight-bold"><?php echo e($product->nama); ?></div>
                                        <small class="text-muted"><?php echo e($product->kategori); ?></small>
                                    </td>
                                    <td><?php echo e($product->umkm->nama_umkm); ?></td>
                                    <td><span class="badge badge-success"><?php echo e($product->total_sold ?? 0); ?></span></td>
                                    <td class="font-weight-bold">Rp <?php echo e(number_format($product->total_revenue ?? 0)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center text-muted">Belum ada data penjualan</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Orders -->
        <div class="col-lg-6 mb-4">
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Pesanan Terbaru</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Kode</th>
                                    <th>Pelanggan</th>
                                    <th>Total</th>
                                    <th>Status</th>
                                    <th>Waktu</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $recentOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><span class="font-weight-bold"><?php echo e($order->kode_transaksi); ?></span></td>
                                    <td><?php echo e($order->nama_pelanggan); ?></td>
                                    <td class="font-weight-bold">Rp <?php echo e(number_format($order->total_amount)); ?></td>
                                    <td>
                                        <?php if($order->status === 'paid'): ?>
                                            <span class="badge badge-success">Paid</span>
                                        <?php elseif($order->status === 'pending'): ?>
                                            <span class="badge badge-warning">Pending</span>
                                        <?php else: ?>
                                            <span class="badge badge-secondary"><?php echo e(ucfirst($order->status)); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><small><?php echo e($order->created_at->diffForHumans()); ?></small></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-muted">Belum ada pesanan</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- UMKM Performance -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Performa UMKM</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Nama UMKM</th>
                                    <th>Pemilik</th>
                                    <th>Kategori</th>
                                    <th>Total Produk</th>
                                    <th>Produk Aktif</th>
                                    <th>Total Penjualan</th>
                                    <th>Revenue</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $umkmPerformance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $umkm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td>
                                        <div class="font-weight-bold"><?php echo e($umkm->nama_umkm); ?></div>
                                        <small class="text-muted"><?php echo e($umkm->alamat); ?></small>
                                    </td>
                                    <td><?php echo e($umkm->pemilik); ?></td>
                                    <td><span class="badge badge-info"><?php echo e($umkm->kategori_usaha); ?></span></td>
                                    <td><?php echo e($umkm->total_products ?? 0); ?></td>
                                    <td><?php echo e($umkm->active_products ?? 0); ?></td>
                                    <td><span class="badge badge-success"><?php echo e($umkm->total_sales ?? 0); ?></span></td>
                                    <td class="font-weight-bold">Rp <?php echo e(number_format($umkm->total_revenue ?? 0)); ?></td>
                                    <td>
                                        <?php if($umkm->status === 'aktif'): ?>
                                            <span class="badge badge-success">Aktif</span>
                                        <?php else: ?>
                                            <span class="badge badge-warning"><?php echo e(ucfirst($umkm->status)); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.umkm.show', $umkm->id)); ?>" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.produk-umkm.index')); ?>?umkm_id=<?php echo e($umkm->id); ?>" class="btn btn-warning btn-sm">
                                                <i class="fas fa-box"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.transaksi.index')); ?>?umkm_id=<?php echo e($umkm->id); ?>" class="btn btn-success btn-sm">
                                                <i class="fas fa-chart-line"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="10" class="text-center py-4">
                                        <i class="fas fa-store fa-3x text-muted mb-3"></i>
                                        <h5 class="text-muted">Belum ada data UMKM</h5>
                                        <p class="text-muted">Data akan muncul setelah ada UMKM yang terdaftar</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Revenue Chart
const revenueCtx = document.getElementById('revenueChart').getContext('2d');
const revenueChart = new Chart(revenueCtx, {
    type: 'line',
    data: {
        labels: <?php echo json_encode($revenueChart['labels'] ?? [], 15, 512) ?>,
        datasets: [{
            label: 'Revenue',
            data: <?php echo json_encode($revenueChart['data'] ?? [], 15, 512) ?>,
            borderColor: 'rgb(78, 115, 223)',
            backgroundColor: 'rgba(78, 115, 223, 0.1)',
            borderWidth: 2,
            fill: true,
            tension: 0.3
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return 'Rp ' + value.toLocaleString();
                    }
                }
            }
        },
        plugins: {
            legend: {
                display: false
            }
        }
    }
});

// Category Chart
const categoryCtx = document.getElementById('categoryChart').getContext('2d');
const categoryChart = new Chart(categoryCtx, {
    type: 'doughnut',
    data: {
        labels: <?php echo json_encode($categoryChart['labels'] ?? [], 15, 512) ?>,
        datasets: [{
            data: <?php echo json_encode($categoryChart['data'] ?? [], 15, 512) ?>,
            backgroundColor: [
                '#4e73df',
                '#1cc88a',
                '#36b9cc',
                '#f6c23e',
                '#e74a3b',
                '#858796'
            ]
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                position: 'bottom'
            }
        }
    }
});

function exportReport() {
    const startDate = prompt('Tanggal mulai (YYYY-MM-DD):');
    const endDate = prompt('Tanggal selesai (YYYY-MM-DD):');
    
    if (startDate && endDate) {
        window.location.href = `<?php echo e(route('admin.marketplace.export')); ?>?start_date=${startDate}&end_date=${endDate}`;
    }
}

// Auto refresh every 5 minutes
setInterval(function() {
    location.reload();
}, 300000);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/marketplace/index.blade.php ENDPATH**/ ?>