

<?php $__env->startSection('title', 'Komentar Berita - ' . $berita->judul); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.berita.index')); ?>">Berita</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.berita.show', $berita->id)); ?>"><?php echo e(Str::limit($berita->judul, 30)); ?></a></li>
    <li class="breadcrumb-item active">Komentar</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-comments me-2 text-info"></i>
            Komentar Berita
        </h2>
        <p class="text-muted mb-0">Kelola komentar untuk: <strong><?php echo e($berita->judul); ?></strong></p>
    </div>
    <div>
        <a href="<?php echo e(route('admin.berita.show', $berita->id)); ?>" class="btn btn-outline-secondary">
            <i class="fas fa-arrow-left me-2"></i>
            Kembali ke Berita
        </a>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-info me-3">
                    <i class="fas fa-comments"></i>
                </div>
                <div>
                    <h4 class="mb-0"><?php echo e(number_format($stats['total'])); ?></h4>
                    <small class="text-muted">Total Komentar</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-success me-3">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div>
                    <h4 class="mb-0"><?php echo e(number_format($stats['approved'])); ?></h4>
                    <small class="text-muted">Disetujui</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-warning me-3">
                    <i class="fas fa-clock"></i>
                </div>
                <div>
                    <h4 class="mb-0"><?php echo e(number_format($stats['pending'])); ?></h4>
                    <small class="text-muted">Menunggu</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-danger me-3">
                    <i class="fas fa-times-circle"></i>
                </div>
                <div>
                    <h4 class="mb-0"><?php echo e(number_format($stats['rejected'])); ?></h4>
                    <small class="text-muted">Ditolak</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Comments List -->
<div class="card">
    <div class="card-header">
        <h5 class="mb-0">
            <i class="fas fa-list me-2"></i>
            Daftar Komentar
        </h5>
    </div>
    <div class="card-body">
        <?php if($comments->count() > 0): ?>
            <div class="row">
                <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12 mb-4">
                    <div class="comment-card border rounded p-3 <?php echo e($comment->status === 'pending' ? 'border-warning bg-warning bg-opacity-10' : ($comment->status === 'approved' ? 'border-success bg-success bg-opacity-10' : 'border-danger bg-danger bg-opacity-10')); ?>">
                        <div class="d-flex justify-content-between align-items-start mb-3">
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle me-3">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div>
                                    <h6 class="mb-1"><?php echo e($comment->nama); ?></h6>
                                    <small class="text-muted">
                                        <i class="fas fa-phone me-1"></i><?php echo e($comment->phone); ?>

                                        <span class="ms-3">
                                            <i class="fas fa-clock me-1"></i><?php echo e($comment->created_at->format('d M Y, H:i')); ?>

                                        </span>
                                    </small>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <span class="badge bg-<?php echo e($comment->status === 'approved' ? 'success' : ($comment->status === 'pending' ? 'warning' : 'danger')); ?> me-2">
                                    <?php echo e(ucfirst($comment->status)); ?>

                                </span>
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                        <i class="fas fa-cog"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <?php if($comment->status !== 'approved'): ?>
                                        <li>
                                            <a class="dropdown-item text-success" href="#" onclick="approveComment(<?php echo e($comment->id); ?>)">
                                                <i class="fas fa-check me-2"></i>Setujui
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php if($comment->status !== 'rejected'): ?>
                                        <li>
                                            <a class="dropdown-item text-warning" href="#" onclick="rejectComment(<?php echo e($comment->id); ?>)">
                                                <i class="fas fa-times me-2"></i>Tolak
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <li><hr class="dropdown-divider"></li>
                                        <li>
                                            <a class="dropdown-item text-danger" href="#" onclick="deleteComment(<?php echo e($comment->id); ?>)">
                                                <i class="fas fa-trash me-2"></i>Hapus
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        
                        <div class="comment-content">
                            <p class="mb-2"><?php echo e($comment->komentar); ?></p>
                        </div>
                        
                        <?php if($comment->likes_count > 0): ?>
                        <div class="comment-stats mt-2">
                            <small class="text-muted">
                                <i class="fas fa-heart text-danger me-1"></i><?php echo e(number_format($comment->likes_count)); ?> suka
                            </small>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <!-- Pagination -->
            <div class="d-flex justify-content-center">
                <?php echo e($comments->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-comments fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Belum ada komentar</h5>
                <p class="text-muted">Komentar akan muncul di sini setelah ada yang berkomentar pada berita ini</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.stats-card {
    background: white;
    border-radius: 12px;
    padding: 20px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    border: 1px solid #eee;
    height: 100%;
}

.stats-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 20px;
}

.comment-card {
    transition: all 0.3s ease;
}

.comment-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
}

.avatar-circle {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #6c757d;
}

.comment-content {
    background: rgba(255,255,255,0.7);
    padding: 15px;
    border-radius: 8px;
    border-left: 3px solid #007bff;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function approveComment(commentId) {
    if (confirm('Yakin ingin menyetujui komentar ini?')) {
        fetch(`/admin/berita/<?php echo e($berita->id); ?>/comments/${commentId}/approve`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Gagal menyetujui komentar: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan saat menyetujui komentar');
        });
    }
}

function rejectComment(commentId) {
    if (confirm('Yakin ingin menolak komentar ini?')) {
        fetch(`/admin/berita/<?php echo e($berita->id); ?>/comments/${commentId}/reject`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Gagal menolak komentar: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan saat menolak komentar');
        });
    }
}

function deleteComment(commentId) {
    if (confirm('Yakin ingin menghapus komentar ini? Tindakan ini tidak dapat dibatalkan.')) {
        fetch(`/admin/berita/<?php echo e($berita->id); ?>/comments/${commentId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Gagal menghapus komentar: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan saat menghapus komentar');
        });
    }
}
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/berita/comments.blade.php ENDPATH**/ ?>