

<?php $__env->startSection('title', 'Edit Data Keluarga'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.keluarga.index')); ?>">Data Keluarga</a></li>
    <li class="breadcrumb-item active">Edit <?php echo e($keluarga->no_kk); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-edit me-2 text-primary"></i>
            Edit Data Keluarga
        </h2>
        <p class="text-muted mb-0">Perbarui informasi keluarga dan kelola anggota</p>
    </div>
    <div>
        <a href="<?php echo e(route('admin.keluarga.index')); ?>" class="btn btn-outline-secondary me-2">
            <i class="fas fa-arrow-left me-2"></i>
            Kembali
        </a>
        <a href="<?php echo e(route('admin.keluarga.show', $keluarga->id)); ?>" class="btn btn-outline-info">
            <i class="fas fa-eye me-2"></i>
            Lihat Detail
        </a>
    </div>
</div>

<form id="editKeluargaForm">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
    <div class="row">
        <!-- Main Form -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-users me-2"></i>
                        Informasi Keluarga
                    </h5>
                </div>
                <div class="card-body">
                    <!-- No KK -->
                    <div class="mb-4">
                        <label class="form-label required">Nomor Kartu Keluarga</label>
                        <input type="text" class="form-control form-control-lg" name="no_kk" 
                               value="<?php echo e($keluarga->no_kk); ?>"
                               placeholder="Masukkan 16 digit nomor KK..." required
                               pattern="[0-9]{16}" maxlength="16"
                               onkeypress="return event.charCode >= 48 && event.charCode <= 57">
                        <div class="form-text">
                            <i class="fas fa-info-circle me-1"></i>
                            Nomor KK harus 16 digit angka
                        </div>
                    </div>
                    
                    <!-- Kepala Keluarga -->
                    <div class="mb-4">
                        <label class="form-label required">Kepala Keluarga</label>
                        <div class="input-group">
                            <select class="form-select" name="kepala_keluarga_id" required id="kepalaKeluargaSelect">
                                <option value="">Pilih Kepala Keluarga</option>
                                <?php $__currentLoopData = $penduduk ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($p->id); ?>" 
                                        <?php echo e($keluarga->kepala_keluarga_id == $p->id ? 'selected' : ''); ?>

                                        data-nik="<?php echo e($p->nik); ?>" data-alamat="<?php echo e($p->alamat); ?>">
                                    <?php echo e($p->nama); ?> - <?php echo e($p->nik); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <button type="button" class="btn btn-outline-primary" onclick="refreshPendudukList()">
                                <i class="fas fa-sync"></i>
                            </button>
                        </div>
                        <div class="form-text">
                            Pilih warga yang akan menjadi kepala keluarga
                        </div>
                    </div>
                    
                    <!-- Alamat Keluarga -->
                    <div class="mb-4">
                        <label class="form-label required">Alamat Keluarga</label>
                        <textarea class="form-control" name="alamat" rows="3" required
                                  placeholder="Masukkan alamat lengkap keluarga..." id="alamatInput"><?php echo e($keluarga->alamat); ?></textarea>
                        <div class="form-text">
                            Alamat dapat diperbarui berdasarkan kepala keluarga yang dipilih
                        </div>
                    </div>
                    
                    <div class="row">
                        <!-- Dusun -->
                        <div class="col-md-3">
                            <div class="mb-4">
                                <label class="form-label required">Dusun</label>
                                <select class="form-select" name="dusun" required id="dusunSelect">
                                    <option value="">Pilih Dusun</option>
                                    <option value="Dusun 1" <?php echo e($keluarga->dusun == 'Dusun 1' ? 'selected' : ''); ?>>Dusun 1</option>
                                    <option value="Dusun 2" <?php echo e($keluarga->dusun == 'Dusun 2' ? 'selected' : ''); ?>>Dusun 2</option>
                                    <option value="Dusun 3" <?php echo e($keluarga->dusun == 'Dusun 3' ? 'selected' : ''); ?>>Dusun 3</option>
                                    <option value="Dusun 4" <?php echo e($keluarga->dusun == 'Dusun 4' ? 'selected' : ''); ?>>Dusun 4</option>
                                </select>
                            </div>
                        </div>
                        
                        <!-- RT -->
                        <div class="col-md-3">
                            <div class="mb-4">
                                <label class="form-label required">RT</label>
                                <input type="text" class="form-control" name="rt" required
                                       value="<?php echo e($keluarga->rt); ?>"
                                       placeholder="001" maxlength="3" id="rtInput">
                            </div>
                        </div>
                        
                        <!-- RW -->
                        <div class="col-md-3">
                            <div class="mb-4">
                                <label class="form-label required">RW</label>
                                <input type="text" class="form-control" name="rw" required
                                       value="<?php echo e($keluarga->rw); ?>"
                                       placeholder="001" maxlength="3" id="rwInput">
                            </div>
                        </div>
                        
                        <!-- Kode Pos -->
                        <div class="col-md-3">
                            <div class="mb-4">
                                <label class="form-label">Kode Pos</label>
                                <input type="text" class="form-control" name="kode_pos"
                                       value="<?php echo e($keluarga->kode_pos); ?>"
                                       placeholder="12345" maxlength="5">
                            </div>
                        </div>
                    </div>
                    
                    <!-- Status Ekonomi -->
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-4">
                                <label class="form-label">Status Ekonomi</label>
                                <select class="form-select" name="status_ekonomi">
                                    <option value="">Pilih Status</option>
                                    <option value="prasejahtera" <?php echo e($keluarga->status_ekonomi == 'prasejahtera' ? 'selected' : ''); ?>>Pra Sejahtera</option>
                                    <option value="sejahtera_1" <?php echo e($keluarga->status_ekonomi == 'sejahtera_1' ? 'selected' : ''); ?>>Sejahtera I</option>
                                    <option value="sejahtera_2" <?php echo e($keluarga->status_ekonomi == 'sejahtera_2' ? 'selected' : ''); ?>>Sejahtera II</option>
                                    <option value="sejahtera_3" <?php echo e($keluarga->status_ekonomi == 'sejahtera_3' ? 'selected' : ''); ?>>Sejahtera III</option>
                                    <option value="sejahtera_3_plus" <?php echo e($keluarga->status_ekonomi == 'sejahtera_3_plus' ? 'selected' : ''); ?>>Sejahtera III+</option>
                                </select>
                            </div>
                        </div>
                        
                        <!-- Jenis Rumah -->
                        <div class="col-md-6">
                            <div class="mb-4">
                                <label class="form-label">Jenis Rumah</label>
                                <select class="form-select" name="jenis_rumah">
                                    <option value="">Pilih Jenis</option>
                                    <option value="permanen" <?php echo e($keluarga->jenis_rumah == 'permanen' ? 'selected' : ''); ?>>Permanen</option>
                                    <option value="semi_permanen" <?php echo e($keluarga->jenis_rumah == 'semi_permanen' ? 'selected' : ''); ?>>Semi Permanen</option>
                                    <option value="darurat" <?php echo e($keluarga->jenis_rumah == 'darurat' ? 'selected' : ''); ?>>Darurat</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Catatan -->
                    <div class="mb-4">
                        <label class="form-label">Catatan</label>
                        <textarea class="form-control" name="catatan" rows="3"
                                  placeholder="Catatan tambahan tentang keluarga ini..."><?php echo e($keluarga->catatan); ?></textarea>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Kepala Keluarga Info -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-user me-2"></i>
                        Info Kepala Keluarga
                    </h6>
                </div>
                <div class="card-body">
                    <div id="kepalaKeluargaInfo">
                        <?php if(optional($keluarga->kepalaKeluarga)->id): ?>
                        <div class="kepala-info-card">
                            <div class="d-flex align-items-center mb-3">
                                <div class="avatar bg-white text-primary me-3">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0"><?php echo e(optional($keluarga->kepalaKeluarga)->nama); ?></h6>
                                    <small class="opacity-75">Kepala Keluarga</small>
                                </div>
                            </div>
                            <div class="small">
                                                            <div class="mb-1"><strong>NIK:</strong> <?php echo e(optional($keluarga->kepalaKeluarga)->nik); ?></div>
                            <div><strong>Alamat:</strong> <?php echo e(optional($keluarga->kepalaKeluarga)->alamat); ?></div>
                            </div>
                        </div>
                        <?php else: ?>
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-user fa-3x mb-3"></i>
                            <p>Pilih kepala keluarga untuk melihat informasi</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- Anggota Keluarga -->
            <div class="card mt-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-users me-2"></i>
                        Anggota Keluarga
                    </h6>
                                                    <span class="badge bg-primary"><?php echo e($keluarga->anggota ? $keluarga->anggota->count() : 0); ?> Orang</span>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Tambah Anggota</label>
                        <div class="input-group">
                            <select class="form-select" id="anggotaSelect">
                                <option value="">Pilih Penduduk</option>
                                <?php $__currentLoopData = $available_members ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($p->id); ?>" data-nama="<?php echo e($p->nama); ?>" data-nik="<?php echo e($p->nik); ?>" data-jk="<?php echo e($p->jk); ?>">
                                    <?php echo e($p->nama); ?> - <?php echo e($p->nik); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <button type="button" class="btn btn-outline-primary" onclick="addAnggota()">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div id="anggotaList">
                        <?php $__currentLoopData = $keluarga->anggota ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $anggota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="anggota-item" data-id="<?php echo e($anggota->id); ?>">
                            <div class="d-flex align-items-center">
                                <div class="avatar bg-<?php echo e($anggota->jk === 'L' ? 'primary' : 'pink'); ?> me-2">
                                    <i class="fas fa-user"></i>
                                </div>
                                <div class="flex-grow-1">
                                    <div class="fw-medium"><?php echo e($anggota->nama); ?></div>
                                    <small class="text-muted"><?php echo e($anggota->nik); ?></small>
                                </div>
                                <div class="ms-2">
                                    <?php if($anggota->pivot->hubungan_keluarga === 'Kepala Keluarga'): ?>
                                    <span class="status-badge bg-success">Kepala</span>
                                    <?php else: ?>
                                    <select class="form-select form-select-sm hubungan-select" 
                                            onchange="updateHubungan('<?php echo e($anggota->id); ?>', this.value)"
                                            style="width: 100px;">
                                        <option value="Istri" <?php echo e($anggota->pivot->hubungan_keluarga === 'Istri' ? 'selected' : ''); ?>>Istri</option>
                                        <option value="Anak" <?php echo e($anggota->pivot->hubungan_keluarga === 'Anak' ? 'selected' : ''); ?>>Anak</option>
                                        <option value="Cucu" <?php echo e($anggota->pivot->hubungan_keluarga === 'Cucu' ? 'selected' : ''); ?>>Cucu</option>
                                        <option value="Mertua" <?php echo e($anggota->pivot->hubungan_keluarga === 'Mertua' ? 'selected' : ''); ?>>Mertua</option>
                                        <option value="Saudara" <?php echo e($anggota->pivot->hubungan_keluarga === 'Saudara' ? 'selected' : ''); ?>>Saudara</option>
                                        <option value="Lainnya" <?php echo e($anggota->pivot->hubungan_keluarga === 'Lainnya' ? 'selected' : ''); ?>>Lainnya</option>
                                    </select>
                                    <?php endif; ?>
                                </div>
                                <?php if($anggota->pivot->hubungan_keluarga !== 'Kepala Keluarga'): ?>
                                <button type="button" class="btn btn-sm btn-outline-danger ms-2" 
                                        onclick="removeAnggota('<?php echo e($anggota->id); ?>')" title="Hapus">
                                    <i class="fas fa-times"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
            
            <!-- Actions -->
            <div class="card mt-4">
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-save me-2"></i>
                            Update Keluarga
                        </button>
                        <button type="button" class="btn btn-outline-warning" onclick="resetChanges()">
                            <i class="fas fa-undo me-2"></i>
                            Batalkan Perubahan
                        </button>
                        <a href="<?php echo e(route('admin.keluarga.show', $keluarga->id)); ?>" class="btn btn-outline-info">
                            <i class="fas fa-eye me-2"></i>
                            Lihat Detail
                        </a>
                    </div>
                    
                    <div class="mt-3 text-center">
                        <small class="text-muted">
                            <i class="fas fa-calendar me-1"></i>
                            Dibuat: <?php echo e($keluarga->created_at->format('d/m/Y H:i')); ?>

                            <?php if($keluarga->updated_at != $keluarga->created_at): ?>
                            <br>Diupdate: <?php echo e($keluarga->updated_at->format('d/m/Y H:i')); ?>

                            <?php endif; ?>
                        </small>
                    </div>
                </div>
            </div>
            
            <!-- Delete Section -->
            <div class="card mt-4 border-danger">
                <div class="card-body">
                    <h6 class="text-danger">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Zona Bahaya
                    </h6>
                    <p class="text-muted mb-3">Hapus data keluarga secara permanen.</p>
                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteKeluarga()">
                        <i class="fas fa-trash me-2"></i>
                        Hapus Keluarga
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .required::after {
        content: ' *';
        color: #dc3545;
    }
    
    .anggota-item {
        border: 1px solid #dee2e6;
        border-radius: 8px;
        padding: 12px;
        margin-bottom: 8px;
        background: #f8f9fa;
        transition: all 0.2s;
    }
    
    .anggota-item:hover {
        border-color: #007bff;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .avatar {
        width: 30px;
        height: 30px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        color: white;
    }
    
    .hubungan-select {
        font-size: 0.875rem;
    }
    
    .kepala-info-card {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        border-radius: 12px;
        padding: 20px;
    }
    
    .status-badge {
        font-size: 0.75rem;
        padding: 4px 8px;
        border-radius: 4px;
    }
    
    .bg-pink {
        background-color: #e83e8c !important;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
const keluargaId = <?php echo e($keluarga->id); ?>;

$(document).ready(function() {
    // Initialize form events
    setupFormEvents();
});

function setupFormEvents() {
    // Kepala keluarga change event
    $('#kepalaKeluargaSelect').on('change', function() {
        const selectedOption = $(this).find('option:selected');
        updateKepalaKeluargaInfo(selectedOption);
        autoFillAlamat(selectedOption);
    });
    
    // No KK validation
    $('input[name="no_kk"]').on('input', function() {
        validateNoKK(this.value);
    });
}

function updateKepalaKeluargaInfo(selectedOption) {
    if (selectedOption.val()) {
        const nama = selectedOption.text().split(' - ')[0];
        const nik = selectedOption.data('nik');
        const alamat = selectedOption.data('alamat');
        
        const infoHtml = `
            <div class="kepala-info-card">
                <div class="d-flex align-items-center mb-3">
                    <div class="avatar bg-white text-primary me-3">
                        <i class="fas fa-user"></i>
                    </div>
                    <div>
                        <h6 class="mb-0">${nama}</h6>
                        <small class="opacity-75">Kepala Keluarga</small>
                    </div>
                </div>
                <div class="small">
                    <div class="mb-1"><strong>NIK:</strong> ${nik}</div>
                    <div><strong>Alamat:</strong> ${alamat || 'Belum diisi'}</div>
                </div>
            </div>
        `;
        
        document.getElementById('kepalaKeluargaInfo').innerHTML = infoHtml;
    }
}

function autoFillAlamat(selectedOption) {
    if (selectedOption.val()) {
        const alamat = selectedOption.data('alamat');
        if (alamat && confirm('Gunakan alamat dari kepala keluarga yang dipilih?')) {
            document.getElementById('alamatInput').value = alamat;
        }
    }
}

function addAnggota() {
    const select = document.getElementById('anggotaSelect');
    const selectedOption = select.options[select.selectedIndex];
    
    if (!selectedOption.value) {
        showToast('Pilih penduduk terlebih dahulu', 'warning');
        return;
    }
    
    showLoading();
    
    fetch(`/admin/keluarga/${keluargaId}/anggota`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            penduduk_id: selectedOption.value,
            hubungan_keluarga: 'Anak'
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Add to list
            const anggota = data.anggota;
            const anggotaHtml = `
                <div class="anggota-item" data-id="${anggota.id}">
                    <div class="d-flex align-items-center">
                        <div class="avatar bg-${anggota.jk === 'L' ? 'primary' : 'pink'} me-2">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="flex-grow-1">
                            <div class="fw-medium">${anggota.nama}</div>
                            <small class="text-muted">${anggota.nik}</small>
                        </div>
                        <div class="ms-2">
                            <select class="form-select form-select-sm hubungan-select" 
                                    onchange="updateHubungan('${anggota.id}', this.value)"
                                    style="width: 100px;">
                                <option value="Istri">Istri</option>
                                <option value="Anak" selected>Anak</option>
                                <option value="Cucu">Cucu</option>
                                <option value="Mertua">Mertua</option>
                                <option value="Saudara">Saudara</option>
                                <option value="Lainnya">Lainnya</option>
                            </select>
                        </div>
                        <button type="button" class="btn btn-sm btn-outline-danger ms-2" 
                                onclick="removeAnggota('${anggota.id}')" title="Hapus">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
            `;
            
            document.getElementById('anggotaList').insertAdjacentHTML('beforeend', anggotaHtml);
            
            // Remove from select
            selectedOption.remove();
            select.selectedIndex = 0;
            
            showToast('Anggota berhasil ditambahkan', 'success');
        } else {
            showToast(data.message || 'Gagal menambahkan anggota', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    })
    .finally(() => {
        hideLoading();
    });
}

function removeAnggota(anggotaId) {
    if (confirm('Apakah Anda yakin ingin menghapus anggota ini dari keluarga?')) {
        showLoading();
        
        fetch(`/admin/keluarga/${keluargaId}/anggota/${anggotaId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Remove from list
                document.querySelector(`[data-id="${anggotaId}"]`).remove();
                
                // Add back to select
                const select = document.getElementById('anggotaSelect');
                const option = document.createElement('option');
                option.value = anggotaId;
                option.dataset.nama = data.anggota.nama;
                option.dataset.nik = data.anggota.nik;
                option.dataset.jk = data.anggota.jk;
                option.textContent = `${data.anggota.nama} - ${data.anggota.nik}`;
                select.appendChild(option);
                
                showToast('Anggota berhasil dihapus', 'success');
            } else {
                showToast(data.message || 'Gagal menghapus anggota', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

function updateHubungan(anggotaId, hubungan) {
    fetch(`/admin/keluarga/${keluargaId}/anggota/${anggotaId}/hubungan`, {
        method: 'PUT',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ hubungan_keluarga: hubungan })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Hubungan keluarga berhasil diperbarui', 'success');
        } else {
            showToast(data.message || 'Gagal memperbarui hubungan', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    });
}

function validateNoKK(noKK) {
    const input = document.querySelector('input[name="no_kk"]');
    const originalKK = '<?php echo e($keluarga->no_kk); ?>';
    
    if (noKK.length === 16) {
        input.classList.remove('is-invalid');
        input.classList.add('is-valid');
        
        // Check if KK already exists (excluding current)
        if (noKK !== originalKK) {
            checkKKExists(noKK);
        }
    } else if (noKK.length > 0) {
        input.classList.remove('is-valid');
        input.classList.add('is-invalid');
    } else {
        input.classList.remove('is-valid', 'is-invalid');
    }
}

function checkKKExists(noKK) {
    fetch('/admin/keluarga/check-kk', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ 
            no_kk: noKK,
            exclude_id: keluargaId
        })
    })
    .then(response => response.json())
    .then(data => {
        const input = document.querySelector('input[name="no_kk"]');
        if (data.exists) {
            input.classList.remove('is-valid');
            input.classList.add('is-invalid');
            showToast('Nomor KK sudah terdaftar', 'warning');
        }
    })
    .catch(error => {
        console.error('Error checking KK:', error);
    });
}

function refreshPendudukList() {
    location.reload();
}

function resetChanges() {
    if (confirm('Apakah Anda yakin ingin membatalkan semua perubahan?')) {
        location.reload();
    }
}

function deleteKeluarga() {
    if (confirm('Apakah Anda yakin ingin menghapus data keluarga ini? Tindakan ini tidak dapat dibatalkan.\n\nSemua anggota keluarga akan kehilangan keterkaitan dengan keluarga ini.')) {
        showLoading();
        
        fetch(`/admin/keluarga/${keluargaId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Data keluarga berhasil dihapus', 'success');
                setTimeout(() => {
                    window.location.href = '/admin/keluarga';
                }, 1500);
            } else {
                showToast(data.message || 'Gagal menghapus data keluarga', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

// Handle form submission
document.getElementById('editKeluargaForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    // Validate required fields
    const noKK = document.querySelector('input[name="no_kk"]').value;
    const kepalaKeluargaId = document.querySelector('select[name="kepala_keluarga_id"]').value;
    const alamat = document.querySelector('textarea[name="alamat"]').value;
    
    if (!noKK || !kepalaKeluargaId || !alamat) {
        showToast('Harap lengkapi semua field yang wajib diisi', 'error');
        return;
    }
    
    if (noKK.length !== 16) {
        showToast('Nomor KK harus 16 digit', 'error');
        return;
    }
    
    const formData = new FormData(this);
    
    // Disable submit button
    $('button[type="submit"]').prop('disabled', true);
    showLoading();
    
    fetch(`/admin/keluarga/${keluargaId}`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Data keluarga berhasil diperbarui', 'success');
            setTimeout(() => {
                window.location.href = '/admin/keluarga';
            }, 1500);
        } else {
            showToast(data.message || 'Gagal memperbarui data keluarga', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan saat menyimpan', 'error');
    })
    .finally(() => {
        $('button[type="submit"]').prop('disabled', false);
        hideLoading();
    });
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/keluarga/edit.blade.php ENDPATH**/ ?>