

<?php $__env->startSection('title', 'Bug Detection System'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active">Bug Detection</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-bug me-2 text-danger"></i>
            Bug Detection System
        </h2>
        <p class="text-muted mb-0">Monitor dan kelola bug dari semua fitur aplikasi</p>
    </div>
    <div>
        <a href="<?php echo e(route('admin.bugs.create')); ?>" class="btn btn-gradient-danger me-2">
            <i class="fas fa-plus me-2"></i>
            Report Bug
        </a>
        <a href="<?php echo e(route('admin.bugs.dashboard')); ?>" class="btn btn-gradient-info">
            <i class="fas fa-chart-line me-2"></i>
            Analytics
        </a>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-2">
        <div class="stats-card bg-gradient-danger text-white">
            <div class="d-flex align-items-center">
                <div class="stats-icon me-3">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div>
                    <h4 class="mb-0 text-white"><?php echo e($stats['total']); ?></h4>
                    <small>Total Bugs</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="stats-card bg-gradient-warning text-white">
            <div class="d-flex align-items-center">
                <div class="stats-icon me-3">
                    <i class="fas fa-folder-open"></i>
                </div>
                <div>
                    <h4 class="mb-0 text-white"><?php echo e($stats['open']); ?></h4>
                    <small>Open Bugs</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="stats-card bg-gradient-dark text-white">
            <div class="d-flex align-items-center">
                <div class="stats-icon me-3">
                    <i class="fas fa-skull"></i>
                </div>
                <div>
                    <h4 class="mb-0 text-white"><?php echo e($stats['critical']); ?></h4>
                    <small>Critical</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="stats-card bg-gradient-danger text-white">
            <div class="d-flex align-items-center">
                <div class="stats-icon me-3">
                    <i class="fas fa-fire"></i>
                </div>
                <div>
                    <h4 class="mb-0 text-white"><?php echo e($stats['high']); ?></h4>
                    <small>High Priority</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="stats-card bg-gradient-success text-white">
            <div class="d-flex align-items-center">
                <div class="stats-icon me-3">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div>
                    <h4 class="mb-0 text-white"><?php echo e($stats['resolved_today']); ?></h4>
                    <small>Resolved Today</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-2">
        <div class="stats-card bg-gradient-info text-white">
            <div class="d-flex align-items-center">
                <div class="stats-icon me-3">
                    <i class="fas fa-heartbeat"></i>
                </div>
                <div>
                    <button id="healthCheck" class="btn btn-sm btn-light text-dark">
                        Health Check
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="<?php echo e(route('admin.bugs.index')); ?>" id="filterForm">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Search</label>
                    <input type="text" class="form-control" name="search" 
                           placeholder="Search bugs..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Severity</label>
                    <select name="severity" class="form-select">
                        <option value="">All Severities</option>
                        <option value="critical" <?php echo e(request('severity') == 'critical' ? 'selected' : ''); ?>>Critical</option>
                        <option value="high" <?php echo e(request('severity') == 'high' ? 'selected' : ''); ?>>High</option>
                        <option value="medium" <?php echo e(request('severity') == 'medium' ? 'selected' : ''); ?>>Medium</option>
                        <option value="low" <?php echo e(request('severity') == 'low' ? 'selected' : ''); ?>>Low</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select">
                        <option value="">All Status</option>
                        <option value="open" <?php echo e(request('status') == 'open' ? 'selected' : ''); ?>>Open</option>
                        <option value="in_progress" <?php echo e(request('status') == 'in_progress' ? 'selected' : ''); ?>>In Progress</option>
                        <option value="resolved" <?php echo e(request('status') == 'resolved' ? 'selected' : ''); ?>>Resolved</option>
                        <option value="closed" <?php echo e(request('status') == 'closed' ? 'selected' : ''); ?>>Closed</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Type</label>
                    <select name="type" class="form-select">
                        <option value="">All Types</option>
                        <option value="bug" <?php echo e(request('type') == 'bug' ? 'selected' : ''); ?>>Bug</option>
                        <option value="error" <?php echo e(request('type') == 'error' ? 'selected' : ''); ?>>Error</option>
                        <option value="warning" <?php echo e(request('type') == 'warning' ? 'selected' : ''); ?>>Warning</option>
                        <option value="info" <?php echo e(request('type') == 'info' ? 'selected' : ''); ?>>Info</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Module</label>
                    <select name="module" class="form-select">
                        <option value="">All Modules</option>
                        <?php $__currentLoopData = $modules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $module): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($module); ?>" <?php echo e(request('module') == $module ? 'selected' : ''); ?>>
                                <?php echo e($module); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-1">
                    <label class="form-label">&nbsp;</label>
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fas fa-search"></i>
                        </button>
                        <a href="<?php echo e(route('admin.bugs.index')); ?>" class="btn btn-outline-secondary btn-sm">
                            <i class="fas fa-times"></i>
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Bulk Actions -->
<div class="card mb-4">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <input type="checkbox" id="selectAll" class="form-check-input me-2">
                <label for="selectAll" class="form-check-label">Select All</label>
            </div>
            <div>
                <button type="button" class="btn btn-success btn-sm" onclick="bulkResolve()" disabled id="bulkResolveBtn">
                    <i class="fas fa-check me-1"></i> Resolve Selected
                </button>
                <button type="button" class="btn btn-info btn-sm" onclick="exportBugs()">
                    <i class="fas fa-download me-1"></i> Export CSV
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Bugs Table -->
<div class="card">
    <div class="card-header bg-light">
        <h5 class="card-title mb-0">
            <i class="fas fa-list me-2"></i>
            Bug Reports (<?php echo e($bugs->total()); ?> total)
        </h5>
    </div>
    <div class="card-body">
        <?php if($bugs->count() > 0): ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th width="3%">
                            <input type="checkbox" class="form-check-input" id="selectAllTable">
                        </th>
                        <th width="30%">Title</th>
                        <th width="10%">Severity</th>
                        <th width="10%">Status</th>
                        <th width="8%">Type</th>
                        <th width="10%">Module</th>
                        <th width="8%">Count</th>
                        <th width="12%">Last Occurred</th>
                        <th width="9%">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $bugs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bug): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <input type="checkbox" class="form-check-input bug-checkbox" value="<?php echo e($bug->id); ?>">
                        </td>
                        <td>
                            <div class="fw-semibold"><?php echo e(Str::limit($bug->title, 40)); ?></div>
                            <small class="text-muted"><?php echo e(Str::limit($bug->description, 60)); ?></small>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($bug->severity_badge_color); ?>">
                                <?php echo e(ucfirst($bug->severity)); ?>

                            </span>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($bug->status_badge_color); ?>">
                                <?php echo e(str_replace('_', ' ', ucfirst($bug->status))); ?>

                            </span>
                        </td>
                        <td>
                            <span class="badge bg-<?php echo e($bug->type_badge_color); ?>">
                                <?php echo e(ucfirst($bug->type)); ?>

                            </span>
                        </td>
                        <td>
                            <span class="text-muted"><?php echo e($bug->module ?? 'N/A'); ?></span>
                        </td>
                        <td>
                            <span class="badge bg-secondary"><?php echo e($bug->occurrence_count); ?></span>
                        </td>
                        <td>
                            <div class="fw-semibold"><?php echo e($bug->last_occurred_at ? $bug->last_occurred_at->diffForHumans() : $bug->created_at->diffForHumans()); ?></div>
                            <small class="text-muted"><?php echo e($bug->created_at->format('d/m/Y H:i')); ?></small>
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <a href="<?php echo e(route('admin.bugs.show', $bug)); ?>" class="btn btn-outline-info" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <?php if($bug->status !== 'resolved'): ?>
                                <button type="button" class="btn btn-outline-success" 
                                        onclick="quickResolve(<?php echo e($bug->id); ?>)" title="Quick Resolve">
                                    <i class="fas fa-check"></i>
                                </button>
                                <?php endif; ?>
                                <button type="button" class="btn btn-outline-danger" 
                                        onclick="deleteBug(<?php echo e($bug->id); ?>)" title="Delete">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="d-flex justify-content-between align-items-center mt-3">
            <div>
                Showing <?php echo e($bugs->firstItem()); ?> to <?php echo e($bugs->lastItem()); ?> of <?php echo e($bugs->total()); ?> results
            </div>
            <div>
                <?php echo e($bugs->appends(request()->query())->links()); ?>

            </div>
        </div>
        <?php else: ?>
        <div class="text-center py-5">
            <i class="fas fa-bug fa-3x text-muted mb-3"></i>
            <h5 class="text-muted">No bugs found</h5>
            <p class="text-muted">Great! Your system seems to be running smoothly.</p>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modals -->
<!-- Bulk Resolve Modal -->
<div class="modal fade" id="bulkResolveModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Resolve Multiple Bugs</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="bulkResolveForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Resolution Notes</label>
                        <textarea class="form-control" name="resolution_notes" rows="3" 
                                  placeholder="Describe how these bugs were resolved..."></textarea>
                    </div>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <span id="selectedCount">0</span> bugs will be marked as resolved.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Resolve Bugs</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Health Check Result Modal -->
<div class="modal fade" id="healthCheckModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">System Health Check</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="healthCheckResult">
                <div class="text-center">
                    <i class="fas fa-spinner fa-spin fa-2x"></i>
                    <p class="mt-2">Running health check...</p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.stats-card {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 15px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    transition: transform 0.3s ease;
}

.stats-card:hover {
    transform: translateY(-5px);
}

.stats-icon {
    width: 50px;
    height: 50px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
}

.bg-gradient-danger {
    background: linear-gradient(135deg, #ff416c 0%, #ff4757 100%);
}

.bg-gradient-warning {
    background: linear-gradient(135deg, #f7b731 0%, #f39801 100%);
}

.bg-gradient-success {
    background: linear-gradient(135deg, #2ed573 0%, #1dd1a1 100%);
}

.bg-gradient-info {
    background: linear-gradient(135deg, #3742fa 0%, #2f3542 100%);
}

.bg-gradient-dark {
    background: linear-gradient(135deg, #2c2c54 0%, #40407a 100%);
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Checkbox handling
document.getElementById('selectAll').addEventListener('change', function() {
    const checkboxes = document.querySelectorAll('.bug-checkbox');
    checkboxes.forEach(checkbox => {
        checkbox.checked = this.checked;
    });
    updateBulkActions();
});

document.querySelectorAll('.bug-checkbox').forEach(checkbox => {
    checkbox.addEventListener('change', updateBulkActions);
});

function updateBulkActions() {
    const selected = document.querySelectorAll('.bug-checkbox:checked');
    const bulkBtn = document.getElementById('bulkResolveBtn');
    
    if (selected.length > 0) {
        bulkBtn.disabled = false;
        bulkBtn.innerHTML = `<i class="fas fa-check me-1"></i> Resolve Selected (${selected.length})`;
    } else {
        bulkBtn.disabled = true;
        bulkBtn.innerHTML = '<i class="fas fa-check me-1"></i> Resolve Selected';
    }
}

// Health Check
document.getElementById('healthCheck').addEventListener('click', function() {
    const modal = new bootstrap.Modal(document.getElementById('healthCheckModal'));
    modal.show();
    
    fetch('/admin/bugs/health-check')
        .then(response => response.json())
        .then(data => {
            let html = '';
            
            if (data.status === 'healthy') {
                html = `
                    <div class="text-center text-success">
                        <i class="fas fa-check-circle fa-3x mb-3"></i>
                        <h4>System Healthy</h4>
                        <p>All systems are running normally.</p>
                    </div>
                `;
            } else {
                html = `
                    <div class="text-center text-warning mb-4">
                        <i class="fas fa-exclamation-triangle fa-3x mb-3"></i>
                        <h4>Issues Detected</h4>
                    </div>
                    <div class="list-group">
                `;
                
                data.issues.forEach(issue => {
                    const icon = issue.type === 'critical' ? 'fa-exclamation-circle text-danger' :
                                issue.type === 'high' ? 'fa-exclamation-triangle text-warning' :
                                'fa-info-circle text-info';
                    
                    html += `
                        <div class="list-group-item">
                            <div class="d-flex align-items-center">
                                <i class="fas ${icon} me-3"></i>
                                <div>
                                    <h6 class="mb-1">${issue.module}</h6>
                                    <p class="mb-0 text-muted">${issue.message}</p>
                                </div>
                            </div>
                        </div>
                    `;
                });
                
                html += '</div>';
            }
            
            document.getElementById('healthCheckResult').innerHTML = html;
        })
        .catch(error => {
            document.getElementById('healthCheckResult').innerHTML = `
                <div class="text-center text-danger">
                    <i class="fas fa-times-circle fa-3x mb-3"></i>
                    <h4>Health Check Failed</h4>
                    <p>Unable to perform health check: ${error.message}</p>
                </div>
            `;
        });
});

// Bulk resolve
function bulkResolve() {
    const selected = document.querySelectorAll('.bug-checkbox:checked');
    if (selected.length === 0) return;
    
    document.getElementById('selectedCount').textContent = selected.length;
    const modal = new bootstrap.Modal(document.getElementById('bulkResolveModal'));
    modal.show();
}

document.getElementById('bulkResolveForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const selected = Array.from(document.querySelectorAll('.bug-checkbox:checked')).map(cb => cb.value);
    const notes = this.querySelector('textarea[name="resolution_notes"]').value;
    
    fetch('/admin/bugs/bulk-resolve', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify({
            bug_ids: selected,
            resolution_notes: notes
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast(data.message, 'success');
            setTimeout(() => location.reload(), 1500);
        } else {
            showToast(data.message || 'Error resolving bugs', 'error');
        }
    })
    .catch(error => {
        showToast('Error resolving bugs', 'error');
    });
    
    bootstrap.Modal.getInstance(document.getElementById('bulkResolveModal')).hide();
});

// Quick resolve single bug
function quickResolve(bugId) {
    if (!confirm('Mark this bug as resolved?')) return;
    
    fetch(`/admin/bugs/${bugId}`, {
        method: 'PUT',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: JSON.stringify({
            status: 'resolved'
        })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast(data.message, 'success');
            setTimeout(() => location.reload(), 1500);
        } else {
            showToast(data.message || 'Error updating bug', 'error');
        }
    })
    .catch(error => {
        showToast('Error updating bug', 'error');
    });
}

// Delete bug
function deleteBug(bugId) {
    if (!confirm('Are you sure you want to delete this bug report?')) return;
    
    fetch(`/admin/bugs/${bugId}`, {
        method: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(response => {
        if (response.ok) {
            showToast('Bug deleted successfully', 'success');
            setTimeout(() => location.reload(), 1500);
        } else {
            showToast('Error deleting bug', 'error');
        }
    })
    .catch(error => {
        showToast('Error deleting bug', 'error');
    });
}

// Export bugs
function exportBugs() {
    const params = new URLSearchParams(window.location.search);
    window.location.href = '/admin/bugs/export?' + params.toString();
}

// Toast notification function
function showToast(message, type = 'success') {
    const toast = document.createElement('div');
    toast.className = `alert alert-${type === 'error' ? 'danger' : type} alert-dismissible fade show position-fixed`;
    toast.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    toast.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(toast);
    
    setTimeout(() => {
        if (toast.parentNode) {
            toast.parentNode.removeChild(toast);
        }
    }, 5000);
}

// Auto-refresh for real-time monitoring (every 30 seconds)
setInterval(() => {
    // Only refresh if no modals are open
    if (!document.querySelector('.modal.show')) {
        // Update stats only, not full page reload
        fetch('/admin/bugs/statistics')
            .then(response => response.json())
            .then(data => {
                // Update stats if needed
                console.log('Stats updated:', data);
            })
            .catch(error => console.log('Stats update failed:', error));
    }
}, 30000);
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/bugs/index.blade.php ENDPATH**/ ?>