<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Penduduk - <?php echo e(date('d F Y')); ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        
        .header h2 {
            margin: 5px 0;
            font-size: 14px;
            color: #666;
        }
        
        .info {
            margin-bottom: 20px;
        }
        
        .info table {
            width: 100%;
        }
        
        .info td {
            padding: 3px 0;
        }
        
        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        
        .data-table th,
        .data-table td {
            border: 1px solid #333;
            padding: 6px 4px;
            text-align: left;
            font-size: 10px;
        }
        
        .data-table th {
            background-color: #f5f5f5;
            font-weight: bold;
            text-align: center;
        }
        
        .data-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        .footer {
            margin-top: 30px;
            text-align: right;
            font-size: 11px;
        }
        
        .signature {
            margin-top: 40px;
            text-align: right;
        }
        
        .signature-box {
            display: inline-block;
            text-align: center;
            margin-left: 50px;
        }
        
        .signature-line {
            border-bottom: 1px solid #333;
            width: 200px;
            margin: 50px 0 10px 0;
        }
        
        @media print {
            body {
                margin: 0;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <!-- Print Button -->
    <div class="no-print" style="text-align: center; margin-bottom: 20px;">
        <button onclick="window.print()" style="padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer;">
            <span style="margin-right: 5px;">🖨️</span> Cetak / Download PDF
        </button>
        <button onclick="window.close()" style="padding: 10px 20px; background: #6c757d; color: white; border: none; border-radius: 5px; cursor: pointer; margin-left: 10px;">
            <span style="margin-right: 5px;">❌</span> Tutup
        </button>
    </div>

    <!-- Header -->
    <div class="header">
        <h1>LAPORAN DATA PENDUDUK</h1>
        <h2>DESA [NAMA DESA]</h2>
        <p style="margin: 5px 0; font-size: 12px;">
            Dicetak pada: <?php echo e(\Carbon\Carbon::now()->format('d F Y, H:i')); ?> WIB
        </p>
    </div>

    <!-- Summary Info -->
    <div class="info">
        <table>
            <tr>
                <td width="150"><strong>Total Penduduk:</strong></td>
                <td><?php echo e($penduduk->total()); ?> orang</td>
                <td width="150"><strong>Halaman:</strong></td>
                <td><?php echo e($penduduk->currentPage()); ?> dari <?php echo e($penduduk->lastPage()); ?></td>
            </tr>
            <tr>
                <td><strong>Laki-laki:</strong></td>
                <td><?php echo e($penduduk->where('jenis_kelamin', 'L')->count()); ?> orang</td>
                <td><strong>Data per halaman:</strong></td>
                <td><?php echo e($penduduk->perPage()); ?> data</td>
            </tr>
            <tr>
                <td><strong>Perempuan:</strong></td>
                <td><?php echo e($penduduk->where('jenis_kelamin', 'P')->count()); ?> orang</td>
                <td><strong>Filter diterapkan:</strong></td>
                <td><?php echo e(request()->has('dusun') || request()->has('rt') || request()->has('rw') ? 'Ya' : 'Tidak'); ?></td>
            </tr>
        </table>
    </div>

    <!-- Data Table -->
    <table class="data-table">
        <thead>
            <tr>
                <th width="3%">No</th>
                <th width="12%">NIK</th>
                <th width="15%">Nama</th>
                <th width="5%">JK</th>
                <th width="6%">Umur</th>
                <th width="15%">Alamat</th>
                <th width="8%">Dusun</th>
                <th width="4%">RT</th>
                <th width="4%">RW</th>
                <th width="10%">Pekerjaan</th>
                <th width="8%">Pendidikan</th>
                <th width="10%">Status Keluarga</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $penduduk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td style="text-align: center;"><?php echo e($penduduk->firstItem() + $index); ?></td>
                <td><?php echo e($p->nik); ?></td>
                <td><?php echo e($p->nama); ?></td>
                <td style="text-align: center;"><?php echo e($p->jenis_kelamin); ?></td>
                <td style="text-align: center;"><?php echo e($p->umur); ?></td>
                <td><?php echo e(Str::limit($p->alamat, 30)); ?></td>
                <td><?php echo e($p->dusun ?? '-'); ?></td>
                <td style="text-align: center;"><?php echo e($p->rt ?? '-'); ?></td>
                <td style="text-align: center;"><?php echo e($p->rw ?? '-'); ?></td>
                <td><?php echo e(Str::limit($p->pekerjaan, 15)); ?></td>
                <td><?php echo e(Str::limit($p->pendidikan, 10)); ?></td>
                <td><?php echo e(Str::limit($p->anggotaKeluarga->status_keluarga ?? 'Tidak Diketahui', 15)); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="12" style="text-align: center; padding: 20px;">
                    Tidak ada data penduduk
                </td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- Footer -->
    <div class="footer">
        <p><strong>Catatan:</strong></p>
        <ul style="text-align: left; margin: 10px 0; padding-left: 20px;">
            <li>JK = Jenis Kelamin (L = Laki-laki, P = Perempuan)</li>
            <li>Data yang ditampilkan maksimal 50 data per halaman untuk optimalisasi</li>
            <li>Untuk data lengkap, silakan export ke format Excel</li>
        </ul>
    </div>

    <!-- Signature -->
    <div class="signature">
        <div class="signature-box">
            <p><?php echo e(\Carbon\Carbon::now()->format('d F Y')); ?></p>
            <p><strong>Kepala Desa</strong></p>
            <div class="signature-line"></div>
            <p><strong>[NAMA KEPALA DESA]</strong></p>
            <p>NIP. [NIP KEPALA DESA]</p>
        </div>
    </div>

    <!-- Page break for next page -->
    <?php if($penduduk->hasMorePages()): ?>
    <div style="page-break-after: always;"></div>
    <div class="no-print" style="text-align: center; margin: 20px 0;">
        <p><strong>Halaman berikutnya tersedia</strong></p>
        <a href="<?php echo e($penduduk->nextPageUrl()); ?>" style="color: #007bff; text-decoration: none;">
            Lihat Halaman <?php echo e($penduduk->currentPage() + 1); ?> →
        </a>
    </div>
    <?php endif; ?>

    <script>
        // Auto print when opened in new window
        window.onload = function() {
            // Focus for keyboard shortcuts
            window.focus();
        }

        // Keyboard shortcut for print
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey && e.key === 'p') {
                e.preventDefault();
                window.print();
            }
        });
    </script>
</body>
</html> 
<?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/penduduk/export-pdf.blade.php ENDPATH**/ ?>