

<?php $__env->startSection('title', 'Detail Produk UMKM'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Detail Produk UMKM</h1>
        <div class="d-flex">
            <a href="<?php echo e(route('admin.produk-umkm.edit', $produk->id)); ?>" class="btn btn-warning btn-sm mr-2">
                <i class="fas fa-edit"></i> Edit
            </a>
            <a href="<?php echo e(route('admin.produk-umkm.index')); ?>" class="btn btn-secondary btn-sm">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8">
            <!-- Basic Information -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Produk</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Nama Produk</strong></td>
                                    <td>: <?php echo e($produk->nama_produk); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Kategori</strong></td>
                                    <td>: <span class="badge badge-info"><?php echo e(ucfirst($produk->kategori)); ?></span></td>
                                </tr>
                                <tr>
                                    <td><strong>Status</strong></td>
                                    <td>: 
                                        <?php if($produk->status === 'aktif'): ?>
                                            <span class="badge badge-success">Aktif</span>
                                        <?php elseif($produk->status === 'pending'): ?>
                                            <span class="badge badge-warning">Pending</span>
                                        <?php else: ?>
                                            <span class="badge badge-secondary">Non-aktif</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Harga</strong></td>
                                    <td>: <span class="h6 text-primary">Rp <?php echo e(number_format($produk->harga)); ?></span></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Stok</strong></td>
                                    <td>: 
                                        <span class="font-weight-bold <?php echo e($produk->stok < 10 ? 'text-danger' : 'text-success'); ?>">
                                            <?php echo e($produk->stok); ?> unit
                                        </span>
                                        <?php if($produk->stok < 10): ?>
                                            <small class="text-danger">(Stok menipis)</small>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Berat</strong></td>
                                    <td>: <?php echo e($produk->berat ?? '-'); ?> gram</td>
                                </tr>
                                <tr>
                                    <td><strong>Total Penjualan</strong></td>
                                    <td>: <?php echo e($produk->total_terjual); ?> unit</td>
                                </tr>
                                <tr>
                                    <td><strong>Dibuat</strong></td>
                                    <td>: <?php echo e($produk->created_at->format('d/m/Y H:i')); ?></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- UMKM Information -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi UMKM</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="40%"><strong>Nama UMKM</strong></td>
                                    <td>: 
                                        <a href="<?php echo e(route('admin.umkm.show', $produk->umkm->id)); ?>" 
                                           class="text-decoration-none">
                                            <?php echo e($produk->umkm->nama_umkm); ?>

                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <td><strong>Pemilik</strong></td>
                                    <td>: <?php echo e($produk->umkm->nama_pemilik); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Kategori UMKM</strong></td>
                                    <td>: <?php echo e(ucfirst($produk->umkm->kategori)); ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="30%"><strong>Telepon</strong></td>
                                    <td>: <?php echo e($produk->umkm->telepon ?? '-'); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Email</strong></td>
                                    <td>: <?php echo e($produk->umkm->email ?? '-'); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Status UMKM</strong></td>
                                    <td>: 
                                        <?php if($produk->umkm->status === 'terverifikasi'): ?>
                                            <span class="badge badge-success">Terverifikasi</span>
                                        <?php elseif($produk->umkm->status === 'pending'): ?>
                                            <span class="badge badge-warning">Pending</span>
                                        <?php else: ?>
                                            <span class="badge badge-secondary">Tidak Aktif</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Description -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Deskripsi Produk</h6>
                </div>
                <div class="card-body">
                    <p><?php echo e($produk->deskripsi); ?></p>
                </div>
            </div>

            <!-- Variants -->
            <?php if($produk->varian): ?>
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Varian Produk</h6>
                    </div>
                    <div class="card-body">
                        <?php
                            $varian = is_array($produk->varian) ? $produk->varian : json_decode($produk->varian, true);
                        ?>
                        <?php if($varian): ?>
                            <div class="row">
                                <?php $__currentLoopData = $varian; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-4 mb-2">
                                        <div class="border rounded p-2">
                                            <strong><?php echo e($item['nama'] ?? 'Varian'); ?></strong><br>
                                            <small class="text-muted">
                                                Harga: Rp <?php echo e(number_format($item['harga'] ?? 0)); ?><br>
                                                Stok: <?php echo e($item['stok'] ?? 0); ?> unit
                                            </small>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Tags -->
            <?php if($produk->tags): ?>
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Tags</h6>
                    </div>
                    <div class="card-body">
                        <?php
                            $tags = is_array($produk->tags) ? $produk->tags : json_decode($produk->tags, true);
                        ?>
                        <?php if($tags): ?>
                            <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge badge-secondary mr-1"><?php echo e($tag); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Photo Gallery -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Galeri Produk</h6>
                </div>
                <div class="card-body">
                    <?php if($produk->foto_utama): ?>
                        <div class="mb-3">
                            <label class="small text-muted">Foto Utama</label>
                            <img src="<?php echo e(Storage::url($produk->foto_utama)); ?>" 
                                 alt="<?php echo e($produk->nama_produk); ?>" 
                                 class="img-fluid rounded"
                                 style="width: 100%; height: 200px; object-fit: cover;">
                        </div>
                    <?php endif; ?>

                    <?php if($produk->galeri_foto): ?>
                        <?php
                            $galeri = is_array($produk->galeri_foto) ? $produk->galeri_foto : json_decode($produk->galeri_foto, true);
                        ?>
                        <?php if($galeri && count($galeri) > 0): ?>
                            <label class="small text-muted">Galeri</label>
                            <div class="row">
                                <?php $__currentLoopData = $galeri; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $foto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-6 mb-2">
                                        <img src="<?php echo e(Storage::url($foto)); ?>" 
                                             alt="Gallery" 
                                             class="img-fluid rounded"
                                             style="width: 100%; height: 80px; object-fit: cover;"
                                             data-toggle="modal" 
                                             data-target="#photoModal"
                                             data-src="<?php echo e(Storage::url($foto)); ?>">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Statistics -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Statistik Penjualan</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted">Total Penjualan</small>
                        <div class="h5 text-primary"><?php echo e($stats['total_penjualan'] ?? 0); ?> unit</div>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Penjualan Bulan Ini</small>
                        <div class="h5 text-success"><?php echo e($stats['penjualan_bulan_ini'] ?? 0); ?> unit</div>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted">Revenue Total</small>
                        <div class="h5 text-info">Rp <?php echo e(number_format($stats['total_revenue'] ?? 0)); ?></div>
                    </div>
                    <div>
                        <small class="text-muted">Revenue Bulan Ini</small>
                        <div class="h5 text-warning">Rp <?php echo e(number_format($stats['revenue_bulan_ini'] ?? 0)); ?></div>
                    </div>
                </div>
            </div>

            <!-- Product Info -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Info Tambahan</h6>
                </div>
                <div class="card-body">
                    <?php if($produk->kondisi): ?>
                        <div class="mb-2">
                            <small class="text-muted">Kondisi</small>
                            <div><?php echo e(ucfirst($produk->kondisi)); ?></div>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($produk->minimal_order): ?>
                        <div class="mb-2">
                            <small class="text-muted">Minimal Order</small>
                            <div><?php echo e($produk->minimal_order); ?> unit</div>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($produk->waktu_produksi): ?>
                        <div class="mb-2">
                            <small class="text-muted">Waktu Produksi</small>
                            <div><?php echo e($produk->waktu_produksi); ?></div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Actions -->
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Aksi</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <?php if($produk->status === 'pending'): ?>
                            <button class="btn btn-success btn-sm" onclick="approveProduct()">
                                <i class="fas fa-check"></i> Setujui
                            </button>
                        <?php endif; ?>
                        <?php if($produk->status === 'aktif'): ?>
                            <button class="btn btn-warning btn-sm" onclick="toggleStatus('nonaktif')">
                                <i class="fas fa-pause"></i> Nonaktifkan
                            </button>
                        <?php else: ?>
                            <button class="btn btn-success btn-sm" onclick="toggleStatus('aktif')">
                                <i class="fas fa-play"></i> Aktifkan
                            </button>
                        <?php endif; ?>
                        <a href="<?php echo e(route('admin.umkm.show', $produk->umkm->id)); ?>" 
                           class="btn btn-info btn-sm">
                            <i class="fas fa-store"></i> Lihat UMKM
                        </a>
                        <button class="btn btn-danger btn-sm" onclick="deleteProduct()">
                            <i class="fas fa-trash"></i> Hapus
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Photo Modal -->
<div class="modal fade" id="photoModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-body p-0">
                <img id="modalPhoto" src="" class="img-fluid w-100">
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Photo modal
$('#photoModal').on('show.bs.modal', function (event) {
    var button = $(event.relatedTarget);
    var src = button.data('src');
    $('#modalPhoto').attr('src', src);
});

function approveProduct() {
    if (confirm('Setujui produk ini?')) {
        window.location.href = '<?php echo e(route("admin.produk-umkm.approve", $produk->id)); ?>';
    }
}

function toggleStatus(status) {
    var message = status === 'aktif' ? 'Aktifkan' : 'Nonaktifkan';
    if (confirm(message + ' produk ini?')) {
        // Create form to toggle status
        var form = $('<form>', {
            'method': 'POST',
            'action': '<?php echo e(route("admin.produk-umkm.toggle-status", $produk->id)); ?>'
        });
        form.append($('<input>', {'type': 'hidden', 'name': '_token', 'value': '<?php echo e(csrf_token()); ?>'}));
        form.append($('<input>', {'type': 'hidden', 'name': '_method', 'value': 'PATCH'}));
        form.append($('<input>', {'type': 'hidden', 'name': 'status', 'value': status}));
        $('body').append(form);
        form.submit();
    }
}

function deleteProduct() {
    if (confirm('Hapus produk ini? Tindakan ini tidak dapat dibatalkan.')) {
        // Create form to delete
        var form = $('<form>', {
            'method': 'POST',
            'action': '<?php echo e(route("admin.produk-umkm.destroy", $produk->id)); ?>'
        });
        form.append($('<input>', {'type': 'hidden', 'name': '_token', 'value': '<?php echo e(csrf_token()); ?>'}));
        form.append($('<input>', {'type': 'hidden', 'name': '_method', 'value': 'DELETE'}));
        $('body').append(form);
        form.submit();
    }
}
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/produk-umkm/show.blade.php ENDPATH**/ ?>