@extends('layouts.app')

@section('title', 'Realisasi APBDes')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
<li class="breadcrumb-item active">Realisasi APBDes</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-receipt text-primary me-2"></i>
                        Realisasi APBDes
                    </h4>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">
                        <i class="fas fa-plus me-1"></i>
                        Tambah Realisasi
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="realisasiTable">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Rencana</th>
                                    <th>Transaksi</th>
                                    <th>Nominal</th>
                                    <th>Tanggal</th>
                                    <th>Status</th>
                                    <th>Bukti</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($realisasi as $index => $item)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        <div>
                                            <strong>{{ $item->apbdesRencana->kode_rekening }}</strong><br>
                                            <small class="text-muted">{{ Str::limit($item->apbdesRencana->uraian, 50) }}</small>
                                        </div>
                                    </td>
                                    <td>{{ $item->keterangan_transaksi }}</td>
                                    <td>Rp {{ number_format($item->nominal, 0, ',', '.') }}</td>
                                    <td>{{ \Carbon\Carbon::parse($item->tanggal_transaksi)->format('d/m/Y') }}</td>
                                    <td>
                                        @if($item->status_verifikasi == 'pending')
                                            <span class="badge bg-warning">Pending</span>
                                        @elseif($item->status_verifikasi == 'verified')
                                            <span class="badge bg-success">Terverifikasi</span>
                                        @else
                                            <span class="badge bg-danger">Ditolak</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($item->bukti_transaksi)
                                            <a href="{{ Storage::url($item->bukti_transaksi) }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-file-alt"></i>
                                            </a>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            @if($item->status_verifikasi == 'pending')
                                                <button class="btn btn-sm btn-success" onclick="verifyRealisasi({{ $item->id }}, 'verified')">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                                <button class="btn btn-sm btn-danger" onclick="verifyRealisasi({{ $item->id }}, 'rejected')">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            @endif
                                            <button class="btn btn-sm btn-warning" onclick="editRealisasi({{ $item->id }})">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button class="btn btn-sm btn-danger" onclick="deleteRealisasi({{ $item->id }})">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">Belum ada data realisasi APBDes</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Tambah Realisasi APBDes</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addForm" action="{{ route('admin.apbdes.realisasi.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Rencana APBDes</label>
                        <select class="form-select" name="apbdes_rencana_id" required>
                            <option value="">Pilih Rencana</option>
                            @foreach($rencanaList as $rencana)
                                <option value="{{ $rencana->id }}">
                                    {{ $rencana->kode_rekening }} - {{ $rencana->uraian }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Keterangan Transaksi</label>
                        <textarea class="form-control" name="keterangan_transaksi" rows="3" required></textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nominal</label>
                                <input type="number" class="form-control" name="nominal" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Tanggal Transaksi</label>
                                <input type="date" class="form-control" name="tanggal_transaksi" required>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Bukti Transaksi</label>
                        <input type="file" class="form-control" name="bukti_transaksi" accept=".pdf,.jpg,.jpeg,.png">
                        <small class="text-muted">Format: PDF, JPG, PNG (Max: 2MB)</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function verifyRealisasi(id, status) {
    let statusText = status === 'verified' ? 'menyetujui' : 'menolak';
    
    if (confirm(`Apakah Anda yakin ingin ${statusText} realisasi ini?`)) {
        fetch(`{{ route('admin.apbdes.realisasi.index') }}/${id}/verify`, {
            method: 'PUT',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ status: status })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        });
    }
}

function deleteRealisasi(id) {
    if (confirm('Apakah Anda yakin ingin menghapus data ini?')) {
        fetch(`{{ route('admin.apbdes.realisasi.index') }}/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        });
    }
}
</script>
@endpush 
