@extends('layouts.admin')

@section('title', 'Tambah Arsip Surat Keluar')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title">
                            <i class="fas fa-plus me-2"></i>
                            Tambah Arsip Surat Keluar
                        </h3>
                        <a href="{{ route('admin.arsip-surat-keluar.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-1"></i>
                            Kembali
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <form action="{{ route('admin.arsip-surat-keluar.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tipe_surat" class="form-label">Tipe Surat <span class="text-danger">*</span></label>
                                    <select class="form-control @error('tipe_surat') is-invalid @enderror" 
                                            id="tipe_surat" name="tipe_surat" required>
                                        <option value="">Pilih Tipe Surat</option>
                                        @foreach($tipeSurat as $tipe)
                                            <option value="{{ $tipe }}" {{ old('tipe_surat') == $tipe ? 'selected' : '' }}>
                                                {{ $tipe }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('tipe_surat')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tanggal_surat" class="form-label">Tanggal Surat <span class="text-danger">*</span></label>
                                    <input type="date" 
                                           class="form-control @error('tanggal_surat') is-invalid @enderror" 
                                           id="tanggal_surat" 
                                           name="tanggal_surat" 
                                           value="{{ old('tanggal_surat', date('Y-m-d')) }}" 
                                           required>
                                    @error('tanggal_surat')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label for="perihal" class="form-label">Perihal <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('perihal') is-invalid @enderror" 
                                           id="perihal" 
                                           name="perihal" 
                                           value="{{ old('perihal') }}" 
                                           placeholder="Masukkan perihal surat"
                                           required>
                                    @error('perihal')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label for="tujuan" class="form-label">Tujuan <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('tujuan') is-invalid @enderror" 
                                           id="tujuan" 
                                           name="tujuan" 
                                           value="{{ old('tujuan') }}" 
                                           placeholder="Masukkan tujuan surat"
                                           required>
                                    @error('tujuan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label for="file_surat" class="form-label">File Surat <span class="text-danger">*</span></label>
                                    <input type="file" 
                                           class="form-control @error('file_surat') is-invalid @enderror" 
                                           id="file_surat" 
                                           name="file_surat" 
                                           accept=".pdf,.doc,.docx"
                                           required>
                                    <small class="form-text text-muted">
                                        Format: PDF, DOC, DOCX (Maksimal 5MB)
                                    </small>
                                    @error('file_surat')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label for="keterangan" class="form-label">Keterangan</label>
                                    <textarea class="form-control @error('keterangan') is-invalid @enderror" 
                                              id="keterangan" 
                                              name="keterangan" 
                                              rows="3" 
                                              placeholder="Masukkan keterangan tambahan (opsional)">{{ old('keterangan') }}</textarea>
                                    @error('keterangan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex justify-content-end gap-2">
                                    <a href="{{ route('admin.arsip-surat-keluar.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-times me-1"></i>
                                        Batal
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i>
                                        Simpan
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 