@extends('layouts.app')

@section('title', 'Manajemen Berita')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Berita</li>
@endsection

@section('content')
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-newspaper me-2 text-warning"></i>
            Manajemen Berita
        </h2>
        <p class="text-muted mb-0">Kelola berita dan informasi desa</p>
    </div>
    <div>
        <button type="button" class="btn btn-gradient-info me-2" data-bs-toggle="modal" data-bs-target="#broadcastModal">
            <i class="fas fa-bullhorn me-2"></i>
            Broadcast WhatsApp
        </button>
        <a href="{{ route('admin.berita.create') }}" class="btn btn-gradient-warning">
            <i class="fas fa-plus me-2"></i>
            Tulis Berita
        </a>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-warning me-3">
                    <i class="fas fa-newspaper"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['total'] ?? 0 }}</h4>
                    <small class="text-muted">Total Berita</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-success me-3">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['published'] ?? 0 }}</h4>
                    <small class="text-muted">Dipublikasi</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-info me-3">
                    <i class="fas fa-edit"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['draft'] ?? 0 }}</h4>
                    <small class="text-muted">Draft</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-primary me-3">
                    <i class="fas fa-eye"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ number_format($stats['total_views'] ?? 0) }}</h4>
                    <small class="text-muted">Total Views</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-secondary me-3">
                    <i class="fas fa-comments"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ number_format($stats['total_comments'] ?? 0) }}</h4>
                    <small class="text-muted">Total Komentar</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-2 col-md-4 col-sm-6 mb-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-danger me-3">
                    <i class="fas fa-clock"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ number_format($stats['pending_comments'] ?? 0) }}</h4>
                    <small class="text-muted">Pending Komentar</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row align-items-center">
            <div class="col-md-8">
                <div class="row">
                    <div class="col-md-4">
                        <label class="form-label">Pencarian</label>
                        <div class="input-group">
                            <span class="input-group-text">
                                <i class="fas fa-search"></i>
                            </span>
                            <input type="text" class="form-control" id="searchInput" placeholder="Cari judul berita...">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" id="filterStatus">
                            <option value="">Semua Status</option>
                            <option value="published">Dipublikasi</option>
                            <option value="draft">Draft</option>
                            <option value="archived">Diarsipkan</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Kategori</label>
                        <select class="form-select" id="filterCategory">
                            <option value="">Semua Kategori</option>
                            <option value="pengumuman">Pengumuman</option>
                            <option value="kegiatan">Kegiatan</option>
                            <option value="informasi">Informasi</option>
                            <option value="berita">Berita</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="button" class="btn btn-primary" onclick="applyFilters()">
                                <i class="fas fa-filter"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 text-end">
                <div class="btn-group">
                    <button type="button" class="btn btn-outline-secondary active" id="cardViewBtn" onclick="switchView('card')">
                        <i class="fas fa-th-large"></i> Kartu
                    </button>
                    <button type="button" class="btn btn-outline-secondary" id="listViewBtn" onclick="switchView('list')">
                        <i class="fas fa-list"></i> List
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Card View -->
<div id="cardView" class="row">
    @forelse($berita as $b)
    <div class="col-lg-4 col-md-6 mb-4 news-card" 
         data-search="{{ strtolower($b->judul) }}"
         data-status="{{ $b->status }}"
         data-category="{{ $b->kategori }}">
        <div class="card news-card-item h-100">
            <!-- Image -->
            <div class="news-image">
                @if($b->gambar)
                    <img src="{{ asset('storage/' . $b->gambar) }}" class="card-img-top" alt="{{ $b->judul }}">
                @else
                    <div class="no-image">
                        <i class="fas fa-image fa-3x text-muted"></i>
                    </div>
                @endif
                
                <!-- Status Badge -->
                <div class="status-badge">
                    <span class="badge bg-{{ $b->status_color }}">{{ ucfirst($b->status) }}</span>
                </div>
                
                <!-- Category Badge -->
                <div class="category-badge">
                    <span class="badge bg-secondary">{{ ucfirst($b->kategori) }}</span>
                </div>
            </div>
            
            <div class="card-body d-flex flex-column">
                <div class="mb-2">
                    <small class="text-muted">
                        <i class="fas fa-calendar me-1"></i>
                        {{ $b->created_at->format('d M Y') }}
                        <span class="ms-2">
                            <i class="fas fa-user me-1"></i>
                            {{ $b->author->name ?? 'Admin' }}
                        </span>
                    </small>
                </div>
                
                <h5 class="card-title">{{ Str::limit($b->judul, 60) }}</h5>
                <p class="card-text text-muted flex-grow-1">
                    {{ Str::limit(strip_tags($b->konten), 120) }}
                </p>
                
                <!-- Stats -->
                <div class="news-stats mb-3">
                    <div class="row text-center">
                        <div class="col-3">
                            <small class="text-muted">Views</small>
                            <div class="fw-bold text-primary">{{ number_format($b->views ?? 0) }}</div>
                        </div>
                        <div class="col-3">
                            <small class="text-muted">Shares</small>
                            <div class="fw-bold text-success">{{ number_format($b->shares_count ?? 0) }}</div>
                        </div>
                        <div class="col-3">
                            <small class="text-muted">Likes</small>
                            <div class="fw-bold text-danger">{{ number_format($b->likes_count ?? 0) }}</div>
                        </div>
                        <div class="col-3">
                            <small class="text-muted">Komentar</small>
                            <div class="fw-bold text-info">{{ number_format($b->comments_count ?? 0) }}</div>
                        </div>
                    </div>
                </div>
                
                <!-- Actions -->
                <div class="mt-auto">
                    <div class="d-flex gap-2">
                        <a href="{{ route('admin.berita.show', $b->id) }}" 
                           class="btn btn-sm btn-outline-info flex-fill">
                            <i class="fas fa-eye me-1"></i>Lihat
                        </a>
                        <a href="{{ route('admin.berita.edit', $b->id) }}" 
                           class="btn btn-sm btn-outline-warning flex-fill">
                            <i class="fas fa-edit me-1"></i>Edit
                        </a>
                        <a href="{{ route('admin.berita.comments', $b->id) }}" 
                           class="btn btn-sm btn-outline-info flex-fill">
                            <i class="fas fa-comments me-1"></i>Komentar
                            @if($b->comments_count > 0)
                                <span class="badge bg-danger ms-1">{{ $b->comments_count }}</span>
                            @endif
                        </a>
                        <div class="dropdown">
                            <button class="btn btn-sm btn-outline-secondary dropdown-toggle" 
                                    type="button" data-bs-toggle="dropdown">
                                <i class="fas fa-cog"></i>
                            </button>
                            <ul class="dropdown-menu">
                                @if($b->status === 'draft')
                                <li><a class="dropdown-item" href="#" onclick="changeStatus({{ $b->id }}, 'published')">
                                    <i class="fas fa-check me-2"></i>Publikasikan
                                </a></li>
                                @elseif($b->status === 'published')
                                <li><a class="dropdown-item" href="#" onclick="changeStatus({{ $b->id }}, 'archived')">
                                    <i class="fas fa-archive me-2"></i>Arsipkan
                                </a></li>
                                @endif
                                <li><a class="dropdown-item" href="#" onclick="duplicateNews({{ $b->id }})">
                                    <i class="fas fa-copy me-2"></i>Duplikat
                                </a></li>
                                <li><a class="dropdown-item" href="#" onclick="shareToWhatsApp({{ $b->id }})">
                                    <i class="fab fa-whatsapp me-2"></i>Share WA
                                </a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item text-danger" href="#" onclick="deleteNews({{ $b->id }})">
                                    <i class="fas fa-trash me-2"></i>Hapus
                                </a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @empty
    <div class="col-12">
        <div class="text-center py-5">
            <i class="fas fa-newspaper fa-3x text-muted mb-3"></i>
            <h5 class="text-muted">Belum ada berita</h5>
            <p class="text-muted">Mulai menulis berita pertama untuk desa Anda</p>
            <a href="{{ route('admin.berita.create') }}" class="btn btn-gradient-warning">
                <i class="fas fa-plus me-2"></i>
                Tulis Berita Pertama
            </a>
        </div>
    </div>
    @endforelse
</div>

<!-- List View (Initially Hidden) -->
<div id="listView" style="display: none;">
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="beritaTable">
                    <thead>
                        <tr>
                            <th width="60">Gambar</th>
                            <th>Judul</th>
                            <th width="120">Kategori</th>
                            <th width="100">Status</th>
                            <th width="80">Views</th>
                            <th width="80">Komentar</th>
                            <th width="120">Tanggal</th>
                            <th width="150">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($berita as $b)
                        <tr>
                            <td>
                                                    @if($b->gambar)
                        <img src="{{ asset('storage/' . $b->gambar) }}" 
                                         class="rounded" width="50" height="40" 
                                         style="object-fit: cover;">
                                @else
                                    <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                         style="width: 50px; height: 40px;">
                                        <i class="fas fa-image text-muted"></i>
                                    </div>
                                @endif
                            </td>
                            <td>
                                <div>
                                    <strong>{{ Str::limit($b->judul, 50) }}</strong>
                                    <br><small class="text-muted">{{ $b->author->name ?? 'Admin' }}</small>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-secondary">{{ ucfirst($b->kategori) }}</span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $b->status_color }}">{{ ucfirst($b->status) }}</span>
                            </td>
                            <td>
                                <strong>{{ number_format($b->views ?? 0) }}</strong>
                            </td>
                            <td>
                                <span class="badge bg-info">{{ number_format($b->comments_count ?? 0) }}</span>
                            </td>
                            <td>{{ $b->created_at->format('d/m/Y') }}</td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('admin.berita.show', $b->id) }}" 
                                       class="btn btn-outline-info" title="Lihat">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.berita.edit', $b->id) }}" 
                                       class="btn btn-outline-warning" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <a href="{{ route('admin.berita.comments', $b->id) }}" 
                                       class="btn btn-outline-info" title="Komentar">
                                        <i class="fas fa-comments"></i>
                                        @if($b->comments_count > 0)
                                            <span class="badge bg-danger position-absolute top-0 start-100 translate-middle" style="font-size: 0.6em;">{{ $b->comments_count }}</span>
                                        @endif
                                    </a>
                                    <button type="button" 
                                            class="btn btn-outline-danger" 
                                            onclick="deleteNews({{ $b->id }})" 
                                            title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Pagination -->
@if($berita->hasPages())
<div class="d-flex justify-content-center mt-4">
    {{ $berita->links() }}
</div>
@endif

<!-- Broadcast Modal -->
<div class="modal fade" id="broadcastModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-bullhorn me-2"></i>
                    Broadcast WhatsApp
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="broadcastForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Pilih Berita</label>
                        <select class="form-select" name="berita_id" required>
                            <option value="">Pilih berita untuk di-broadcast</option>
                            @foreach($berita->where('status', 'published') as $b)
                            <option value="{{ $b->id }}">{{ $b->judul }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Target Penerima</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="allResidents" name="target[]" value="all">
                            <label class="form-check-label" for="allResidents">
                                Semua Penduduk
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="familyHeads" name="target[]" value="family_heads">
                            <label class="form-check-label" for="familyHeads">
                                Kepala Keluarga Saja
                            </label>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Pesan Tambahan (Opsional)</label>
                        <textarea class="form-control" name="additional_message" rows="3" 
                                  placeholder="Pesan tambahan yang akan disertakan..."></textarea>
                    </div>
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Estimasi penerima:</strong> <span id="recipientCount">0</span> nomor WhatsApp
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-paper-plane me-2"></i>
                        Kirim Broadcast
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .news-card-item {
        transition: all 0.3s ease;
        border: none;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        overflow: hidden;
    }
    
    .news-card-item:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    }
    
    .news-image {
        position: relative;
        height: 200px;
        overflow: hidden;
    }
    
    .news-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
        transition: transform 0.3s ease;
    }
    
    .news-card-item:hover .news-image img {
        transform: scale(1.05);
    }
    
    .no-image {
        width: 100%;
        height: 200px;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .status-badge {
        position: absolute;
        top: 10px;
        right: 10px;
    }
    
    .category-badge {
        position: absolute;
        top: 10px;
        left: 10px;
    }
    
    .news-stats {
        background: #f8f9fa;
        border-radius: 8px;
        padding: 10px;
    }
    
    .btn-group .btn.active {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-color: #667eea;
        color: white;
    }
    
    .card-title {
        font-weight: 600;
        line-height: 1.3;
    }
    
    .news-card[data-hidden="true"] {
        display: none;
    }
    
    .btn-gradient-warning {
        background: linear-gradient(135deg, #ffc107 0%, #ff8f00 100%);
        border: none;
        color: white;
        font-weight: 600;
    }
    
    .btn-gradient-warning:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(255, 193, 7, 0.3);
        color: white;
    }
    
    .btn-gradient-info {
        background: linear-gradient(135deg, #17a2b8 0%, #138496 100%);
        border: none;
        color: white;
        font-weight: 600;
    }
    
    .btn-gradient-info:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 25px rgba(23, 162, 184, 0.3);
        color: white;
    }
</style>
@endpush

@push('scripts')
<script>
$(document).ready(function() {
    // Initialize DataTable for list view
    $('#beritaTable').DataTable({
        responsive: true,
        pageLength: 25,
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json'
        },
        columnDefs: [
            { orderable: false, targets: [0, 6] }
        ]
    });
    
    // Update recipient count when target changes
    $('input[name="target[]"]').change(function() {
        updateRecipientCount();
    });
});

// Switch between card and list view
function switchView(view) {
    const cardView = document.getElementById('cardView');
    const listView = document.getElementById('listView');
    const cardBtn = document.getElementById('cardViewBtn');
    const listBtn = document.getElementById('listViewBtn');
    
    if (view === 'card') {
        cardView.style.display = 'block';
        listView.style.display = 'none';
        cardBtn.classList.add('active');
        listBtn.classList.remove('active');
    } else {
        cardView.style.display = 'none';
        listView.style.display = 'block';
        listBtn.classList.add('active');
        cardBtn.classList.remove('active');
    }
}

// Apply filters
function applyFilters() {
    const searchTerm = document.getElementById('searchInput').value.toLowerCase();
    const statusFilter = document.getElementById('filterStatus').value;
    const categoryFilter = document.getElementById('filterCategory').value;
    
    const cards = document.querySelectorAll('.news-card');
    let visibleCount = 0;
    
    cards.forEach(card => {
        const searchData = card.getAttribute('data-search');
        const status = card.getAttribute('data-status');
        const category = card.getAttribute('data-category');
        let show = true;
        
        // Search filter
        if (searchTerm && !searchData.includes(searchTerm)) {
            show = false;
        }
        
        // Status filter
        if (statusFilter && status !== statusFilter) {
            show = false;
        }
        
        // Category filter
        if (categoryFilter && category !== categoryFilter) {
            show = false;
        }
        
        card.setAttribute('data-hidden', !show);
        card.style.display = show ? 'block' : 'none';
        
        if (show) visibleCount++;
    });
    
    showToast(`Menampilkan ${visibleCount} dari ${cards.length} berita`, 'info');
}

// Change news status
function changeStatus(id, status) {
    const statusText = {
        'published': 'publikasikan',
        'archived': 'arsipkan',
        'draft': 'jadikan draft'
    };
    
    if (confirm(`Apakah Anda yakin ingin ${statusText[status]} berita ini?`)) {
        showLoading();
        
        fetch(`/admin/berita/${id}/status`, {
            method: 'PUT',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ status: status })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast(`Berita berhasil ${statusText[status]}`, 'success');
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } else {
                showToast(data.message || 'Gagal mengubah status berita', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan saat mengubah status', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

// Duplicate news
function duplicateNews(id) {
    if (confirm('Apakah Anda yakin ingin menduplikat berita ini?')) {
        showLoading();
        
        fetch(`/admin/berita/${id}/duplicate`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Berita berhasil diduplikat', 'success');
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } else {
                showToast(data.message || 'Gagal menduplikat berita', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan saat menduplikat berita', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

// Share to WhatsApp
function shareToWhatsApp(id) {
    showLoading();
    
    fetch(`/admin/berita/${id}/share-whatsapp`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
            'Content-Type': 'application/json'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Link WhatsApp berhasil dibuat', 'success');
            // Open WhatsApp share link
            window.open(data.whatsapp_url, '_blank');
        } else {
            showToast(data.message || 'Gagal membuat link WhatsApp', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan saat membuat link WhatsApp', 'error');
    })
    .finally(() => {
        hideLoading();
    });
}

// Delete news
function deleteNews(id) {
    if (confirm('Apakah Anda yakin ingin menghapus berita ini?\n\nData yang dihapus tidak dapat dikembalikan.')) {
        showLoading();
        
        fetch(`/admin/berita/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Berita berhasil dihapus', 'success');
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } else {
                showToast(data.message || 'Gagal menghapus berita', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan saat menghapus berita', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

// Update recipient count
function updateRecipientCount() {
    const targets = $('input[name="target[]"]:checked').map(function() {
        return this.value;
    }).get();
    
    // Simulate count calculation
    let count = 0;
    if (targets.includes('all')) {
        count = {{ $stats['total_residents'] ?? 100 }};
    } else if (targets.includes('family_heads')) {
        count = {{ $stats['family_heads'] ?? 50 }};
    }
    
    document.getElementById('recipientCount').textContent = count;
}

// Handle broadcast form
document.getElementById('broadcastForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const targets = $('input[name="target[]"]:checked').map(function() {
        return this.value;
    }).get();
    
    if (targets.length === 0) {
        showToast('Pilih minimal satu target penerima', 'error');
        return;
    }
    
    showLoading();
    
    fetch('/admin/berita/broadcast', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Broadcast berhasil dikirim', 'success');
            $('#broadcastModal').modal('hide');
            this.reset();
        } else {
            showToast(data.message || 'Gagal mengirim broadcast', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan saat mengirim broadcast', 'error');
    })
    .finally(() => {
        hideLoading();
    });
});

// Real-time search
document.getElementById('searchInput').addEventListener('input', function() {
    clearTimeout(this.searchTimeout);
    this.searchTimeout = setTimeout(() => {
        applyFilters();
    }, 300);
});

// Auto-apply filters when selects change
document.getElementById('filterStatus').addEventListener('change', applyFilters);
document.getElementById('filterCategory').addEventListener('change', applyFilters);
</script>
@endpush 
