@extends('layouts.app')

@section('title', 'Detail Inventaris Desa')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.inventaris-desa.index') }}">Inventaris Desa</a></li>
    <li class="breadcrumb-item active">Detail Inventaris</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-8">
        <!-- Informasi Dasar -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Informasi Dasar
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td width="40%"><strong>Kode Inventaris:</strong></td>
                                <td><span class="badge bg-primary fs-6">{{ $inventarisDesa->kode_inventaris }}</span></td>
                            </tr>
                            <tr>
                                <td><strong>Nama Barang:</strong></td>
                                <td>{{ $inventarisDesa->nama_barang }}</td>
                            </tr>
                            <tr>
                                <td><strong>Kategori:</strong></td>
                                <td><span class="badge bg-info">{{ $inventarisDesa->kategori }}</span></td>
                            </tr>
                            <tr>
                                <td><strong>Merk/Tipe:</strong></td>
                                <td>{{ $inventarisDesa->merk_tipe ?? '-' }}</td>
                            </tr>
                            <tr>
                                <td><strong>Tahun Perolehan:</strong></td>
                                <td>{{ $inventarisDesa->tahun_perolehan ?? '-' }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <tr>
                                <td width="40%"><strong>Kondisi:</strong></td>
                                <td>
                                    @php
                                        $kondisiClass = match($inventarisDesa->kondisi) {
                                            'Baik' => 'success',
                                            'Rusak Ringan' => 'warning',
                                            'Rusak Berat' => 'danger',
                                            'Tidak Dapat Digunakan' => 'dark',
                                            default => 'secondary'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $kondisiClass }} fs-6">{{ $inventarisDesa->kondisi }}</span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Status Pemakaian:</strong></td>
                                <td>
                                    @php
                                        $statusClass = match($inventarisDesa->status_pemakaian) {
                                            'Digunakan' => 'success',
                                            'Tidak Digunakan' => 'secondary',
                                            'Dipinjamkan' => 'info',
                                            'Dalam Perbaikan' => 'warning',
                                            'Hilang' => 'danger',
                                            default => 'secondary'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $statusClass }}">{{ $inventarisDesa->status_pemakaian }}</span>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Lokasi:</strong></td>
                                <td>{{ $inventarisDesa->lokasi_penyimpanan }}</td>
                            </tr>
                            <tr>
                                <td><strong>Penanggung Jawab:</strong></td>
                                <td>{{ $inventarisDesa->penanggung_jawab }}</td>
                            </tr>
                            <tr>
                                <td><strong>Jabatan PJ:</strong></td>
                                <td>{{ $inventarisDesa->jabatan_pj ?? '-' }}</td>
                            </tr>
                        </table>
                    </div>
                </div>
                
                @if($inventarisDesa->deskripsi)
                    <div class="mt-3">
                        <h6>Deskripsi:</h6>
                        <p class="text-muted">{{ $inventarisDesa->deskripsi }}</p>
                    </div>
                @endif
                
                @if($inventarisDesa->alamat_detail)
                    <div class="mt-3">
                        <h6>Alamat Detail:</h6>
                        <p class="text-muted">{{ $inventarisDesa->alamat_detail }}</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Informasi Finansial -->
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-money-bill-wave me-2"></i>
                    Informasi Finansial
                </h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="text-center p-3 bg-light rounded">
                            <h6 class="text-muted mb-1">Harga Perolehan</h6>
                            <h4 class="text-primary mb-0">Rp {{ number_format($inventarisDesa->harga_perolehan, 0, ',', '.') }}</h4>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="text-center p-3 bg-light rounded">
                            <h6 class="text-muted mb-1">Nilai Sekarang</h6>
                            <h4 class="text-success mb-0">Rp {{ number_format($inventarisDesa->nilai_sekarang, 0, ',', '.') }}</h4>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="text-center p-3 bg-light rounded">
                            <h6 class="text-muted mb-1">Sumber Dana</h6>
                            <h5 class="text-info mb-0">{{ $inventarisDesa->sumber_dana ?? '-' }}</h5>
                        </div>
                    </div>
                </div>
                
                @if($inventarisDesa->biaya_maintenance_per_tahun > 0)
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="text-center p-3 bg-light rounded">
                                <h6 class="text-muted mb-1">Biaya Maintenance/Tahun</h6>
                                <h5 class="text-warning mb-0">Rp {{ number_format($inventarisDesa->biaya_maintenance_per_tahun, 0, ',', '.') }}</h5>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>

        <!-- Informasi Maintenance -->
        @if($inventarisDesa->terakhir_maintenance || $inventarisDesa->jadwal_maintenance_berikutnya)
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-tools me-2"></i>
                        Informasi Maintenance
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        @if($inventarisDesa->terakhir_maintenance)
                            <div class="col-md-6">
                                <div class="text-center p-3 bg-light rounded">
                                    <h6 class="text-muted mb-1">Terakhir Maintenance</h6>
                                    <h5 class="text-info mb-0">{{ $inventarisDesa->terakhir_maintenance->format('d F Y') }}</h5>
                                </div>
                            </div>
                        @endif
                        @if($inventarisDesa->jadwal_maintenance_berikutnya)
                            <div class="col-md-6">
                                <div class="text-center p-3 bg-light rounded">
                                    <h6 class="text-muted mb-1">Jadwal Maintenance Berikutnya</h6>
                                    <h5 class="text-warning mb-0">{{ $inventarisDesa->jadwal_maintenance_berikutnya->format('d F Y') }}</h5>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        @endif

        <!-- Dokumentasi -->
        @if($inventarisDesa->foto_barang || $inventarisDesa->dokumen_pendukung)
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-images me-2"></i>
                        Dokumentasi
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        @if($inventarisDesa->foto_barang)
                            <div class="col-md-6">
                                <h6>Foto Barang:</h6>
                                <img src="{{ asset('storage/' . $inventarisDesa->foto_barang) }}" 
                                     alt="Foto {{ $inventarisDesa->nama_barang }}" 
                                     class="img-fluid rounded" 
                                     style="max-height: 200px;">
                            </div>
                        @endif
                        @if($inventarisDesa->dokumen_pendukung)
                            <div class="col-md-6">
                                <h6>Dokumen Pendukung:</h6>
                                <a href="{{ asset('storage/' . $inventarisDesa->dokumen_pendukung) }}" 
                                   target="_blank" class="btn btn-outline-primary">
                                    <i class="fas fa-download me-2"></i>
                                    Download Dokumen
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        @endif

        <!-- Keterangan -->
        @if($inventarisDesa->keterangan)
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-sticky-note me-2"></i>
                        Keterangan
                    </h5>
                </div>
                <div class="card-body">
                    <p class="text-muted">{{ $inventarisDesa->keterangan }}</p>
                </div>
            </div>
        @endif
    </div>
    
    <div class="col-md-4">
        <!-- Aksi -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-cogs me-2"></i>
                    Aksi
                </h6>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.inventaris-desa.edit', $inventarisDesa) }}" class="btn btn-warning">
                        <i class="fas fa-edit me-2"></i>
                        Edit Inventaris
                    </a>
                    <a href="{{ route('admin.inventaris-desa.qr-code', $inventarisDesa) }}" class="btn btn-info">
                        <i class="fas fa-qrcode me-2"></i>
                        Generate QR Code
                    </a>
                    <button type="button" class="btn btn-success" onclick="updateKondisi({{ $inventarisDesa->id }})">
                        <i class="fas fa-tools me-2"></i>
                        Update Kondisi
                    </button>
                    <button type="button" class="btn btn-primary" onclick="updateNilai({{ $inventarisDesa->id }})">
                        <i class="fas fa-money-bill-wave me-2"></i>
                        Update Nilai
                    </button>
                    <hr>
                    <a href="{{ route('admin.inventaris-desa.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>
                        Kembali ke Daftar
                    </a>
                </div>
            </div>
        </div>

        <!-- Informasi Sistem -->
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Informasi Sistem
                </h6>
            </div>
            <div class="card-body">
                <table class="table table-sm table-borderless">
                    <tr>
                        <td><strong>Dibuat oleh:</strong></td>
                        <td>{{ $inventarisDesa->creator->name ?? 'System' }}</td>
                    </tr>
                    <tr>
                        <td><strong>Tanggal Dibuat:</strong></td>
                        <td>{{ $inventarisDesa->created_at->format('d F Y H:i') }}</td>
                    </tr>
                    <tr>
                        <td><strong>Terakhir Diupdate:</strong></td>
                        <td>{{ $inventarisDesa->updated_at->format('d F Y H:i') }}</td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Update Kondisi Modal -->
<div class="modal fade" id="updateKondisiModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Update Kondisi Inventaris</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="updateKondisiForm" method="POST">
                @csrf
                @method('POST')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Kondisi Baru</label>
                        <select name="kondisi" class="form-select" required>
                            <option value="Baik">Baik</option>
                            <option value="Rusak Ringan">Rusak Ringan</option>
                            <option value="Rusak Berat">Rusak Berat</option>
                            <option value="Tidak Dapat Digunakan">Tidak Dapat Digunakan</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Keterangan</label>
                        <textarea name="keterangan" class="form-control" rows="3" placeholder="Keterangan perubahan kondisi..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Update Kondisi</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Update Nilai Modal -->
<div class="modal fade" id="updateNilaiModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Update Nilai Inventaris</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="updateNilaiForm" method="POST">
                @csrf
                @method('POST')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Nilai Sekarang</label>
                        <div class="input-group">
                            <span class="input-group-text">Rp</span>
                            <input type="number" name="nilai_sekarang" class="form-control" 
                                   value="{{ $inventarisDesa->nilai_sekarang }}" min="0" step="0.01" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Keterangan</label>
                        <textarea name="keterangan" class="form-control" rows="3" placeholder="Keterangan perubahan nilai..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Update Nilai</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function updateKondisi(id) {
    const form = document.getElementById('updateKondisiForm');
    form.action = `/admin/inventaris-desa/${id}/maintenance`;
    
    const modal = new bootstrap.Modal(document.getElementById('updateKondisiModal'));
    modal.show();
}

function updateNilai(id) {
    const form = document.getElementById('updateNilaiForm');
    form.action = `/admin/inventaris-desa/${id}/update-nilai`;
    
    const modal = new bootstrap.Modal(document.getElementById('updateNilaiModal'));
    modal.show();
}
</script>
@endpush
