@extends('layouts.app')

@section('title', 'Kegiatan Pembangunan')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
<li class="breadcrumb-item active">Kegiatan Pembangunan</li>
@endsection

@section('content')
<div class="container-fluid">
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-building text-primary me-2"></i>
                        Kegiatan Pembangunan Desa
                    </h4>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">
                        <i class="fas fa-plus me-1"></i>
                        Tambah Kegiatan
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="kegiatanTable">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Nama Kegiatan</th>
                                    <th>Lokasi</th>
                                    <th>Anggaran</th>
                                    <th>Progress</th>
                                    <th>Status</th>
                                    <th>Tahun</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($kegiatan ?? [] as $index => $item)
                                <tr>
                                    <td>{{ $index + 1 }}</td>
                                    <td>
                                        <div>
                                            <strong>{{ $item->nama_kegiatan }}</strong><br>
                                            <small class="text-muted">{{ $item->jenis_kegiatan }}</small>
                                        </div>
                                    </td>
                                    <td>{{ $item->lokasi }}</td>
                                    <td>Rp {{ number_format($item->total_anggaran, 0, ',', '.') }}</td>
                                    <td>
                                        <div class="progress" style="height: 20px;">
                                            <div class="progress-bar bg-{{ $item->progress >= 100 ? 'success' : ($item->progress >= 50 ? 'warning' : 'danger') }}" 
                                                 style="width: {{ $item->progress }}%">
                                                {{ $item->progress }}%
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @if($item->status == 'perencanaan')
                                            <span class="badge bg-info">Perencanaan</span>
                                        @elseif($item->status == 'pelaksanaan')
                                            <span class="badge bg-warning">Pelaksanaan</span>
                                        @elseif($item->status == 'selesai')
                                            <span class="badge bg-success">Selesai</span>
                                        @else
                                            <span class="badge bg-danger">Ditunda</span>
                                        @endif
                                    </td>
                                    <td>{{ \Carbon\Carbon::parse($item->tanggal_mulai)->format('Y') }}</td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button class="btn btn-sm btn-info" onclick="showDetail({{ $item->id }})">
                                                <i class="fas fa-eye"></i>
                                            </button>
                                            <button class="btn btn-sm btn-warning" onclick="editKegiatan({{ $item->id }})">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button class="btn btn-sm btn-success" onclick="updateProgress({{ $item->id }})">
                                                <i class="fas fa-chart-line"></i>
                                            </button>
                                            <button class="btn btn-sm btn-danger" onclick="deleteKegiatan({{ $item->id }})">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">Belum ada data kegiatan pembangunan</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Tambah Kegiatan Pembangunan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.kegiatan-pembangunan.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nama Kegiatan</label>
                                <input type="text" class="form-control" name="nama_kegiatan" value="{{ old('nama_kegiatan') }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Jenis Kegiatan</label>
                                <select class="form-select" name="jenis_kegiatan" required>
                                    <option value="">Pilih Jenis</option>
                                    <option value="fisik" {{ old('jenis_kegiatan') == 'fisik' ? 'selected' : '' }}>Fisik</option>
                                    <option value="non_fisik" {{ old('jenis_kegiatan') == 'non_fisik' ? 'selected' : '' }}>Non Fisik</option>
                                    <option value="infrastruktur" {{ old('jenis_kegiatan') == 'infrastruktur' ? 'selected' : '' }}>Infrastruktur</option>
                                    <option value="pemberdayaan" {{ old('jenis_kegiatan') == 'pemberdayaan' ? 'selected' : '' }}>Pemberdayaan</option>
                                    <option value="kesehatan" {{ old('jenis_kegiatan') == 'kesehatan' ? 'selected' : '' }}>Kesehatan</option>
                                    <option value="pendidikan" {{ old('jenis_kegiatan') == 'pendidikan' ? 'selected' : '' }}>Pendidikan</option>
                                    <option value="ekonomi" {{ old('jenis_kegiatan') == 'ekonomi' ? 'selected' : '' }}>Ekonomi</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Deskripsi</label>
                        <textarea class="form-control" name="deskripsi" rows="3" required>{{ old('deskripsi') }}</textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Lokasi</label>
                                <input type="text" class="form-control" name="lokasi" value="{{ old('lokasi') }}" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Total Anggaran</label>
                                <input type="number" class="form-control" name="total_anggaran" value="{{ old('total_anggaran') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Penanggung Jawab</label>
                                <input type="text" class="form-control" name="penanggung_jawab" value="{{ old('penanggung_jawab') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Tanggal Mulai</label>
                                <input type="date" class="form-control" name="tanggal_mulai" value="{{ old('tanggal_mulai') }}" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label">Tanggal Target Selesai</label>
                                <input type="date" class="form-control" name="tanggal_selesai_rencana" value="{{ old('tanggal_selesai_rencana') }}" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Sumber Dana</label>
                                <select class="form-select" name="sumber_dana" required>
                                    <option value="">Pilih Sumber Dana</option>
                                    <option value="dana_desa" {{ old('sumber_dana') == 'dana_desa' ? 'selected' : '' }}>Dana Desa</option>
                                    <option value="add" {{ old('sumber_dana') == 'add' ? 'selected' : '' }}>ADD</option>
                                    <option value="pad" {{ old('sumber_dana') == 'pad' ? 'selected' : '' }}>PAD</option>
                                    <option value="apbd_kabupaten" {{ old('sumber_dana') == 'apbd_kabupaten' ? 'selected' : '' }}>APBD Kabupaten</option>
                                    <option value="apbd_provinsi" {{ old('sumber_dana') == 'apbd_provinsi' ? 'selected' : '' }}>APBD Provinsi</option>
                                    <option value="apbn" {{ old('sumber_dana') == 'apbn' ? 'selected' : '' }}>APBN</option>
                                    <option value="swadaya" {{ old('sumber_dana') == 'swadaya' ? 'selected' : '' }}>Swadaya</option>
                                    <option value="hibah" {{ old('sumber_dana') == 'hibah' ? 'selected' : '' }}>Hibah</option>
                                    <option value="csr" {{ old('sumber_dana') == 'csr' ? 'selected' : '' }}>CSR</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Latitude</label>
                                <input type="number" step="any" class="form-control" name="latitude" value="{{ old('latitude') }}" placeholder="Contoh: -6.2088">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Longitude</label>
                                <input type="number" step="any" class="form-control" name="longitude" value="{{ old('longitude') }}" placeholder="Contoh: 106.8456">
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Foto Kegiatan</label>
                        <input type="file" class="form-control" name="foto[]" multiple accept=".jpg,.jpeg,.png">
                        <small class="text-muted">Format: JPG, PNG (Max: 5 foto, 2MB per foto)</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Progress Update Modal -->
<div class="modal fade" id="progressModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Update Progress Kegiatan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="progressForm" method="POST">
                @csrf
                @method('PUT')
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Progress (%)</label>
                        <input type="range" class="form-range" name="progress" id="progressRange" min="0" max="100" value="0" oninput="updateProgressValue(this.value)">
                        <div class="d-flex justify-content-between">
                            <span>0%</span>
                            <span id="progressValue">0%</span>
                            <span>100%</span>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" name="status" id="progressStatus" required>
                            <option value="perencanaan">Perencanaan</option>
                            <option value="pelaksanaan">Pelaksanaan</option>
                            <option value="selesai">Selesai</option>
                            <option value="ditunda">Ditunda</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Keterangan Progress</label>
                        <textarea class="form-control" name="keterangan_progress" rows="3"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Foto Progress</label>
                        <input type="file" class="form-control" name="foto_progress[]" multiple accept=".jpg,.jpeg,.png">
                        <small class="text-muted">Upload foto terbaru dari kegiatan</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Update Progress</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function updateProgress(id) {
    fetch(`{{ route('admin.kegiatan-pembangunan.index') }}/${id}`)
        .then(response => response.json())
        .then(data => {
            document.getElementById('progressRange').value = data.progress;
            document.getElementById('progressValue').textContent = data.progress + '%';
            document.getElementById('progressStatus').value = data.status;
            
            document.getElementById('progressForm').action = `{{ route('admin.kegiatan-pembangunan.index') }}/${id}`;
            
            new bootstrap.Modal(document.getElementById('progressModal')).show();
        });
}

function updateProgressValue(value) {
    document.getElementById('progressValue').textContent = value + '%';
    
    // Auto-update status based on progress
    const statusSelect = document.getElementById('progressStatus');
    if (value == 0) {
        statusSelect.value = 'perencanaan';
    } else if (value > 0 && value < 100) {
        statusSelect.value = 'pelaksanaan';
    } else if (value == 100) {
        statusSelect.value = 'selesai';
    }
}

function editKegiatan(id) {
    fetch(`{{ route('admin.kegiatan-pembangunan.index') }}/${id}`)
        .then(response => response.json())
        .then(data => {
            // Populate edit form (you can create similar edit modal as add modal)
            console.log('Edit data:', data);
            alert('Edit functionality will be implemented');
        });
}

function deleteKegiatan(id) {
    if (confirm('Apakah Anda yakin ingin menghapus kegiatan ini?')) {
        fetch(`{{ route('admin.kegiatan-pembangunan.index') }}/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        });
    }
}

function showDetail(id) {
    fetch(`{{ route('admin.kegiatan-pembangunan.index') }}/${id}`)
        .then(response => response.json())
        .then(data => {
            let photos = '';
            if (data.foto && data.foto.length > 0) {
                photos = data.foto.map(foto => `<img src="${foto}" class="img-thumbnail me-2" style="height: 100px;">`).join('');
            }
            
            let content = `
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Nama:</strong> ${data.nama_kegiatan}</p>
                        <p><strong>Jenis:</strong> ${data.jenis_kegiatan}</p>
                        <p><strong>Lokasi:</strong> ${data.lokasi}</p>
                        <p><strong>Anggaran:</strong> Rp ${new Intl.NumberFormat('id-ID').format(data.anggaran)}</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Progress:</strong> ${data.progress}%</p>
                        <p><strong>Status:</strong> ${data.status}</p>
                        <p><strong>Tahun:</strong> ${data.tahun_pelaksanaan}</p>
                        <p><strong>Koordinat:</strong> ${data.latitude || '-'}, ${data.longitude || '-'}</p>
                    </div>
                </div>
                <p><strong>Deskripsi:</strong> ${data.deskripsi}</p>
                ${photos ? '<p><strong>Foto:</strong></p>' + photos : ''}
            `;
            
            Swal.fire({
                title: 'Detail Kegiatan Pembangunan',
                html: content,
                icon: 'info',
                confirmButtonText: 'Tutup',
                width: '80%'
            });
        });
}
</script>
@endpush 
