@extends('layouts.app')

@section('title', 'Data Keluarga')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Data Keluarga</li>
@endsection

@section('content')
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-home me-2 text-success"></i>
            Data Keluarga
        </h2>
        <p class="text-muted mb-0">Kelola data keluarga dan kartu keluarga (KK)</p>
    </div>
    <div>
        <button type="button" class="btn btn-gradient-info me-2" data-bs-toggle="modal" data-bs-target="#importModal">
            <i class="fas fa-upload me-2"></i>
            Import Data
        </button>
        <a href="{{ route('admin.keluarga.create') }}" class="btn btn-gradient-success">
            <i class="fas fa-plus me-2"></i>
            Tambah Keluarga
        </a>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-success me-3">
                    <i class="fas fa-home"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['total_keluarga'] ?? 0 }}</h4>
                    <small class="text-muted">Total Keluarga</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-primary me-3">
                    <i class="fas fa-users"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['total_anggota'] ?? 0 }}</h4>
                    <small class="text-muted">Total Anggota</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-info me-3">
                    <i class="fas fa-male"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['kepala_keluarga_laki'] ?? 0 }}</h4>
                    <small class="text-muted">KK Laki-laki</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-pink me-3">
                    <i class="fas fa-female"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['kepala_keluarga_perempuan'] ?? 0 }}</h4>
                    <small class="text-muted">KK Perempuan</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters & View Options -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row align-items-center">
            <div class="col-md-8">
                <div class="row">
                    <div class="col-md-4">
                        <label class="form-label">Pencarian</label>
                        <div class="input-group">
                            <span class="input-group-text">
                                <i class="fas fa-search"></i>
                            </span>
                            <input type="text" class="form-control" id="searchInput" placeholder="Cari nomor KK atau nama...">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Urutkan</label>
                        <select class="form-select" id="sortBy">
                            <option value="no_kk">Nomor KK</option>
                            <option value="kepala_keluarga">Nama Kepala Keluarga</option>
                            <option value="jumlah_anggota">Jumlah Anggota</option>
                            <option value="created_at">Tanggal Dibuat</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Jumlah Anggota</label>
                        <select class="form-select" id="filterMembers">
                            <option value="">Semua</option>
                            <option value="1">1 orang</option>
                            <option value="2-4">2-4 orang</option>
                            <option value="5-7">5-7 orang</option>
                            <option value="8+">8+ orang</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="button" class="btn btn-primary" onclick="applyFilters()">
                                <i class="fas fa-filter"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 text-end">
                <label class="form-label">Tampilan</label>
                <div class="btn-group d-block" role="group">
                    <button type="button" class="btn btn-outline-secondary active" id="cardViewBtn" onclick="switchView('card')">
                        <i class="fas fa-th-large"></i> Kartu
                    </button>
                    <button type="button" class="btn btn-outline-secondary" id="tableViewBtn" onclick="switchView('table')">
                        <i class="fas fa-list"></i> Tabel
                    </button>
                </div>
                <div class="btn-group ms-2">
                    <button type="button" class="btn btn-outline-success dropdown-toggle" data-bs-toggle="dropdown">
                        <i class="fas fa-download me-2"></i>Export
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="{{ route('admin.keluarga.export', 'pdf') }}">
                            <i class="fas fa-file-pdf me-2"></i>PDF
                        </a></li>
                        <li><a class="dropdown-item" href="{{ route('admin.keluarga.export', 'excel') }}">
                            <i class="fas fa-file-excel me-2"></i>Excel
                        </a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Card View -->
<div id="cardView" class="row">
    @forelse($keluarga as $k)
    <div class="col-lg-4 col-md-6 mb-4 family-card" 
                         data-search="{{ strtolower($k->no_kk . ' ' . (optional($k->kepalaKeluarga)->nama ?? '')) }}"
         data-members="{{ $k->jumlah_anggota }}">
        <div class="card family-card-item">
            <div class="card-header bg-gradient-success text-white">
                <div class="d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">
                        <i class="fas fa-id-card me-2"></i>
                        KK: {{ $k->no_kk }}
                    </h6>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-light dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-cog"></i>
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="{{ route('admin.keluarga.show', $k->id) }}">
                                <i class="fas fa-eye me-2"></i>Detail
                            </a></li>
                            <li><a class="dropdown-item" href="{{ route('admin.keluarga.edit', $k->id) }}">
                                <i class="fas fa-edit me-2"></i>Edit
                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item text-danger" href="#" onclick="deleteKeluarga({{ $k->id }})">
                                <i class="fas fa-trash me-2"></i>Hapus
                            </a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-8">
                        <h5 class="card-title">{{ optional($k->kepalaKeluarga)->nama ?? 'Tidak ada data' }}</h5>
                        <p class="text-muted mb-2">
                            <i class="fas fa-map-marker-alt me-1"></i>
                            {{ $k->alamat ?? 'Alamat tidak tersedia' }}
                        </p>
                    </div>
                    <div class="col-4 text-end">
                        <div class="family-avatar">
                            @if(optional($k->kepalaKeluarga)->foto)
                                <img src="{{ Storage::url(optional($k->kepalaKeluarga)->foto) }}" 
                                     class="rounded-circle" 
                                     width="60" height="60"
                                     alt="Foto Kepala Keluarga">
                            @else
                                <div class="avatar-placeholder">
                                    <i class="fas fa-user fa-2x"></i>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="family-info mt-3">
                    <div class="row text-center">
                        <div class="col-4">
                            <div class="info-item">
                                <h4 class="text-primary">{{ $k->jumlah_anggota }}</h4>
                                <small class="text-muted">Anggota</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="info-item">
                                                                    <h4 class="text-info">{{ $k->anggotaKeluarga ? $k->anggotaKeluarga->filter(function($anggota) { return $anggota->penduduk && $anggota->penduduk->jenis_kelamin === 'L'; })->count() : 0 }}</h4>
                                <small class="text-muted">Laki-laki</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="info-item">
                                                                    <h4 class="text-pink">{{ $k->anggotaKeluarga ? $k->anggotaKeluarga->filter(function($anggota) { return $anggota->penduduk && $anggota->penduduk->jenis_kelamin === 'P'; })->count() : 0 }}</h4>
                                <small class="text-muted">Perempuan</small>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Family Members Preview -->
                                                @if($k->anggotaKeluarga && $k->anggotaKeluarga->count() > 1)
                <div class="family-members mt-3">
                    <small class="text-muted">Anggota Keluarga:</small>
                    <div class="members-list mt-1">
                        @foreach($k->anggotaKeluarga->take(3) as $anggota)
                            @if($anggota->status_keluarga !== 'Kepala Keluarga')
                            <span class="badge bg-light text-dark me-1 mb-1">
                                {{ $anggota->penduduk->nama ?? 'Tidak ada data' }}
                            </span>
                            @endif
                        @endforeach
                        @if($k->anggotaKeluarga && $k->anggotaKeluarga->count() > 3)
                        <span class="badge bg-secondary">
                            +{{ $k->anggotaKeluarga->count() - 3 }} lainnya
                        </span>
                        @endif
                    </div>
                </div>
                @endif
            </div>
            <div class="card-footer bg-light">
                <div class="d-flex justify-content-between align-items-center">
                    <small class="text-muted">
                        <i class="fas fa-calendar me-1"></i>
                        {{ $k->created_at->format('d/m/Y') }}
                    </small>
                    <div>
                        <a href="{{ route('admin.keluarga.show', $k->id) }}" class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-eye me-1"></i>Detail
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @empty
    <div class="col-12">
        <div class="text-center py-5">
            <i class="fas fa-home fa-3x text-muted mb-3"></i>
            <h5 class="text-muted">Belum ada data keluarga</h5>
            <p class="text-muted">Klik tombol "Tambah Keluarga" untuk memulai</p>
            <a href="{{ route('admin.keluarga.create') }}" class="btn btn-gradient-success">
                <i class="fas fa-plus me-2"></i>
                Tambah Keluarga Pertama
            </a>
        </div>
    </div>
    @endforelse
</div>

<!-- Table View (Initially Hidden) -->
<div id="tableView" style="display: none;">
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="keluargaTable">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>No. KK</th>
                            <th>Kepala Keluarga</th>
                            <th>Alamat</th>
                            <th>Jumlah Anggota</th>
                            <th>Tgl Dibuat</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($keluarga as $index => $k)
                        <tr>
                            <td>{{ $index + 1 }}</td>
                            <td>
                                <span class="text-monospace">{{ $k->no_kk }}</span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @if(optional($k->kepalaKeluarga)->foto)
                                        <img src="{{ Storage::url(optional($k->kepalaKeluarga)->foto) }}" 
                                             class="rounded-circle me-2" 
                                             width="40" height="40">
                                    @else
                                        <div class="avatar-placeholder-sm me-2">
                                            <i class="fas fa-user"></i>
                                        </div>
                                    @endif
                                    <div>
                                        <strong>{{ optional($k->kepalaKeluarga)->nama ?? 'Tidak ada data' }}</strong>
                                        @if(optional($k->kepalaKeluarga)->nik)
                                        <br><small class="text-muted">{{ optional($k->kepalaKeluarga)->nik }}</small>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td>{{ $k->alamat ?? '-' }}</td>
                            <td>
                                <span class="badge bg-primary">{{ $k->jumlah_anggota }} orang</span>
                            </td>
                            <td>{{ $k->created_at->format('d/m/Y') }}</td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    <a href="{{ route('admin.keluarga.show', $k->id) }}" 
                                       class="btn btn-outline-info" title="Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.keluarga.edit', $k->id) }}" 
                                       class="btn btn-outline-warning" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" 
                                            class="btn btn-outline-danger" 
                                            onclick="deleteKeluarga({{ $k->id }})" 
                                            title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Pagination -->
@if($keluarga->hasPages())
<div class="d-flex justify-content-center mt-4">
    {{ $keluarga->links() }}
</div>
@endif

<!-- Import Modal -->
<div class="modal fade" id="importModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-upload me-2"></i>
                    Import Data Keluarga
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="{{ route('admin.keluarga.import') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">File Excel</label>
                        <input type="file" class="form-control" name="file" accept=".xlsx,.xls" required>
                        <div class="form-text">
                            Format yang didukung: .xlsx, .xls (maksimal 5MB)
                        </div>
                    </div>
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        <strong>Template Excel:</strong>
                        <br>Kolom yang diperlukan: No KK, Kepala Keluarga, Alamat, RT, RW
                        <br><a href="{{ route('admin.keluarga.template') }}" class="text-decoration-none">
                            <i class="fas fa-download me-1"></i>Download Template
                        </a>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-upload me-2"></i>Import Data
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .bg-pink {
        background-color: #e91e63 !important;
    }
    
    .text-pink {
        color: #e91e63 !important;
    }
    
    .stats-icon.bg-pink {
        background: linear-gradient(135deg, #e91e63 0%, #ad1457 100%) !important;
    }
    
    .family-card-item {
        transition: all 0.3s ease;
        border: none;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    
    .family-card-item:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    }
    
    .bg-gradient-success {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    }
    
    .family-avatar .avatar-placeholder {
        width: 60px;
        height: 60px;
        background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
    }
    
    .avatar-placeholder-sm {
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 0.875rem;
    }
    
    .info-item h4 {
        margin-bottom: 0;
        font-weight: 600;
    }
    
    .family-members .badge {
        font-size: 0.75rem;
    }
    
    .text-monospace {
        font-family: 'Courier New', Courier, monospace;
        font-size: 0.9em;
    }
    
    .card-header.bg-gradient-success {
        border: none;
    }
    
    .btn-group .btn {
        border-radius: 0.375rem;
        margin-right: 2px;
    }
    
    .btn-group .btn.active {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border-color: #667eea;
        color: white;
    }
    
    .members-list {
        max-height: 60px;
        overflow: hidden;
    }
    
    .family-card[data-hidden="true"] {
        display: none;
    }
</style>
@endpush

@push('scripts')
<script>
$(document).ready(function() {
    // Initialize DataTable for table view
    $('#keluargaTable').DataTable({
        responsive: true,
        pageLength: 25,
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json'
        },
        columnDefs: [
            { orderable: false, targets: [6] }
        ]
    });
});

// Switch between card and table view
function switchView(view) {
    const cardView = document.getElementById('cardView');
    const tableView = document.getElementById('tableView');
    const cardBtn = document.getElementById('cardViewBtn');
    const tableBtn = document.getElementById('tableViewBtn');
    
    if (view === 'card') {
        cardView.style.display = 'block';
        tableView.style.display = 'none';
        cardBtn.classList.add('active');
        tableBtn.classList.remove('active');
    } else {
        cardView.style.display = 'none';
        tableView.style.display = 'block';
        tableBtn.classList.add('active');
        cardBtn.classList.remove('active');
    }
}

// Apply filters
function applyFilters() {
    const searchTerm = document.getElementById('searchInput').value.toLowerCase();
    const memberFilter = document.getElementById('filterMembers').value;
    const sortBy = document.getElementById('sortBy').value;
    
    const cards = document.querySelectorAll('.family-card');
    let visibleCards = [];
    
    cards.forEach(card => {
        const searchData = card.getAttribute('data-search');
        const memberCount = parseInt(card.getAttribute('data-members'));
        let show = true;
        
        // Search filter
        if (searchTerm && !searchData.includes(searchTerm)) {
            show = false;
        }
        
        // Member count filter
        if (memberFilter) {
            switch(memberFilter) {
                case '1':
                    if (memberCount !== 1) show = false;
                    break;
                case '2-4':
                    if (memberCount < 2 || memberCount > 4) show = false;
                    break;
                case '5-7':
                    if (memberCount < 5 || memberCount > 7) show = false;
                    break;
                case '8+':
                    if (memberCount < 8) show = false;
                    break;
            }
        }
        
        card.setAttribute('data-hidden', !show);
        card.style.display = show ? 'block' : 'none';
        
        if (show) {
            visibleCards.push(card);
        }
    });
    
    // Sort visible cards
    if (sortBy && visibleCards.length > 0) {
        sortCards(visibleCards, sortBy);
    }
    
    // Show message if no results
    const noResultsMsg = document.getElementById('noResultsMessage');
    if (visibleCards.length === 0) {
        if (!noResultsMsg) {
            const message = document.createElement('div');
            message.id = 'noResultsMessage';
            message.className = 'col-12 text-center py-5';
            message.innerHTML = `
                <i class="fas fa-search fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Tidak ada hasil ditemukan</h5>
                <p class="text-muted">Coba ubah kriteria pencarian Anda</p>
            `;
            document.getElementById('cardView').appendChild(message);
        }
    } else {
        if (noResultsMsg) {
            noResultsMsg.remove();
        }
    }
    
    showToast(`Menampilkan ${visibleCards.length} dari ${cards.length} keluarga`, 'info');
}

// Sort cards
function sortCards(cards, sortBy) {
    const container = document.getElementById('cardView');
    
    cards.sort((a, b) => {
        const aCard = a.querySelector('.card');
        const bCard = b.querySelector('.card');
        
        switch(sortBy) {
            case 'no_kk':
                const aKK = aCard.querySelector('.card-header h6').textContent.split(': ')[1];
                const bKK = bCard.querySelector('.card-header h6').textContent.split(': ')[1];
                return aKK.localeCompare(bKK);
                
            case 'kepala_keluarga':
                const aName = aCard.querySelector('.card-title').textContent;
                const bName = bCard.querySelector('.card-title').textContent;
                return aName.localeCompare(bName);
                
            case 'jumlah_anggota':
                const aMembers = parseInt(a.getAttribute('data-members'));
                const bMembers = parseInt(b.getAttribute('data-members'));
                return bMembers - aMembers;
                
            default:
                return 0;
        }
    });
    
    // Re-append sorted cards
    cards.forEach(card => {
        container.appendChild(card);
    });
}

// Delete keluarga
function deleteKeluarga(id) {
    if (confirm('Apakah Anda yakin ingin menghapus data keluarga ini?\n\nPerhatian: Anggota keluarga akan tetap ada namun tidak terikat dengan kartu keluarga.')) {
        showLoading();
        
        fetch(`/admin/keluarga/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Data keluarga berhasil dihapus', 'success');
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } else {
                showToast(data.message || 'Gagal menghapus data keluarga', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan saat menghapus data', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

// Real-time search
document.getElementById('searchInput').addEventListener('input', function() {
    clearTimeout(this.searchTimeout);
    this.searchTimeout = setTimeout(() => {
        applyFilters();
    }, 300);
});

// Auto-apply filters when selects change
document.getElementById('filterMembers').addEventListener('change', applyFilters);
document.getElementById('sortBy').addEventListener('change', applyFilters);

// Initialize tooltips
$(function () {
    $('[title]').tooltip();
});
</script>
@endpush 
